<?php

/**
 * LoginForm class.
 * LoginForm is the data structure for keeping
 * user login form data. It is used by the 'login' action of 'SiteController'.
 */
class XeroSetting extends CFormModel {

    public $clientId;
    public $clientSecret;
    public $redirectUri;
    public $urlAuthorize;
    public $urlAccessToken;
    public $urlResourceOwnerDetails;
    public $shortDesc;
    public $longDesc;
    public $sendInvAutoXero;
    public $defalutInvoiceAccountId;
    public $defalutPOAccountId;

    /**
     * Declares the validation rules.
     * The rules state that username and password are required,
     * and password needs to be authenticated.
     */
    public function rules() {
        return array(
            array('clientId, clientSecret, redirectUri, urlAuthorize, urlAccessToken, urlResourceOwnerDetails', 'required'),
            array('clientId, clientSecret', 'length', 'min' => 10, 'max' => 100),
            array('shortDesc, longDesc, sendInvAutoXero, defalutInvoiceAccountId, defalutPOAccountId', 'numerical'),
            array('shortDesc, longDesc, sendInvAutoXero, defalutInvoiceAccountId, defalutPOAccountId, redirectUri, urlAuthorize, urlAccessToken, urlResourceOwnerDetails', 'safe', 'on' => 'search'),
        );
    }

    /**
     * Declares attribute labels.
     */
    public function attributeLabels() {
        return array(
            'clientId' => 'Client ID',
            'clientSecret' => 'Client Secret',
            'redirectUri' => 'Redirect URI',
            'urlAuthorize' => 'Authorize URL',
            'urlAccessToken' => 'Access Token URL',
            'urlResourceOwnerDetails' => 'Resource Owner Details URL',
            'sendInvAutoXero' => 'Send Invoice Automatically to Xero',
            'defalutInvoiceAccountId' => 'Default Invoice Account',
            'defalutPOAccountId' => 'Default PO Account',
            'shortDesc' => 'Short Description',
            'longDesc' => 'Long Descrption'
            
        );
    }

    public static function getSetting() {
        $model = new XeroSetting();
        $file = fopen("protected/filemodels/xerosettings.csv", "r");
        $propertyArr = array();
        while (!feof($file)) {
            $line = fgets($file);
            $pairs = explode('=>', $line);
            $propertyArr[$pairs[0]] = $pairs[1];
        }
        fclose($file);
        
        $intCastFields = array(            
            'shortDesc',
            'longDesc',
            'sendInvAutoXero',
            'defalutInvoiceAccountId',
            'defalutPOAccountId'
            
            
        );

        foreach ($model->attributeLabels() as $attr => $lbl) {

            if (in_array($attr, $intCastFields)) {
                $model->$attr = intval($propertyArr[$attr]);
            } else {
                $model->$attr = $propertyArr[$attr];
            }
        }


        return $model;
    }

    /**
     * @return array GenericProviderOptions
     */
    public static function getGenericProviderOptions() {
        $xeroSetting = self::getSetting();
        return array(
            'clientId' => trim($xeroSetting->clientId),
            'clientSecret' => trim($xeroSetting->clientSecret),
            'redirectUri' => trim($xeroSetting->redirectUri),
            'urlAuthorize' => trim($xeroSetting->urlAuthorize),
            'urlAccessToken' => trim($xeroSetting->urlAccessToken),
            'urlResourceOwnerDetails' => trim($xeroSetting->urlResourceOwnerDetails)
        );
    }

}
