<?php

/**
 * This is the model class for table "xero_supplier".
 *
 * The followings are the available columns in table 'xero_supplier':
 * @property integer $supsno
 * @property string $supsup
 * @property string $supsup_fref
 * @property string $supnam
 * @property string $supad1
 * @property string $supad2
 * @property string $supad3
 * @property string $suptown
 * @property string $supstate
 * @property string $suppostcode
 * @property integer $supcousno
 * @property integer $suptypsno
 * @property string $suptel
 * @property string $supfax
 * @property string $supemail
 * @property double $supmrate
 * @property string $supucdnew
 * @property string $supentddt
 * @property string $supenttime
 * @property string $supucdame
 * @property string $supameddt
 * @property string $supametime
 * @property string $xeroContactID
 * @property string $orderingWebsite
 * @property string $orderingUsername
 * @property string $orderingPassword
 * @property string $supcontact
 * @property string $supnotes
 * @property string $supimgpath
 */
class XeroSupplier extends CActiveRecord
{
	/**
	 * Returns the static model of the specified AR class.
	 * @param string $className active record class name.
	 * @return XeroSupplier the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}

	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return 'xero_supplier';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
			array('supsup_fref, supnam', 'required'),
			array('supcousno, suptypsno', 'numerical', 'integerOnly'=>true),
			array('supmrate', 'numerical'),
			array('supsup, supsup_fref', 'length', 'max'=>50),
			array('supnam', 'length', 'max'=>80),
			array('supad1, supad2, supad3, suptown', 'length', 'max'=>40),
			array('supstate, supucdnew, supucdame', 'length', 'max'=>30),
			array('suppostcode', 'length', 'max'=>10),
			array('suptel, supfax', 'length', 'max'=>15),
			array('supemail', 'length', 'max'=>100),
			array('xeroContactID, orderingUsername, orderingPassword, supcontact', 'length', 'max'=>255),
			array('supentddt, supenttime, supameddt, supametime, orderingWebsite, supnotes, supimgpath', 'safe'),
			// The following rule is used by search().
			// Please remove those attributes that should not be searched.
			array('supsno, supsup, supsup_fref, supnam, supad1, supad2, supad3, suptown, supstate, suppostcode, supcousno, suptypsno, suptel, supfax, supemail, supmrate, supucdnew, supentddt, supenttime, supucdame, supameddt, supametime, xeroContactID, orderingWebsite, orderingUsername, orderingPassword, supcontact, supnotes, supimgpath', 'safe', 'on'=>'search'),
		);
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'supsno' => 'ID',
			'supsup' => 'Code',
			'supsup_fref' => 'Supplier Reference',
			'supnam' => 'Supplier Name',
			'supad1' => 'Address',
			'supad2' => 'Address 2',
			'supad3' => 'Address 3',
			'suptown' => 'Town',
			'supstate' => 'State',
			'suppostcode' => 'Postal Code',
			'supcousno' => 'Supcousno',
			'suptypsno' => 'Suptypsno',
			'suptel' => 'Telephone',
			'supfax' => 'Fax',
			'supemail' => 'E-mail',
			'supmrate' => 'Mark-Up Rate(%)',
			'supucdnew' => 'Supucdnew',
			'supentddt' => 'Supentddt',
			'supenttime' => 'Supenttime',
			'supucdame' => 'Supucdame',
			'supameddt' => 'Supameddt',
			'supametime' => 'Supametime',
			'orderingWebsite' => 'Website',
			'orderingUsername' => 'Username',
			'orderingPassword' => 'Password',
			'supcontact' => 'Contact Name',
			'supnotes' => 'Notes',
		);
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 * @return CActiveDataProvider the data provider that can return the models based on the search/filter conditions.
	 */
	public function search()
	{
		// Warning: Please modify the following code to remove attributes that
		// should not be searched.

		$criteria=new CDbCriteria;

		$criteria->compare('supsno',$this->supsno);
		$criteria->compare('supsup',$this->supsup,true);
		$criteria->compare('supsup_fref',$this->supsup_fref,true);
		$criteria->compare('supnam',$this->supnam,true);
		$criteria->compare('supad1',$this->supad1,true);
		$criteria->compare('supad2',$this->supad2,true);
		$criteria->compare('supad3',$this->supad3,true);
		$criteria->compare('suptown',$this->suptown,true);
		$criteria->compare('supstate',$this->supstate,true);
		$criteria->compare('suppostcode',$this->suppostcode,true);
		$criteria->compare('supcousno',$this->supcousno);
		$criteria->compare('suptypsno',$this->suptypsno);
		$criteria->compare('suptel',$this->suptel,true);
		$criteria->compare('supfax',$this->supfax,true);
		$criteria->compare('supemail',$this->supemail,true);
		$criteria->compare('supmrate',$this->supmrate);
		$criteria->compare('supucdnew',$this->supucdnew,true);
		$criteria->compare('supentddt',$this->supentddt,true);
		$criteria->compare('supenttime',$this->supenttime,true);
		$criteria->compare('supucdame',$this->supucdame,true);
		$criteria->compare('supameddt',$this->supameddt,true);
		$criteria->compare('supametime',$this->supametime,true);
		$criteria->compare('xeroContactID',$this->xeroContactID,true);
		$criteria->compare('orderingWebsite',$this->orderingWebsite,true);
		$criteria->compare('orderingUsername',$this->orderingUsername,true);
		$criteria->compare('orderingPassword',$this->orderingPassword,true);
		$criteria->compare('supcontact',$this->supcontact,true);
		$criteria->compare('supnotes',$this->supnotes,true);
		$criteria->compare('supimgpath',$this->supimgpath,true);

		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
		));
	}
	
	
	protected function beforeSave()
	{

		$lastsup = Supplier::model()->find(array('order' => 'supsno desc'));
		if ($lastsup) {
			$supcode = $lastsup->supsup;
			$this->supsup = ++$supcode;
			
			//throw new Exception($supcode++);
		} else {
			$this->supsup = 'S0001';
			
		}

		$this->supsup_fref = $this->supsup;
		
		if (empty($this->supcousno))
			$this->supcousno = 0;
		if (empty($this->suptypsno))
			$this->suptypsno = 31;
		if (empty($this->supucdnew))
			$this->supucdnew = 'marc';

		$this->supentddt = date("Y-m-d");
		$this->supenttime = date("H:i:s");
		$this->supameddt = date("Y-m-d");
		$this->supametime = date("H:i:s");



		return parent::beforeSave();
	}
}