<?php
/**
* Rights user controller class file.
*
* @author Aruna Attanayake <aruna470@gmail.com>
* @copyright Copyright &copy; 2011 Aruna Attanayake
* @since 0.9.1
*/
class UserController extends RController
{
	/**
	* @property RAuthorizer
	*/
	private $_authorizer;

	/**
	* Initializes the controller.
	*/
	public function init()
	{
		$this->_authorizer = $this->module->getAuthorizer();
		$this->layout = $this->module->layout;
		$this->defaultAction = 'create';

		// Register the scripts
		$this->module->registerScripts();
	}

	/**
	* @return array action filters
	*/
	public function filters()
	{
		//return array('accessControl');
		return array('rights');
	}

	/**
	* Specifies the access control rules.
	* This method is used by the 'accessControl' filter.
	* @return array access control rules
	*/
	public function accessRules()
	{
		return array(
			array('allow', // Allow superusers to access Rights
				'actions'=>array(
					'create',
					'update',
					'delete'
				),
				'users'=>$this->_authorizer->getSuperusers(),
			),
			array('deny', // Deny all users
				'users'=>array('*'),
			),
		);
	}
	
	public function actionUpdate($id)
	{
		$model = $this->loadModel($id);
		$model->scenario = 'update';
		
		if(isset($_POST['User']))
		{
			$cur_password = $model->password;
			
			$model->attributes=$_POST['User'];
			
			if ($model->validate())
			{
				try
				{
					if (($cur_password != $model->password) && ('' != $model->password))
					{
						$model->password = $model->encryptPassword();
					}
					else
					{
						$model->password = $cur_password;
					}

					if ($model->save(false))
					{					
						Yii::app()->getUser()->setFlash($this->module->flashSuccessKey,
							Rights::t('core', 'User successfully updated.')
						);
			
						Rights::writeLog('User updated.' . json_encode($model->attributes));
			
						$this->redirect(array('create'));						
					}
				}
				catch(Exception $e)
				{
					Yii::app()->getUser()->setFlash($this->module->flashErrorKey,
						Rights::t('core', 'User updation failed.' . $e->getMessage())
					);	
					
					Rights::writeLog('User updation failed.' . $e->getMessage());		
				}
			}			
		}		
		
		// Render the view
		$model->password = '';
		$this->render('update', array('model'=>$model, 
								   'dataProvider'=>$this->getUserListData(),));
	}
	
	public function actionDelete($id)
	{	
		if (Yii::app()->request->isPostRequest)
		{		
			try
			{
				if ($id == Yii::app()->user->id)
				{
					Yii::app()->getUser()->setFlash($this->module->flashErrorKey,
						Rights::t('core', 'You are not allowed to delete your own account.')
					);
					
					Rights::writeLog('Not allowed to delete your own account');
				}
				else
				{					
					$model = $this->loadModel($id);
					$model->delete();
												
					$command = Yii::app()->db->createCommand('DELETE FROM AuthAssignment WHERE userid="' . $id . '"');
					$command->execute();
					
					Rights::writeLog('User deleted.' . json_encode($model->attributes));
					
					Yii::app()->getUser()->setFlash($this->module->flashSuccessKey,
						Rights::t('core', 'User successfully deleted.')
					);
				}
			}
			catch(Exception $e)
			{
				Yii::app()->getUser()->setFlash($this->module->flashErrorKey,
					Rights::t('core', 'User deletion failed.' . $e->getMessage())
				);
				
				Rights::writeLog('User deletion failed.' . $e->getMessage());	
			}
			
			if(!isset($_GET['ajax']))
				$this->redirect(isset($_POST['returnUrl']) ? $_POST['returnUrl'] : array('create'));
		}
		else
			throw new CHttpException(400,'Invalid request. Please do not repeat this request again.');
	}
	
	/* Displays an overview of the users and their assignments.
	*/
	public function actionCreate()
	{
		$model = new User();
		$model->scenario = 'create';
				
		if (isset($_POST['User']))
		{
			$model->attributes = $_POST['User'];
			
			if ($model->validate())
			{
				try
				{
					$pwd_temp = $model->password;
					$model->password = $model->encryptPassword();
					
					if ($model->save(false))
					{					
						Yii::app()->getUser()->setFlash($this->module->flashSuccessKey,
							Rights::t('core', 'User successfully created.')
						);
						Rights::writeLog('User created.' . json_encode($model->attributes));
						
						$this->redirect(array('create'));
					}
				}
				catch(Exception $e)
				{
					Yii::app()->getUser()->setFlash($this->module->flashErrorKey,
						Rights::t('core', 'User creation failed.' . $e->getMessage())
					);		
					Rights::writeLog('User creation failed.' . $e->getMessage());	
				}
				
				$model->password = $pwd_temp;
			}			
		}		
			
		// Render the view
		$this->render('create', array('model'=>$model, 
									  'dataProvider'=>$this->getUserListData(),));
	}

	public function getUserListData()
	{
		$authorizer = $this->module->getAuthorizer();
		$criteria = new CDbCriteria;	
		
		$logged_user_items = $authorizer->getAuthItems(CAuthItem::TYPE_ROLE, Yii::app()->user->id);
		$logged_user_keys = array_keys($logged_user_items);
			
		$criteria->addCondition('id != 0');
			
		$dataProvider = new CActiveDataProvider('User', array('criteria'=>$criteria));
		
		if ($this->module->superuserId != Yii::app()->user->id && 
			!Yii::app()->user->getIsAdminRole())
		{
			// This workaround is to show users with his own role
			// Only administrator ans super admin able to view all users
			
			$data_tmp = array();
			
			foreach($dataProvider->data as $data)
	    	{
	    		$items = $authorizer->getAuthItems(CAuthItem::TYPE_ROLE, $data->id);
	    		$item_keys = array_keys($items);
	    		
	    		if (($logged_user_keys == $item_keys) || empty($item_keys))
	    		{
	    			$data_tmp[] = $data;
	    		}  
	    	}
					
			$dataProvider->setData($data_tmp); 
		}
		
		return $dataProvider;
	}

	public function loadModel($id)
	{
		$model=User::model()->findByPk((int)$id);
		if($model===null)
			throw new CHttpException(404,'The requested page does not exist.');
		return $model;
	}
}
