<?php $this->breadcrumbs = array(
	'Rights'=>Rights::getBaseUrl(),
	Rights::t('core', 'Roles'),
); ?>

<div id="roles">
	

	<h2><?php echo Rights::t('core', 'Roles'); ?></h2>
	
	<div class="grid-small">

	<?php $this->widget('zii.widgets.grid.CGridView', array(
	    'dataProvider'=>$dataProvider,
	    'template'=>'{items}',
	    'emptyText'=>Rights::t('core', 'No roles found.'),
	    //'htmlOptions'=>array('class'=>'grid-view role-table'),
	    //'cssFile'=>Yii::app()->params->adminGridViewCss,
	    'columns'=>array(
    		array(
    			'name'=>'name',
    			'header'=>Rights::t('core', 'Name'),
    			'type'=>'raw',
    			'htmlOptions'=>array('class'=>'name-column'),
    			'value' => '$data->name',
    			//'value'=>'$data->getGridNameLink()',
    		),
    		array(
    			'name'=>'description',
    			'header'=>Rights::t('core', 'Description'),
    			'type'=>'raw',
    			'visible' => false,
    			'htmlOptions'=>array('class'=>'description-column'),
    		),
    		array(
    			'name'=>'bizRule',
    			'header'=>Rights::t('core', 'Business rule'),
    			'type'=>'raw',
    			'htmlOptions'=>array('class'=>'bizrule-column'),
    			'visible'=>Rights::module()->enableBizRule===true,
    		),
    		array(
    			'name'=>'data',
    			'header'=>Rights::t('core', 'Data'),
    			'type'=>'raw',
    			'htmlOptions'=>array('class'=>'data-column'),
    			'visible'=>Rights::module()->enableBizRuleData===true,
    		),
    		/*array(
    			'header'=>'&nbsp;',
    			'type'=>'raw',
    			'htmlOptions'=>array('class'=>'actions-column', 'style'=>'text-align: center'),
    			'value'=>'$data->getDeleteRoleLink()',
    		),*/
    		array(
				'template'=>'{update} {delete} ',
				'class'=>'CButtonColumn',
				'buttons'=>array(
					'delete' => array(
						//'imageUrl'=>Yii::app()->theme->baseUrl . '/images/delete.png',
						'url'=>'Yii::app()->createUrl("/rights/authItem/delete/", array(\'name\'=>urlencode($data->owner->name)))',
					),
					'update' => array(
						//'imageUrl'=>Yii::app()->theme->baseUrl . '/images/edit.png',
						'url'=>'Yii::app()->createUrl("/rights/authItem/update", array(\'name\'=>urlencode($data->owner->name)))',
					),
				),
			),	
	    )
	)); ?>

	<p class="info"><?php //echo Rights::t('core', 'Values within square brackets tell how many children each item has.'); ?></p>
	</div>
</div>