<?php
/**
 * Wrapper class for mpdf library
 *
 * @author Eranga
 */
class PdfPrinter {

    /**
     * @var array pdf configuration
     */
    protected $config = array(// More info: http://mpdf1.com/manual/index.php?tid=184
        'mode' => '', //  This parameter specifies the mode of the new document.
        'format' => 'A4', // format A4, A5, ...
        'default_font_size' => 0, // Sets the default document font size in points (pt)
        'default_font' => 'Arial, Helvetica, sans-serif', // Sets the default font-family for the new document.
        'mgl' => 10, // margin_left. Sets the page margins for the new document.
        'mgr' => 10, // margin_right
        'mgt' => 10, // margin_top
        'mgb' => 10, // margin_bottom
        'mgh' => 5, // margin_header
        'mgf' => 15, // margin_footer
        'orientation' => 'P', // landscape or portrait orientation
    );

    /**
     * @var pdf library instance
     */
    protected $pdfPrinter;

    function __construct($config = null) {
        require_once 'vendor/autoload.php';
        $this->pdfPrinter = new \Mpdf\Mpdf($config ? $config : $this->config);
    }

    /**
     * Overwrite place holders of a pdf 
     * @param string $srcToBeOverwrritten Source file to be overwritten
     * @param string $overwrittenSrc Source for the overwritten 
     * @param string $outputType 'F' for save to given source 'I' for download in client browser
     * @param array $config Place holder names and values in a two separate arrays
     * configuration details including pdf file to be overwritten and the location to save the overwritten pdf
     * 
     * @return string overwritten pdf path
     */
    public function overWrite($srcToBeOverwrritten, $overwrittenSrc, $outputType = 'F', $config = null) {
        $this->pdfPrinter->OverWrite($srcToBeOverwrritten, $config[0], $config[1], $outputType, $overwrittenSrc);
    }

    /**
     * Set a template for the PDF
     * @param string $sourceFile Source of the PDF
     */
    public function setSourceFile($sourceFile = null) {
        $pagecount = $this->pdfPrinter->SetSourceFile($sourceFile ? $sourceFile : 'images/template/common_template.pdf');
        $tplId = $this->pdfPrinter->ImportPage($pagecount);
        $this->pdfPrinter->SetPageTemplate($tplId);
        $this->pdfPrinter->shrink_tables_to_fit = 1;
    }

    /**
     * PDF page layout adjustments
     * @param array $config PDF page adjustments data
     */
    public function addPage($config) {
        $this->pdfPrinter->AddPage(
                $config['orientation'], '', '', '', '', $config['mg_left'], $config['mg_right'], $config['mg_top'], $config['mg_bottom'], $config['mg_header'], $config['mg_footer']
        );
    }

    /**
     * Set document title
     * @param string $title Document title
     */
    public function setTitle($title) {
        $this->pdfPrinter->SetTitle($title);
    }

    /**
     * Set footer of the document
     * @param string $footer Show page number in the footer according to the given format
     */
    public function setFooter($footer) {
        $this->pdfPrinter->setFooter($footer);
    }
    
    /**
     * Set HTML content of the PDF
     * @param string $htmlContent
     */
    public function writeHTML($htmlContent) {
        $this->pdfPrinter->WriteHTML($htmlContent);
    }
    
    /**
     *Print the pdf to the
     */
    public function printOut($src, $outputType = 'I') {        
        $this->pdfPrinter->Output($src, $outputType);
    }

}
