<?php
/**
 * Client class to hide all the dirty stuff of quote main pdf printing
 *
 * @author Eranga
 */
class QuotePdfClient extends PdfClient {

    /**
     * @param CActiveRecord $model Quotation
     */
    function __construct($model) {
        if (!$model instanceof \Quatation) {
            throw new Exception('Instance was not type of Quatation');
        }

        $this->model = $model;
    }

    public function printPdf($content) {
        $pdfPrinter = new PdfPrinter();

        $pdfPrinter->setFooter('{PAGENO} / {nb}');

        $pdfPrinter->SetTitle('Quotation');

        $pdfPrinter->addPage(
                [
                    'orientation' => '',
                    'mg_left' => 5,
                    'mg_right' => 5,
                    'mg_top' => 35,
                    'mg_bottom' => 25,
                    'mg_header' => 0,
                    'mg_footer' => 2,
                ]
        );
        
        $pdfPrinter->writeHTML($content);
        $pdfPrinter->printOut("Quotation_{$this->model->quoteno}.pdf");
    }

}
