<?php

Yii::app()->clientScript->registerScript('search', "
$('.search-button').click(function(){
	$('.search-form').toggle();
	return false;
});
$('.search-form form').submit(function(){
	$.fn.yiiGridView.update('jobs-grid', {
		data: $(this).serialize()
	});
	return false;
});
");
?>

<h1>Consolidate Purchase Order Summary Report</h1>

<div class="view">
    <div class="form">
        <?php
        $form = $this->beginWidget('CActiveForm', array(
            'id' => 'consolidate-purchase-orders-detail-form',
            'enableAjaxValidation' => false,
        ));
        ?>

        <div class="row">
            <label for="createdDtm">Date From</label>
            <?php
            Yii::import('application.extensions.CJuiDateTimePicker.CJuiDateTimePicker');
            $this->widget('CJuiDateTimePicker', array(
                'model' => $model, //Model object
                'attribute' => 'datefrom', //attribute name
                'mode' => 'date', //use "time","date" or "datetime" (default)
                'options' => array(
                    "dateFormat" => 'yy-mm-dd', "changeMonth" => 'true', 'changeYear' => 'true',
                    //                             'minDate'=>$currentTime,
                ), // jquery plugin options
                'language' => 'en-GB'
            ));
            ?>
        </div>
        <div class="row">
            <label for="createdDtm">Date To</label>
            <?php
            Yii::import('application.extensions.CJuiDateTimePicker.CJuiDateTimePicker');
            $this->widget('CJuiDateTimePicker', array(
                'model' => $model, //Model object
                'attribute' => 'dateto', //attribute name
                'mode' => 'date', //use "time","date" or "datetime" (default)
                'options' => array(
                    "dateFormat" => 'yy-mm-dd', "changeMonth" => 'true', 'changeYear' => 'true',
                    //                             'minDate'=>$currentTime,
                ), // jquery plugin options
                'language' => 'en-GB'
            ));
            ?>
        </div>
        <div class="clear"></div>
        <div style="float: left;">
            <?php
            echo CHtml::submitButton('Reset', array('name' => 'reset_btn'));
            echo CHtml::submitButton('Go', array('name' => 'go_btn'));
            ?>
        </div>
        <?php $this->endWidget(); ?>
        <div style="float: right;">
            <?php echo CHtml::button('Print PDF', array('style' => 'float:right;', 'onclick' => 'generatePDF();')); ?>

        </div>
    </div>
    <div class="clear"></div>
</div>
<div class="clear"></div>

<?php

$this->widget('ext.groupgridview.GroupGridView', array(
    'id' => 'sales-person-jobs-grid',
    'dataProvider' => $model->searchMasterPOSummary(),
    'filter' => $model,
    'mergeColumns' => array('masterPONumber'),
    'extraRowColumns' => array('masterPONumber'),
    'extraRowPos' => 'below',
    'extraRowTotals' => function ($data, $row, &$totals) {
        
    },
    'extraRowExpression' => '',
    'summaryText' => '',
    'columns' => array(
        array(
            'name' => 'created_date',
            'value' => 'date("Y-m-d", strtotime($data->created_date))'
        ),
        array(
            'name' => 'masterPONumber'            
        ),
        array(
            'name' => 'subPONumber'           
        ),
        array(
            'name' => 'groupID'   
        ),
        array(
            'name' => 'productCode'   
        ),
        array(
            'name' => 'productName'   
        ),
        array(
            'name' => 'prodQty'   
        ),
        array(
            'name' => 'size'   
        ),
        array(
            'name' => 'qty'   
        ),
        array(
            'name' => 'color'   
        ),        
    ),
));
?>
<script>   

    function generatePDF() {
        var win = window.open('index.php?r=consolidatedPoDetail/printMasterPOSummaryPDF');

    }
</script>
