<?php
$this->menu = array(
        //array('label'=>'List ConsolidatedPurchaseOrder', 'url'=>array('index')),
        //array('label'=>'Create ConsolidatedPurchaseOrder', 'url'=>array('create')),
);

Yii::app()->clientScript->registerScript('search', "
$('.search-button').click(function(){
	$('.search-form').toggle();
	return false;
});
$('.search-form form').submit(function(){
	$.fn.yiiGridView.update('consolidated-purchase-order-grid', {
		data: $(this).serialize()
	});
	return false;
});
");
?>

<h1>Manage Master Purchase Orders</h1>

<p>
    You may optionally enter a comparison operator (<b>&lt;</b>, <b>&lt;=</b>, <b>&gt;</b>, <b>&gt;=</b>, <b>&lt;&gt;</b>
    or <b>=</b>) at the beginning of each of your search values to specify how the comparison should be done.
</p>

<?php echo CHtml::link('Advanced Search', '#', array('class' => 'search-button')); ?>
<div class="search-form" style="display:none">
    <?php
    $this->renderPartial('_search', array(
        'model' => $model,
    ));
    ?>
</div><!-- search-form -->

<?php
$this->widget('zii.widgets.grid.CGridView', array(
    'id' => 'consolidated-purchase-order-grid',
    'dataProvider' => $model->search(),
    'filter' => $model,
    'columns' => array(
        'id',
        'po_number',
        array(
            'name' => 'search_supplier',
        ),
        'po_type',
        'comments',
        array(
            'name'=>'due_date',
            'value'=> 'Refiner::getdatetext($data->due_date, GlobalVars::get("DateFormat"))'
        ),
        array(
            'name'=>'created_date',
            'value'=> 'Refiner::getdatetext($data->created_date, GlobalVars::get("DateFormat"))'
        ),
        
        array(
            'name' => 'status_id',
            'value' => '$data->rel_status()->name',
            'filter' => CHtml::listData(Status::model()->findAll(array('condition' => "name in ('OPEN','CLOSED')")), 'id', 'name'),
        ),
        /*


          'created_by',
         */
        array(
            'class' => 'CButtonColumn',
            'template' => '{view}{sep1}{print}',
            'buttons' => array(
                'view' => array
                    (
                    'label' => 'View',
                    'imageUrl' => false,
                ),
                'sep1' => array
                    (
                    'label' => ' | ',
                    'url' => '',
                    'imageUrl' => false,
                ),
                'print' => array
                    (
                    'label' => 'Print',
                    'imageUrl' => false,
                    'url' => 'Yii::app()->createUrl("consolidatedPurchaseOrder/print", array("id"=>$data->id))',
                    'options' => array('target' => '_blank'),
                ),
            )
        ),
    ),
));
?>
