<?php
$closeMenu = null;
$openMenu = null;

$statusClose = Status::model()->findByAttributes(array('name' => 'CLOSED'));
$statusOpen = Status::model()->findByAttributes(array('name' => 'OPEN'));
if($statusClose->id == $model->status_id){
    $openMenu = array('label' => 'Reopen Master Purchase Order', 'url' => array('consolidatedPurchaseOrder/reOpenMPO', 'id' => $model->id), 'linkOptions' => array('style' => 'background-color:#d1a215'));
}

if($statusOpen->id == $model->status_id){
    $closeMenu = array('label' => 'Close Master Purchase Order', 'url' => array('consolidatedPurchaseOrder/closempo', 'id' => $model->id), 'linkOptions' => array('style' => 'background-color:#d1a215'));
}
$this->menu = array(
    $closeMenu,
    $openMenu,
    //array('label'=>'List ConsolidatedPurchaseOrder', 'url'=>array('index')),
    //array('label'=>'Create ConsolidatedPurchaseOrder', 'url'=>array('create')),
    array('label' => 'Update Purchase Order', 'url' => array('update', 'id' => $model->id)),
    array('label' => 'Delete Purchase Order', 'url' => '#', 'linkOptions' => array('submit' => array('delete', 'id' => $model->id), 'confirm' => 'Are you sure you want to delete this item?')),
    array('label' => 'Manage Purchase Orders', 'url' => array('admin')),
);
?>

<h1>View Master Purchase Order #<?php echo $model->id; ?></h1>
<?php
foreach (Yii::app()->user->getFlashes() as $key => $message) {
    echo '<div class="flash-' . $key . '">' . $message . "</div>\n";
}
?>
<?php
$this->widget('zii.widgets.CDetailView', array(
    'data' => $model,
    'attributes' => array(
        'id',
        'po_number',
        array(
            'name' => 'supplier_id',
            'value' => $model->rel_supplier()->supnam,
        ),
        'po_type',
        'comments',
        array(
            'name' => 'due_date',
            'value' => Refiner::getdatetext($model->due_date, GlobalVars::get("DateFormat"))
        ),
        array(
            'name' => 'created_date',
            'value' => Refiner::getdatetext($model->created_date, GlobalVars::get("DateFormat"))
        ),
        array(
            'name' => 'status_id',
            'value' => $model->rel_status()->name,
        ),
    ),
));


?>




<?php
if ($model->po_type == 'Purchase Product') {

    $this->widget('zii.widgets.grid.CGridView', array(
        'id' => 'po-details-grid',
        'dataProvider' => $dtlmodel->search(),
        'filter' => null,
        'columns' => array(
            'id',
            array(
                'header' => 'References',
                'value' => '($data->rel_po() ? $data->rel_po()->getPONumLink() : "") . "<br>" . ($data->rel_po() ? $data->rel_po()->job->getJobNumberLink() : "" ) . "<br>" . ($data->rel_po() ?$data->rel_po()->getStatusHtml(): "")',
                'type' => 'html'
            ),
            array(
                'header' => 'Image',
                'type' => 'raw',
                'value' => '$data->rel_po_detail() ? CHtml::image($data->rel_po_detail()->workorderDtl->getImg()) : ""',
                'htmlOptions' => array('style' => 'width:100px;'),
            ),
            array(
                'header' => 'Product',
                'value' => '$data->rel_po_detail() ? $data->rel_po_detail()->workorderDtl->getProductColumnHtml() : ""',
                'type' => 'raw',
            ),
            array(
                'header' => 'Product Description',
                'type' => 'raw',
                'htmlOptions' => array('style' => 'width:200px;'),
                'value' => '$data->rel_po_detail()->workorderDtl->prdlngdesc . " " . ($data->rel_po_detail() ? $data->rel_po_detail()->workorderDtl->getSizeQtyColorTable() : "" )',
            ),
            array(
                'header' => 'Qty',
                'value' => '$data->rel_po_detail()->workorderDtl->prodQty',
                'htmlOptions' => array('style' => 'text-align:center'),
            ),
//            //for purchase product
            array(
                'header' => 'Cost Price',
                'value' => 'number_format($data->rel_po_detail()->workorderDtl->prodCostPrice,2)',
                'htmlOptions' => array('style' => 'text-align:right'),
            ),
            array(
                'header' => 'Amount',
                'value' => 'number_format($data->rel_po_detail()->workorderDtl->prodCostPrice * $data->rel_po_detail()->qty,2)',
                'htmlOptions' => array('style' => 'text-align:right'),
            ),
            array(
                'class' => 'CButtonColumn',
                'template' => '{delete}',
                'buttons' => array(
                    'delete' => array
                        (
                        'label' => 'Delete',
                        'imageUrl' => false,
                        'url' => 'Yii::app()->createUrl("consolidatedPoDetail/delete", array("id"=>$data->id))',
                    ),
                )
            ),
        ),
    ));
} else if ($model->po_type == 'Purchase Product-Decoration') {

   
    ?>
<input type="hidden" name="model_id" id="model_id" value="<?php echo $model->id; ?>" />
<table class="items" id="deco_dtl_tbl">
        <thead>
            <tr>
                <th id="sales-order-grid_c0">
                    ID
                </th>     
                <th>References</th>
                <th id="sales-order-grid_c2">Image</th><th id="sales-order-grid_c3">Product</th>
                <th id="sales-order-grid_c4">Product Description</th>
                <th id="sales-order-grid_c5">
                    Decoration Name
                </th>
                <th id="sales-order-grid_c6">
                    Qty
                </th>
                <th id="sales-order-grid_c7">Cost Price</th>
                <th id="sales-order-grid_c7">Amount</th>
                <th></th>
            </tr>
        </thead>

        <tbody>
            <?php
            $count = 0;
            $linetype = 0;
            $total = 0;
            $podecodtls = ConsolidatedPoDetail::model()->findAll(array('condition' => "consolidated_po_id = $model->id"));
			echo ' mpo ',count($podecodtls);
            foreach ($podecodtls as $data) {
                $count++;
                $linetype = $count % 2;
                ?>
            <tr <?php echo $linetype == 1 ? 'class="customodd"' : 'class="customeven"'; ?> id="po_row_<?php echo $data->id;?>">
                    <td>
                        <?php echo $data->id; ?>
                    </td>
                    <td>
                        <?php 
                
                echo $data->rel_po()->getPONumLink() . "<br>" . $data->rel_po()->job->getJobNumberLink() . "<br>" . $data->rel_po()->getStatusHtml();
                
            
                        ?>
                    </td>
                    <td style="width:100px;">
                        <?php
                        echo CHtml::image($data->rel_po_detail()->workorderDtl->getImg());
                        ?>

                    </td>
                    <td>
                        <?php
                        echo $data->rel_po_detail()->workorderDtl->getProductColumnHtml();
                        ?>.
                    </td>
                    <td style="width:200px;">
                        <?php
                        echo $data->rel_po_detail()->workorderDtl->prdlngdesc . $data->rel_po_detail()->workorderDtl->getSizeQtyColorTable();
                        ?>
                    </td>
                    <td style="width:150px;">
                        <?php
                        echo $data->rel_po_detail()->getJobProductDecoration()->getProductDecorationRaw();
                        ?>
                    </td>
                    <td style="text-align:center">
                        <?php
                        $qty = $data->rel_po_detail()->getJobProductDecoration()->decoQty;
                        echo $qty;
                        ?>
                    </td>
                    <td style="text-align:center">
                        <?php
                        $costPrice = $data->rel_po_detail()->getJobProductDecoration()->decoCostPrice;
                        echo number_format($costPrice, 2);
                        ?>
                    </td>
                    <td style="text-align:right">
                        <?php
                        $cost_amount = $costPrice * $qty;
                        $total += $cost_amount;
                        echo number_format($cost_amount, 2)
                        ?>
                    </td>  
                    <td>
                        <a  title="Delete" href="#" onclick="deletePO(<?php echo $data->id; ?>);return false;">Delete</a>
                    </td>
                </tr>
                <tr <?php echo $linetype == 1 ? 'class="customodd"' : 'class="customeven"'; ?> style="border: 1px solid #fff;" id="po_setup_row_<?php echo $data->id;?>">
                    <td>&nbsp;</td>
                    <td>&nbsp;</td>
                    <td colspan="4">
                        Logo Setup Charge
                    </td>                
                    <td style="text-align: center;">
                        <?php
                        echo $data->rel_po_detail()->workorderDtl->logo_setup_charge ? $data->rel_po_detail()->getJobProductDecoration()->decoQty : "-";
                        ?>
                    </td>
                    <td style="text-align: center;">
                        <?php
                        echo $data->rel_po_detail()->workorderDtl->logo_setup_charge ? number_format(($data->rel_po_detail()->workorderDtl->logo_setup_charge / $data->rel_po_detail()->getJobProductDecoration()->decoQty), 2) : "-";
                        ?>
                    </td>
                    <td style="text-align: right;">
                        <?php
                        $total += $data->rel_po_detail()->workorderDtl->logo_setup_charge;
                        echo number_format($data->rel_po_detail()->workorderDtl->logo_setup_charge, 2) ?: "-";
                        ?>
                    </td>
                    <td></td>
                </tr>
                <?php
            }
            ?>
        </tbody>

        <tfoot >
            <tr >
                <td>&nbsp;</td>
                 <td>&nbsp;</td>
                <td>&nbsp;</td>
                <td>&nbsp;</td>
                <td>&nbsp;</td>
                <td>&nbsp;</td>
                <td style="text-align: right;font-size: 16px;font-weight: bold;">Total</td>
                <td>&nbsp;</td>
                <td style="text-align: right;font-size: 16px;font-weight: bold;" id="total_result"><?php echo number_format($total, 2); ?></td>
            </tr>
        </tfoot>
    </table>
    <?php
}
?>

<div class="view">
    <h3>Delivery Details</h3>   
    <?php
    $signofflog = new SignOffLog();
    $signofflog->model = SignOffLog::TYPE_MASTER_PURCHASE_ORDER;
    $signofflog->model_id = $model->id;

    $this->renderPartial('/signOffLog/_admin', array('signoffLog' => $signofflog));
    ?>    



    <div class="view">
        <span style="font-size: 1em;font-weight: bold;">Add Delivery Details</span>  <br> 
        <?php
        $this->renderPartial('/signOffLog/_inc_form', array('signoffLog' => $signofflog));
        ?>
        <div class="clear"></div>
    </div>



    <div class="clear"></div>
</div>
<div style="float: right;display: inline;margin-right: 5px;">
    <?php
    echo CHtml::checkBox('weborder_info_flag', array(''), array('id' => 'weborder_info_flag', 'style' => 'display: inline;'));
    ?>
    <label style="width:150px;display: inline;">
        <?php echo 'Show Website Ordering Info in PDF'; ?> 
    </label>
</div>
<div style="float: right;display: inline;margin-right: 5px;">
    <?php
    echo CHtml::checkBox('notes_flag', array(''), array('id' => 'notes_flag', 'style' => 'display: inline;'));
    ?>
    <label style="width:150px;display: inline;">
        <?php echo 'Show Notes in PDF'; ?> 
    </label>
</div>

<div style="float: right;display: inline;margin-right: 5px;">
    <?php
    echo CHtml::checkBox('custmz_flag', array(''), array('id' => 'custmz_flag', 'style' => 'display: inline;'));
    ?>
    <label style="width:150px;display: inline;">
        <?php echo 'Show Customisation Details in PDF'; ?> 
    </label>
</div>

<div style="float: right;display: inline;margin-right: 5px;">
    <?php
    echo CHtml::checkBox('price_flag', array(''), array('id' => 'price_flag', 'style' => 'display: inline;'));
    ?>
    <label style="width:150px;display: inline;">
        <?php echo 'Show Price in PDF'; ?> 
    </label>
</div>
<div style="float: right;display: inline;margin-right: 5px;">
    <?php
    echo CHtml::checkBox('deco_flag', array(''), array('id' => 'deco_flag', 'style' => 'display: inline;'));
    ?>
    <label style="width:150px;display: inline;">
        <?php echo 'Show Decoration in PDF'; ?> 
    </label>
</div>

<div style="float: right;display: inline;margin-right: 5px;">
    <?php
    echo CHtml::checkBox('jobinfo_flag', array(''), array('id' => 'jobinfo_flag', 'style' => 'display: inline;'));
    ?>
    <label style="width:150px;display: inline;">
        <?php echo 'Show Job Info in PDF'; ?> 
    </label>
</div>
<div style="float: right;display: inline;margin-right: 5px;">
<?php
echo CHtml::checkBox('logosetup_flag', array(''), array('id' => 'logosetup_flag', 'style' => 'display: inline;'));
?>
    <label style="width:150px;display: inline;">
<?php echo 'Show Logo setup in PDF'; ?> 
    </label>
</div>
<div class="clear"></div>
<div style="display: inline;float: right;margin-right: 5px;">

    <?php
    echo CHtml::button('Send Purchase Order', array('onclick' => "sendEmail($model->id,'MasterPurchaseOrder')"));
    echo CHtml::button('Print PDF', array('onclick' => "printPDF($model->id)"));
    ?>
</div>

<script>
    function printPDF(id) {
        var notes_show = $('#notes_flag').is(':checked');
        var cutmz_show = $('#custmz_flag').is(':checked');
        var price_show = $('#price_flag').is(':checked');
        var deco_show = $('#deco_flag').is(':checked');
        var job_info = $('#jobinfo_flag').is(':checked');
        var weborder_info = $('#weborder_info_flag').is(':checked');
        var logosetup_flag = $('#logosetup_flag').is(':checked');
        var win = window.open('index.php?r=consolidatedPurchaseOrder/print&id=' + id + '&price_show=' + price_show + '&deco_show=' + deco_show
                + '&cutmz_show=' + cutmz_show + '&notes_show=' + notes_show + '&jinfo=' + job_info + '&webordinfo=' + weborder_info + '&logosetup_flag=' + logosetup_flag);
    }

    function sendEmail(id, emailtype) {
        var notes_show = $('#notes_flag').is(':checked');
        var cutmz_show = $('#custmz_flag').is(':checked');
        var price_show = $('#price_flag').is(':checked');
        var deco_show = $('#deco_flag').is(':checked');
        var job_info = $('#jobinfo_flag').is(':checked');
        var weborder_info = $('#weborder_info_flag').is(':checked');
        var logosetup_flag = $('#logosetup_flag').is(':checked');
        var win = window.open('index.php?r=emails/create&id=' + id + '&type=' + emailtype + '&price_show=' + price_show
                + '&deco_show=' + deco_show + '&cutmz_show=' + cutmz_show
                + '&notes_show=' + notes_show + '&jinfo=' + job_info + '&webordinfo=' + weborder_info + '&logosetup_flag=' + logosetup_flag);
    }

    function deletePO(id) {
        var confirmed = confirm("Are you sure you want to delete this item?");
        if (confirmed) {
            //Logic to delete the item

            $.ajax({
                type: 'POST',
                url: '<?php echo Yii::app()->createUrl("consolidatedPoDetail/deletePO"); ?>',
                data: {'id': id},   
                dataType: 'json',
                success: function (result) {
                     $('#po_row_' + id).remove(); 
                     $('#po_setup_row_' + id).remove(); 
                     refreshTotal($('#model_id').val());
                },
                error: function (result) {

                }
            });
        }
    }
    
    function refreshTotal(id){
        $.ajax({
                type: 'POST',
                url: '<?php echo Yii::app()->createUrl("consolidatedPurchaseOrder/fetchTotal"); ?>',
                data: {'id': id},   
                dataType: 'json',
                success: function (result) {
                       
                      $('#total_result').empty();
                      $('#total_result').html(result.total);
                },
                error: function (result) {

                }
            });
    }
    
    
</script>
<style>
    .customodd{
        background-color: #E5F1F4;
    }
    
    .customeven{
        background-color: #eee;
    }
    table thead th{
        border-right: 1px solid #fff;
    }
    table tbody td{
        border-right: 1px solid #fff;
    }
</style>