<div class="form">

    <?php
	$list = CHtml::listData(MasterCustomer::model()->findAll(array('order' => 'mcusnam ASC')), 'mcussno', 'mcusnam');
	foreach ($list as $key => $val) {
		$mc = MasterCustomer::model()->findByPk($key);
		if ($mc->xeroContactID) {
			$list[$key] = $val . ' [ Xero ]';
		} else if ($mc->myob_uuid) {
			$list[$key] = $val . ' [ MYOB ]';
		}
	}
	
	
	
	
	
    $form = $this->beginWidget('CActiveForm', array(
        'id' => 'customer-form',
        'enableAjaxValidation' => false,
    ));
    ?>

    <p class="note">Fields with <span class="required">*</span> are required.</p>

    <?php echo $form->errorSummary($model); ?>

    <div class="row">

        <?php echo $form->labelEx($model, 'cusmcussno'); ?>
        <?php echo $form->dropDownList($model, 'cusmcussno', $list, array('empty' => '')); ?>
        <?php echo $form->error($model, 'cusmcussno'); ?>


    </div>
    <div class="row">
        <?php echo $form->labelEx($model, 'qca_ref'); ?>
        <?php echo $form->textField($model, 'qca_ref', array('size' => 60, 'maxlength' => 255)); ?>
        <?php echo $form->error($model, 'qca_ref'); ?>
    </div>
    <div class="clear"></div>
	
	<div class="row">

        <?php echo $form->labelEx($model, 'categoryId'); ?>
        <?php echo $form->dropDownList($model, 'categoryId', CHtml::listData(CustomerCategory::model()->findAll(array('order' => 'name ASC')), 'id', 'name'), array('empty' => '')); ?>
        <?php echo $form->error($model, 'categoryId'); ?>


    </div>
	<div class="row">

        <?php echo $form->labelEx($model, 'industryId'); ?>
        <?php echo $form->dropDownList($model, 'industryId', CHtml::listData(CustomerIndustry::model()->findAll(array('order' => 'name ASC')), 'id', 'name'), array('empty' => '')); ?>
        <?php echo $form->error($model, 'industryId'); ?>


    </div>
	<div class="clear"></div>
    <div class="row">
        <?php echo $form->labelEx($model, 'cusnam'); ?>
        <?php echo $form->textField($model, 'cusnam', array('size' => 60, 'maxlength' => 255)); ?>
        <?php echo $form->error($model, 'cusnam'); ?>
    </div>

    <div class="clear"></div>


    <div class="row">
        <?php echo $form->labelEx($model, 'cusadd1'); ?>
        <?php echo $form->textField($model, 'cusadd1', array('size' => 60, 'maxlength' => 255)); ?>
        <?php echo $form->error($model, 'cusadd1'); ?>
    </div>

    <div class="row">
        <?php echo $form->labelEx($model, 'cusadd2'); ?>
        <?php echo $form->textField($model, 'cusadd2', array('size' => 60, 'maxlength' => 255)); ?>
        <?php echo $form->error($model, 'cusadd2'); ?>
    </div>

    <div class="row">
        <?php echo $form->labelEx($model, 'cusadd3'); ?>
        <?php echo $form->textField($model, 'cusadd3', array('size' => 60, 'maxlength' => 255)); ?>
        <?php echo $form->error($model, 'cusadd3'); ?>
    </div>

    <div class="row">
        <?php echo $form->labelEx($model, 'custown'); ?>
        <?php echo $form->textField($model, 'custown', array('size' => 40, 'maxlength' => 40)); ?>
        <?php echo $form->error($model, 'custown'); ?>
    </div>

    <div class="row">
        <?php echo $form->labelEx($model, 'cusstate'); ?>
        <?php echo $form->textField($model, 'cusstate', array('size' => 30, 'maxlength' => 30)); ?>
        <?php echo $form->error($model, 'cusstate'); ?>
    </div>

    <div class="row">
        <?php echo $form->labelEx($model, 'cuspostcode'); ?>
        <?php echo $form->textField($model, 'cuspostcode', array('size' => 10, 'maxlength' => 10)); ?>
        <?php echo $form->error($model, 'cuspostcode'); ?>
    </div>


    <div class="clear"></div>

    <div class="row">
        <?php echo $form->labelEx($model, 'custel'); ?>
        <?php echo $form->textField($model, 'custel', array('size' => 60, 'maxlength' => 255)); ?>
        <?php echo $form->error($model, 'custel'); ?>
    </div>

    <div class="row">
        <?php echo $form->labelEx($model, 'cusmobtel'); ?>
        <?php echo $form->textField($model, 'cusmobtel', array('size' => 60, 'maxlength' => 255)); ?>
        <?php echo $form->error($model, 'cusmobtel'); ?>
    </div>

    <div class="row">
        <?php echo $form->labelEx($model, 'cusfax'); ?>
        <?php echo $form->textField($model, 'cusfax', array('size' => 60, 'maxlength' => 255)); ?>
        <?php echo $form->error($model, 'cusfax'); ?>
    </div>

    <div class="row">
        <?php echo $form->labelEx($model, 'cusemail'); ?>
        <?php echo $form->textField($model, 'cusemail', array('size' => 60, 'maxlength' => 255)); ?>
        <?php echo $form->error($model, 'cusemail'); ?>
    </div>
    <div class="clear"></div>
    <div class="row">
        <?php echo $form->labelEx($model, 'cuscontact'); ?>
        <?php echo $form->textField($model, 'cuscontact', array('size' => 50, 'maxlength' => 50)); ?>
        <?php echo $form->error($model, 'cuscontact'); ?>
    </div>

    <div class="row">
        <?php echo $form->labelEx($model, 'cuscontactemail'); ?>
        <?php echo $form->textField($model, 'cuscontactemail', array('size' => 150, 'maxlength' => 150)); ?>
        <?php echo $form->error($model, 'cuscontactemail'); ?>
    </div>

    <div class="clear"></div>
    <div class="row">
        <?php echo $form->labelEx($model, 'shipAddress1'); ?>
        <?php echo $form->textField($model, 'shipAddress1', array('size' => 150, 'maxlength' => 150)); ?>
        <?php echo $form->error($model, 'shipAddress1'); ?>
    </div>
    <div class="row">
        <?php echo $form->labelEx($model, 'shipAddress2'); ?>
        <?php echo $form->textField($model, 'shipAddress2', array('size' => 150, 'maxlength' => 150)); ?>
        <?php echo $form->error($model, 'shipAddress2'); ?>
    </div>
    <div class="row">
        <?php echo $form->labelEx($model, 'shipAddress3'); ?>
        <?php echo $form->textField($model, 'shipAddress3', array('size' => 150, 'maxlength' => 150)); ?>
        <?php echo $form->error($model, 'shipAddress3'); ?>
    </div>
    <div class="row">
        <?php echo $form->labelEx($model, 'shipSub'); ?>
        <?php echo $form->textField($model, 'shipSub', array('size' => 100, 'maxlength' => 100)); ?>
        <?php echo $form->error($model, 'shipSub'); ?>
    </div>
    <div class="row">
        <?php echo $form->labelEx($model, 'shipState'); ?>
        <?php echo $form->textField($model, 'shipState', array('size' => 100, 'maxlength' => 100)); ?>
        <?php echo $form->error($model, 'shipState'); ?>
    </div>
    <div class="row">
        <?php echo $form->labelEx($model, 'shipPostalCode'); ?>
        <?php echo $form->textField($model, 'shipPostalCode', array('size' => 100, 'maxlength' => 100)); ?>
        <?php echo $form->error($model, 'shipPostalCode'); ?>
    </div>
    <div class="clear"></div>
    <div class="row">
        <?php echo $form->labelEx($model, 'invoiceDueInXDays'); ?>
        <?php echo $form->textField($model, 'invoiceDueInXDays', array('size' => 4, 'maxlength' => 4)); ?>
        <?php echo $form->error($model, 'invoiceDueInXDays'); ?>
    </div>
    <div class="row">

        <?php echo $form->labelEx($model, 'status_id'); ?>
        <?php echo $form->dropDownList($model, 'status_id', CHtml::listData(Status::model()->findAll(array('condition' => 'id in (29,30)', 'order' => 'name asc')), 'id', 'name'), array('empty' => '')); ?>
        <?php echo $form->error($model, 'status_id'); ?>


    </div>
    <div class="clear"></div>
    <div class="row">

        <?php echo $form->labelEx($model, 'myob_taxId'); ?>
        <?php echo $form->dropDownList($model, 'myob_taxId', CHtml::listData(MyobTaxCode::model()->findAll(), 'id', 'code'), array('empty' => '')); ?>
        <?php echo $form->error($model, 'myob_taxId'); ?>


    </div>
    <div class="row">

        <?php echo $form->labelEx($model, 'myob_freightTaxId'); ?>
        <?php echo $form->dropDownList($model, 'myob_freightTaxId', CHtml::listData(MyobTaxCode::model()->findAll(), 'id', 'code'), array('empty' => '')); ?>
        <?php echo $form->error($model, 'myob_freightTaxId'); ?>


    </div>
    <div class="row buttons">
        <?php echo CHtml::submitButton($model->isNewRecord ? 'Create' : 'Save'); ?>
    </div>

    <?php $this->endWidget(); ?>

</div><!-- form -->

