<?php
require 'vendor/autoload.php';
$xeroSyncMenu = null;
// Storage Classe uses sessions for storing token > extend to your DB of choice
$storage = new StorageClass();
if (!$storage->getHasExpired()) {
    $xeroSyncMenu = array('label' => 'Sync with Xero', 'url' => array('syncXero'));
}

$this->menu = array(
    $xeroSyncMenu,
    array('label' => 'Create Customer', 'url' => array('create')),
);

Yii::app()->clientScript->registerScript('search', "
$('.search-button').click(function(){
	$('.search-form').toggle();
	return false;
});
$('.search-form form').submit(function(){
	$.fn.yiiGridView.update('customer-grid', {
		data: $(this).serialize()
	});
	return false;
});
");
?>

<h1>Manage Customers</h1>
<div>
    <?php
    foreach (Yii::app()->user->getFlashes() as $key => $message) {
        echo '<div class="flash-' . $key . '">' . $message . "</div>\n";
    }
    ?>
</div>
<p>
    You may optionally enter a comparison operator (<b>&lt;</b>, <b>&lt;=</b>, <b>&gt;</b>, <b>&gt;=</b>, <b>&lt;&gt;</b>
    or <b>=</b>) at the beginning of each of your search values to specify how the comparison should be done.
</p>

<?php echo CHtml::link('Advanced Search', '#', array('class' => 'search-button')); ?>
<div class="search-form" style="display:none">
    <?php
    $this->renderPartial('_search', array(
        'model' => $model,
    ));
    ?>
</div><!-- search-form -->
<!-- Nav tabs -->
<ul class="nav nav-tabs" role="tablist" style="margin-top: 2%;">

    <li class="active"><a href="#admin-sec" role="tab" data-toggle="tab" >Customers</a></li>

    <li><a href="#im-ex-sec" role="tab" data-toggle="tab" >Import/Export</a></li>

</ul>

<div class="tab-content">
    <div class="tab-pane active view" id="admin-sec" style="padding-top: 0;margin-top: 0;">
        <?php
        $this->widget('zii.widgets.grid.CGridView', array(
            'id' => 'customer-grid',
            'dataProvider' => $model->search(),
            'filter' => $model,
            'columns' => array(
                //'cussno',
                //'cuscus',
                //'cuscus_fref',
                //'cusmcussno',
                array(
                    'name' => 'categoryId',
                    'value' => '$data->category ? $data->category->name : null',
                    'filter' => CHtml::listData(CustomerCategory::model()->findall(), 'id', 'name'),
                ),
                array(
                    'name' => 'industryId',
                    'value' => '$data->industry ? $data->industry->name : null',
                    'filter' => CHtml::listData(CustomerIndustry::model()->findall(), 'id', 'name'),
                ),
                array(
                    'name' => 'cusnam',
                    'value' => '$data->getCusNameHtml()',
                    'type' => 'html'
                ),
                array(
                    'name' => 'cusmcussno',
                    'value' => '!empty($data->master) ? $data->master->mcusnam : null',
                    'filter' => CHtml::listData(MasterCustomer::model()->findall(), 'mcussno', 'mcusnam'),
                ),
                array(
                    'header' => 'Address',
                    'value' => '$data->cusadd1 .", " . $data->cusadd2 . ", " . $data->cusadd3',
                ),
                //'cusadd1',
                /*
                  'cusadd2',
                  'cusadd3',


                  'custown',

                  'cusstate',

                  'cuspostcode',
                  'cuscousno',
                  'custypsno',
                 */
                'custel',
                'cusmobtel',
                //'cusfax',
                'cusemail',
                /*
                  'cusdispcn',
                  'cusfnam',
                  'cussnam',
                  'custtl',
                  'cusofc',
                  'cusimgpath',
                 */
                'cuscontact',
                /*
                  'cusucdnew',
                  'cusentddt',
                  'cusenttime',
                  'cusucdame',
                  'cusameddt',
                  'cusametime',
                 */
                array(
                    'name' => 'followupStatus',
                    'value' => '$data->getFollowupStatusToString()',
                    'filter' => CHtml::listData(FollowupStatus::model()->findAll(array('condition' => "type = '".FollowupStatus::CUSTOMER."'", 'order' => 'status ASC')), 'id', 'status'),
                // 'type' => 'raw',
                ),
                array(
                    'class' => 'CButtonColumn',
                    'template' => '{view}{sep1}{update}',
                    'buttons' => array(
                        'view' => array
                            (
                            'label' => 'View',
                            'imageUrl' => false,
                        ),
                        'sep1' => array
                            (
                            'label' => ' | ',
                            'url' => '',
                            'imageUrl' => false,
                        ),
                        'update' => array
                            (
                            'label' => 'Update',
                            'imageUrl' => false,
                        ),
                    )
                ),
            ),
        ));
        ?>

    </div>
    <div class="tab-pane view" id="im-ex-sec" style="padding-top: 0;margin-top: 0;">
        <div class="view">
            <div class="form">
                <?php
                $form = $this->beginWidget('CActiveForm', array(
                    'id' => 'customer-export-form',
                    'enableAjaxValidation' => false,
                ));
                ?>


                <?php
                echo CHtml::submitButton('Reset', array('name' => 'reset_btn'));
                echo CHtml::submitButton('Export Customers as Excel', array('name' => 'customer-exprt-btn', 'style' => 'margin-left:5px;float:right;'));



                $this->endWidget();
                ?>
            </div>
            <div class="clear"></div>
        </div>
        <div class="view">
            <div class="form">
                <?php
                $form = $this->beginWidget('CActiveForm', array(
                    'id' => 'customer-import-form',
                    'enableAjaxValidation' => false,
                    'htmlOptions' => array('enctype' => 'multipart/form-data'),
                ));
                ?>

                <div class="row">
                    <?php echo $form->labelEx($model, 'importFile'); ?>
                    <?php echo $form->fileField($model, 'importFile', array('size' => 60, 'maxlength' => 255)); ?>
                    <?php echo $form->error($model, 'importFile'); ?>

                    <?php echo CHtml::submitButton('Upload File', array('name' => 'import_btn')); ?>
                    <div>[Only XML,CSV file types are allowed] </div>
                </div>
                <div class="clear"></div>
                <?php
                //echo CHtml::submitButton('Reset', array('name' => 'reset_btn','style' => 'margin-left:5px;float:right;'));
                //echo CHtml::submitButton('Export Products as Excel', array('name' => 'prd-exprt-btn', 'style' => 'margin-left:5px;float:right;'));



                $this->endWidget();
                ?>
            </div>
            <div class="clear"></div>
        </div>
    </div>
</div>

