<?php
$this->menu = array(
    array('label' => 'Manage Customer Contacts', 'url' => array('admin')),
);

Yii::app()->clientScript->registerScript('search', "
$('.search-button').click(function(){
	$('.search-form').toggle();
	return false;
});
$('.search-form form').submit(function(){
	$.fn.yiiGridView.update('customer-grid', {
		data: $(this).serialize()
	});
	return false;
});
");
?>

<h1>Merge Customers Contacts</h1>
<div>
    <?php
    foreach (Yii::app()->user->getFlashes() as $key => $message) {
        echo '<div class="flash-' . $key . '">' . $message . "</div>\n";
    }
    ?>
</div>
<p>
<ol>
    <li>Filter customers you want to merge.</li>
    <li>Select the customer that you want to merge other customers into from the "Merge Into" column radio button.</li>
    <li>Then check all the customers you want to merge into.</li>
    <li>Click the "Merge Customer Contact" button at the bottom of the page.</li>
    <li>Validation : Customer name and master customer must be same for all the customers.</li>
    <li>Note : Customer data of Quotation, Sales orders, jobs, invoice, purchase orders, invoices, deliver dockets and CRM records will be updated.</li>
    
</ol>
</p>





<div class="view">

    <?php
    $form = $this->beginWidget('CActiveForm', array(
        'id' => 'customer-form',
        'enableAjaxValidation' => false,
    ));

    $this->widget('zii.widgets.grid.CGridView', array(
        'id' => 'customer-grid',
        'dataProvider' => $model->search(),
        'filter' => $model,
        'selectableRows' => 100,
        'columns' => array(
            array(
                'class' => 'CCheckBoxColumn',
            ),
            'cussno',
            //'cuscus',
            //'cuscus_fref',
            //'cusmcussno',
            array(
                'name' => 'categoryId',
                'value' => '$data->category ? $data->category->name : null',
                'filter' => CHtml::listData(CustomerCategory::model()->findall(array('order' => 'name')), 'id', 'name'),
            ),
            
            array(
                'name' => 'industryId',
                'value' => '$data->industry ? $data->industry->name : null',
                'filter' => CHtml::listData(CustomerIndustry::model()->findall(array('order' => 'name')), 'id', 'name'),
            ),
            array(
                'name' => 'mergeIntoCusId',
                'value' => 'CHtml::radioButton("mergeIntoCusId", false ,array("value" => $data->cussno))',
                'type' => 'raw',
                'filter' => false,
            ),
            array(
                'name' => 'cusnam',
                'value' => '$data->getCusNameHtml()',
                'type' => 'html'
            ),
            array(
                'name' => 'cusmcussno',
                'value' => '!empty($data->master) ? $data->master->mcusnam : null',
                'filter' => CHtml::listData(MasterCustomer::model()->findall(array('order' => 'mcusnam')), 'mcussno', 'mcusnam'),
            ),
            array(
                'header' => 'Address',
                'value' => '$data->cusadd1 .", " . $data->cusadd2 . ", " . $data->cusadd3',
            ),
            //'cusadd1',
            /*
              'cusadd2',
              'cusadd3',


              'custown',

              'cusstate',

              'cuspostcode',
              'cuscousno',
              'custypsno',
             */
            'custel',
            'cusmobtel',
            //'cusfax',
            'cusemail',
            /*
              'cusdispcn',
              'cusfnam',
              'cussnam',
              'custtl',
              'cusofc',
              'cusimgpath',
             */
            'cuscontact',
            /*
              'cusucdnew',
              'cusentddt',
              'cusenttime',
              'cusucdame',
              'cusameddt',
              'cusametime',
             */
            array(
                'name' => 'followupStatus',
                'value' => '$data->getFollowupStatusToString()',
                'filter' => CHtml::listData(FollowupStatus::model()->findAll(array('condition' => "type = '" . FollowupStatus::CUSTOMER . "'", 'order' => 'status ASC')), 'id', 'status'),
            // 'type' => 'raw',
            ),
            array(
                'class' => 'CButtonColumn',
                'template' => '{view}',
                'buttons' => array(
                    'view' => array
                        (
                        'label' => 'View',
                        'imageUrl' => false,
                    )                    
                )
            ),
        ),
    ));
    ?>
    <div class="clear"></div>
    <div class="buttons right">
        <?php echo CHtml::submitButton('Merge Customer Contacts',  array('style' => 'background-color:#CC3300') ); ?>
    </div>
    <div class="clear"></div>
</div>
<?php $this->endWidget(); ?>