<?php
$this->breadcrumbs = array(
    'Decorations' => array('index'),
    'Manage',
);

$this->menu = array(
    
    array('label' => 'Create Decoration', 'url' => array('create')),
    array('label' => 'Create Decoration Main Type', 'url' => array('createMianType')),
);

Yii::app()->clientScript->registerScript('search', "
$('.search-button').click(function(){
	$('.search-form').toggle();
	return false;
});
$('.search-form form').submit(function(){
	$.fn.yiiGridView.update('decoration-grid', {
		data: $(this).serialize()
	});
	return false;
});
");
?>

<h1>Manage Decoration Main Types</h1>

<p>
    You may optionally enter a comparison operator (<b>&lt;</b>, <b>&lt;=</b>, <b>&gt;</b>, <b>&gt;=</b>, <b>&lt;&gt;</b>
    or <b>=</b>) at the beginning of each of your search values to specify how the comparison should be done.
</p>

<?php echo CHtml::link('Advanced Search', '#', array('class' => 'search-button')); ?>
<div class="search-form" style="display:none">
    <?php
    $this->renderPartial('_search', array(
        'model' => $model,
    ));
    ?>
</div><!-- search-form -->

<?php
$this->widget('zii.widgets.grid.CGridView', array(
    'id' => 'decoration-grid',
    'dataProvider' => $model->searchmian(),
    'filter' => $model,
    'columns' => array(
        'decsno',
        
        array(
            'name' => 'decprtnam',
        ),
        'decnam',
        array(
            'name' => 'decentddt',
            'value'=>'date(GlobalVars::get("DateFormat"),strtotime($data->decentddt))'
        ),
        /*
          'decis_main_type',
          'decweight_4_sorting',
          'decpriority',
          'decis_shown_to_clients',
          'decflag',
          'decsupsno',
          'decuntprice',
          'decleadtime',
          'decduration',
          'decmob',
          'decucdnew',
          'decentddt',
          'decenttime',
          'decucdame',
          'decameddt',
          'decametime',
         */
        array(
            'class' => 'CButtonColumn',
            'template' => '{updatemain}{sep2}{delete}',
            'buttons' => array(
               
                'updatemain' => array(
                    'label' => 'Update',
                    'imageUrl' => false,
                     
                     'url' => 'Yii::app()->createUrl("decoration/updateMain", array("id"=>$data->decsno))',   
                ),
                'sep2' => array(
                    'label' => ' | ',
                    'imageUrl' => false,
                ),
                'delete' => array(
                    'label' => 'Delete',
                    'imageUrl' => false,
                ),
            )
        ),
    ),
));
?>
