<!-- Nav tabs -->
<ul class="nav nav-tabs" role="tablist">

    <li class="active"><a href="#do-header-sec" role="tab" data-toggle="tab" onclick="setTab('header-sec');">DO Header</a></li>

    <li><a href="#do-detial-sec" role="tab" data-toggle="tab" onclick="setTab('crm-sec');">Items</a></li> 

</ul>

<!-- Tab panes -->
<div class="tab-content">
    <div class="tab-pane active view" id="do-header-sec" style="padding-top: 0;margin-top: 0;">
        <div class="form">

            <?php
            $form = $this->beginWidget('CActiveForm', array(
                'id' => 'delivery-dockets-form',
                'enableAjaxValidation' => false,
            ));
            ?>

            <p class="note">Fields with <span class="required">*</span> are required.</p>
            <div class="right">        
                <?php echo CHtml::submitButton('Update', array('name' => 'update-do-btn',)); ?>
            </div>

            <?php echo $form->errorSummary($model); ?>

            <div class="row">
                <?php echo $form->textField($model, 'id', array('style' => 'display:none;')); ?>
                <?php echo $form->labelEx($model, 'diliveryDocketNum'); ?>
                <?php echo $form->textField($model, 'diliveryDocketNum', array('readonly' => true)); ?>
                <?php echo $form->error($model, 'diliveryDocketNum'); ?>
            </div>
            <div class="row">
                <?php echo $form->labelEx($model, 'createdDtm'); ?>
                <?php
                $todayDate = date(GlobalVars::get("DateFormat")); // current date
                $currentTime = time($todayDate) + 60 * 60 * 11 + 30 * 60; //Change date into time
                $currentTime = date(GlobalVars::get("DateFormat"), $currentTime);

                Yii::import('application.extensions.CJuiDateTimePicker.CJuiDateTimePicker');
                $this->widget('CJuiDateTimePicker', array(
                    'model' => $model, //Model object
                    'attribute' => 'createdDtm', //attribute name
                    'mode' => 'date', //use "time","date" or "datetime" (default)
                    'options' => array("dateFormat" => 'dd-mm-yy', "changeMonth" => 'true', 'changeYear' => 'true', 'minDate' => $currentTime,), // jquery plugin options
                    'language' => 'en-GB'
                ));
                ?>
            </div>


            <div class="row" style="display: none;">

                <?php echo $form->textField($model, 'jobId'); ?>
                <?php echo $form->textField($model, 'wrkorderId'); ?>
                <?php echo $form->textField($model, 'quoteId'); ?>



            </div>

            <div class="row">
                <?php echo $form->labelEx($model, 'invoiceId'); ?>
                <?php
                echo $form->dropDownList($model, 'invoiceId', CHtml::listData(Invoice::model()->findAll(array('condition' => "job_id = '{$model->jobId}'")), 'id', 'invoiceNum'), array('empty' => ''));
                ?>

                <?php echo $form->error($model, 'invoiceId'); ?>
            </div>


            <div class="row">
                <?php echo $form->labelEx($model, 'contactName'); ?>
                <?php echo $form->textField($model, 'contactName', array('size' => 60, 'maxlength' => 255)); ?>
                <?php echo $form->error($model, 'contactName'); ?>
            </div>
            <div class="clear"></div>
            <div class="row" style="width: 68%;">
                <?php echo $form->labelEx($model, 'conNote'); ?>
                <?php echo $form->textArea($model, 'conNote', array('rows' => 3, 'style' => 'width:100%;')); ?>
                <?php echo $form->error($model, 'conNote'); ?>
            </div>
            <div class="clear"></div>
            <div class="row">
                <?php echo $form->labelEx($model, 'companyName'); ?>
                <?php echo $form->textField($model, 'companyName', array('size' => 60, 'maxlength' => 255)); ?>
                <?php echo $form->error($model, 'companyName'); ?>
            </div>

            <div class="row">
                <?php echo $form->labelEx($model, 'companyAddress'); ?>
                <?php echo $form->textField($model, 'companyAddress', array('size' => 60, 'maxlength' => 255)); ?>
                <?php echo $form->error($model, 'companyAddress'); ?>
            </div>
            <div class="row">
                <?php echo $form->labelEx($model, 'companyAddress2'); ?>
                <?php echo $form->textField($model, 'companyAddress2', array('size' => 60, 'maxlength' => 255)); ?>
                <?php echo $form->error($model, 'companyAddress2'); ?>
            </div>
            <div class="row">
                <?php echo $form->labelEx($model, 'companyAddress3'); ?>
                <?php echo $form->textField($model, 'companyAddress3', array('size' => 60, 'maxlength' => 255)); ?>
                <?php echo $form->error($model, 'companyAddress3'); ?>
            </div>

            <div class="row">
                <?php echo $form->labelEx($model, 'town'); ?>
                <?php echo $form->textField($model, 'town', array('size' => 60, 'maxlength' => 255)); ?>
                <?php echo $form->error($model, 'town'); ?>
            </div>

            <div class="row">
                <?php echo $form->labelEx($model, 'state'); ?>
                <?php echo $form->textField($model, 'state', array('size' => 60, 'maxlength' => 255)); ?>
                <?php echo $form->error($model, 'state'); ?>
            </div>

            <div class="row">
                <?php echo $form->labelEx($model, 'telephone1'); ?>
                <?php echo $form->textField($model, 'telephone1', array('size' => 15, 'maxlength' => 15)); ?>
                <?php echo $form->error($model, 'telephone1'); ?>
            </div>

            <div class="row">
                <?php echo $form->labelEx($model, 'telephone2'); ?>
                <?php echo $form->textField($model, 'telephone2', array('size' => 15, 'maxlength' => 15)); ?>
                <?php echo $form->error($model, 'telephone2'); ?>
            </div>

            <div class="row">
                <?php echo $form->labelEx($model, 'shippedBy'); ?>
                <?php echo $form->dropDownList($model, 'shippedBy', CHtml::listData(ShippingLine::model()->findAll(array('order' => 'name ASC')), 'id', 'name'), array('empty' => '')); ?>

                <?php echo $form->error($model, 'shippedBy'); ?>
            </div>





            <div class="clear"></div>



            <?php $this->endWidget(); ?>

        </div><!-- form -->
    </div>

    <div class="tab-pane view" id="do-detial-sec" style="padding-top: 0;margin-top: 0;">
        <div id="main-grid-container" class="view">
            <div class="right">
                <?php
                echo CHtml::button('Delete Selected', array(
                    'id' => 'do-dtl-del-all-btn',
                    'name' => 'delete_quote_dtl',
                    'class' => '',
                    'style' => 'width:100px;float:right;',
                    'onclick' => "js:deleteSelectedDtls();",
                    'disabled' => 'disabled',
                        )
                );
                ?>
                <img id="loding_icon" src="images/loading.gif" style="width: 40px;height: 40px;float: right;margin-top: 2px;display: none;"/>
            </div>
            <div id="delivery-labels-grid" class="grid-view" >
                <table class="items" style="width: 100%;">
                    <thead style="width: 100%;">
                        <tr style="width: 100%;">
                            <td style="width: 100%;">
                                <table style="width: 100%;">
                                    <tr style="width: 100%;">
                                        <th style="width: 5%;text-align: center;" >No</th>
                                        <th style="width: 15%;text-align: center;" >Image</th>
                                        <th style="width: 30%;text-align: center;">Product</th>
                                        <th style="width: 25%;text-align: center;">Decoration</th>
                                        <th style="width: 8%;text-align: center;">Qty</th>                                                            
                                        <th style="width: 12%;"></th>
                                    </tr>

                                </table>
                            </td>

                        </tr>
                    </thead>
                    <tbody id="maintblbody" style="width: 100%;">
                        <?php
                        $deliverydetails = DeliveryDocketDetails::model()->findAll(array('condition' => "deliveryDocketId = '{$model->id}'"));
                        $itemCount = count($deliverydetails);
                        foreach ($deliverydetails as $ddtl):
                            if (!empty($ddtl->workorderdtl)) {
                                ?>
                                <tr  id="maindtlrow_<?php echo $ddtl->id; ?>">

                                    <td class="maincell">
                                        <table class="maintbl">
                                            <tr id=""  >
                                                <td style="width: 5%;">
                                                    <input class="do-line-select" detail-id="<?php echo $ddtl->id; ?>" type="checkbox" id="detail_select_row_<?php echo $ddtl->id; ?>" style="color: green;"/>
                                                </td>
                                                <td style="width: 15%;">
                                                    <?php echo CHtml::image($ddtl->workorderdtl->getImg(), '', array('width' => 100, 'height' => 100)) ?>
                                                </td>
                                                <td style="width: 30%;">
                                                    <div>
                                                        <?php
                                                        echo $ddtl->workorderdtl->prodSupp ? $ddtl->workorderdtl->prodSupp->getLink() : "No Supplier";
                                                        ?>
                                                    </div>
                                                    <div class="prodecs">
                                                        <?php
                                                        if (!empty($ddtl->workorderdtl->prdsrtdesc)) {
                                                            echo $ddtl->workorderdtl->productsku . '<br>' . trim($ddtl->workorderdtl->prdsrtdesc);
                                                            ;
                                                        } else {
                                                            echo $ddtl->workorderdtl->custmproduct;
                                                        }
                                                        ?>

                                                    </div>
                                                    <div class="prolngdesc" id="" >
                                                        <?php
                                                        if (!empty($ddtl->workorderdtl->prdlngdesc)) {



                                                            echo $ddtl->workorderdtl->prdlngdesc;
                                                        }
                                                        ?>

                                                    </div>

                                                </td>
                                                <td style="width: 25%;">
                                                    <?php
                                                    if (!empty($ddtl->workorderdtl->decdesc)) {

                                                        echo $ddtl->workorderdtl->decdesc;
                                                    } else {

                                                        echo $ddtl->workorderdtl->customdecoration;
                                                    }
                                                    ?> 


                                                </td>
                                                <td style="width: 8%;">
                                                    <input type="text" name="" id="" value="<?php echo $ddtl->qty; ?>" class="dl-inputs txt-center" onchange="updateFullQty('<?php echo $ddtl->id; ?>', this)"/>
                                                </td>                                                                      
                                                <td  style="width: 12%;" >
                                                    <?php
                                                    if ($itemCount > 1) {
                                                        ?>
                                                        <a class="delete" title="Delete" href="#"   onclick="deleteRecord('<?php echo $ddtl->id; ?>');return false;">Delete</a>
                                                        <?php
                                                    }
                                                    ?>
                                                </td> 
                                            </tr>
                                            <tr class="subrow" id="" >
                                                <td colspan="10" style="background-color: #FFFFFF;">
                                                    <div id="" >
                                                        <table class="fullwidth">                                                    
                                                            <tr class="fullwidth">
                                                                <td class="fullwidth">
                                                                    <div class="fullwidth sizeqtycolordiv" id="" >
                                                                        <table  id="<?php echo 'dltbl_' . $ddtl->id; ?>" >
                                                                            <tr>
                                                                                <th class="dl-n-clm">#</th>
                                                                                <th class="dl-box-clm">Box Number</th>
                                                                                <th class="dl-note-clm">Notes</th>
                                                                                <th class="dl-qty-clm">Quantity</th>
                                                                                <th class="dl-btn-clm"><div onclick="addDeliveryLabel('<?php echo $ddtl->id; ?>');" >+Add Row</div></th>
                                                                            </tr>
                                                                            <?php
                                                                            $deliverylabels = DeliveryDocketLabel::model()->findAll(array('condition' => "delivery_docket_dtl_id = '{$ddtl->id}'"));
                                                                            foreach ($deliverylabels as $label):
                                                                                ?>
                                                                                <tr id="dl_<?php echo $label->id; ?>" >
                                                                                    <td class="dl-n-clm"></td>
                                                                                    <td class="dl-box-clm"><input onchange="savelblboxnum('<?php echo $ddtl->id; ?>', '<?php echo $label->id; ?>', this.value)" type="text"  value="<?php echo $label->boxnum; ?>" class="dl-inputs txt-center"/></td>
                                                                                    <td class="dl-note-clm"><input onchange="savelblnote('<?php echo $ddtl->id; ?>', '<?php echo $label->id; ?>', this.value)" type="text"  value="<?php echo $label->notes; ?>" class="dl-inputs"/></td>
                                                                                    <td class="dl-qty-clm"><input onchange="savelblqty('<?php echo $ddtl->id; ?>', '<?php echo $label->id; ?>', this)" type="text"  value="<?php echo $label->quantity; ?>" class="dl-inputs txt-center"/></td>
                                                                                    <td class="dl-btn-clm"><a href="#" onclick="deletedeliveryLbl('<?php echo $label->id; ?>');
                                                                                            return false;">Delete</a></td>
                                                                                </tr>
                                                                                <?php
                                                                            endforeach;
                                                                            ?>
                                                                        </table>
                                                                    </div>
                                                                </td>
                                                            </tr>
                                                        </table>
                                                    </div>
                                                </td>                               
                                            </tr>
                                        </table>
                                        <div id="<?php echo 'savemessage_' . $ddtl->id; ?>" class="savemessage">Changes are saved</div>
                                        <a name="here"></a>
                                    </td>

                                </tr>
                                <?php
                            }
                        endforeach;
                        ?>
                    </tbody>                
                </table>
            </div>

        </div>
    </div>
</div>


<div  style="display: inline;float: right;">
    <?php
//echo CHtml::button('Send Invoice', array('onclick' => "sendEmail($model->id,'Invoice')"));
    echo CHtml::button('Print Delivery Note', array('onclick' => "printNote($model->id)"));
    echo CHtml::button('Print Delivery Label', array('onclick' => "printLabel($model->id)"));
    ?>
</div>

<script>
    var selectedDetailIds = [];
    $(document).on('change', '.do-line-select', function () {
        var totalItemCount = $('input[detail-id]').length;
        
        
        var detailId = $(this).attr('detail-id');

        if ($(this).is(':checked')) {

            selectedDetailIds.push(detailId);
        } else {

            selectedDetailIds = jQuery.grep(selectedDetailIds, function (value) {
                return value !== detailId;
            });
        }
        
        
        //only allow to delete items if there are more than one items
        //otherwise user should delete the DO completly
        if (selectedDetailIds.length !== 0 && selectedDetailIds.length < totalItemCount) {
            toggleDetailOptionButtons(false);
        } else {
            toggleDetailOptionButtons(true);
        }

    });

    function toggleDetailOptionButtons(doDisable) {
        jQuery("#do-dtl-del-all-btn").prop('disabled', doDisable);

    }
    
    function deleteSelectedDtls(){
         deleteMultipleRecords(selectedDetailIds);
    }


    function deleteMultipleRecords(arr) {
        var s = confirm("Are you sure you want to delete these records?");

        if (s === true) {
            $('#loding_icon').show();
            var jsonString = JSON.stringify(arr);
            $.ajax({
                type: 'POST',
                url: '<?php echo Yii::app()->createUrl("deliveryDocketDetails/deleteMultipleRecords"); ?>',
                data: {'doDtlArr': jsonString},
                cache: false,
                success: function (result) {

                    $.each(arr, function (index, value) {
                        $('#maindtlrow_' + value).remove();
                    });

                    //resetDetailsCount();



                    toggleDetailOptionButtons(true);

                    $('#loding_icon').hide();

                },
                error: function (result) {
                    $('#loding_icon').hide();
                    console.log(result);
                }
            });
        }

    }

    function printNote(id) {
        var win = window.open('index.php?r=deliveryDockets/printnote&id=' + id);
    }
    function printLabel(id) {
        var win = window.open('index.php?r=deliveryDockets/printlbl&id=' + id);
    }


    function changessaved(id) {
        $('#savemessage_' + id).fadeIn(500).fadeOut(1500);
    }


    function updateFullQty(id, obj) {
        $(obj).css('background-color', '');
        $(obj).attr('title', '');
        if (validateLabelQty(id, obj)) {
            $.ajax({
                type: 'POST',
                url: '<?php echo Yii::app()->createUrl("deliveryDocketDetails/updateFullQty"); ?>',
                data: {'id': id, 'value': $(obj).val()},
                dataType: 'json',
                success: function (result) {
                    if (result.status === true) {
                        $(obj).css('background-color', '');
                        $(obj).attr('title', '');
                        changessaved(id);
                    } else if (result.status_code === 304) {
                        $(obj).css('background-color', 'red');
                        $(obj).attr('title', 'Quantity exceed!');
                    }
                },
                error: function (result) {
                    console.log(result);
                }
            });
        } else {
            $(obj).css('background-color', 'red');
            $(obj).attr('title', 'Quantity mismatch with label qty!');
        }
    }

    function validateLabelQty(id, obj) {
        var itemQty = $(obj).val();
        var labelQty = 0;
        $("#dltbl_" + id + " > tbody  > tr > td:nth-child(4) input").each(function (i, e) {
            labelQty += parseInt($(e).val());
        });

        if (itemQty < labelQty) {
            return false;
        } else {
            return true;
        }
    }

    function addDeliveryLabel(id) {
        $.ajax({
            type: 'POST',
            url: '<?php echo Yii::app()->createUrl("deliveryDocketLabel/createLabel"); ?>',
            data: {'id': id},
            dataType: 'json',
            success: function (result) {
                if (result.rowid > 0) {
                    createDeliveryLblrow(id, result.rowid);
                }
            },
            error: function (result) {
                alert('error in create');
            }
        });
    }

    function createDeliveryLblrow(docketDtlID, docketLblID) {
        var html = '<tr id="dl_' + docketLblID + '" >\n\
                        <td class="dl-n-clm"></td>\n\
                        <td class="dl-box-clm"><input onchange="savelblboxnum(' + docketDtlID + ',' + docketLblID + ',this.value)" type="text"  value="" class="dl-inputs txt-center"/></td>\n\
                        <td class="dl-note-clm"><input onchange="savelblnote(' + docketDtlID + ',' + docketLblID + ',this.value)" type="text"  value="" class="dl-inputs"/></td>\n\
                        <td class="dl-qty-clm"><input onchange="savelblqty(' + docketDtlID + ',' + docketLblID + ',this)" type="text"  value="" class="dl-inputs txt-center"/></td>\n\
                        <td class="dl-btn-clm"><a href="#" onclick="deleteDeliveryLbl(' + docketLblID + ');return false;";>Delete</a></td>\n\
                        </tr>';
        $('#dltbl_' + docketDtlID).append(html);
    }

    function savelblboxnum(dockectDtlID, docketLblID, inptval) {
        $.ajax({
            type: 'POST',
            url: '<?php echo Yii::app()->createUrl("deliveryDocketLabel/savelblboxNum"); ?>',
            data: {'id': docketLblID, 'value': inptval},
            dataType: 'json',
            success: function (result) {
                if (result.status === 'success') {
                    changessaved(dockectDtlID);
                }
            },
            error: function (result) {
                alert('error in update');
            }
        });
    }
    function savelblnote(dockectDtlID, docketLblID, inptval) {
        $.ajax({
            type: 'POST',
            url: '<?php echo Yii::app()->createUrl("deliveryDocketLabel/savelblNote"); ?>',
            data: {'id': docketLblID, 'value': inptval},
            dataType: 'json',
            success: function (result) {
                if (result.status === 'success') {
                    changessaved(dockectDtlID);
                }
            },
            error: function (result) {
                alert('error in update');
            }
        });
    }
    function savelblqty(dockectDtlID, docketLblID, obj) {
        $.ajax({
            type: 'POST',
            url: '<?php echo Yii::app()->createUrl("deliveryDocketLabel/savelblQty"); ?>',
            data: {'id': docketLblID, 'value': $(obj).val()},
            dataType: 'json',
            success: function (result) {
                if (result.status === true) {
                    $(obj).css('background-color', '');
                    $(obj).attr('title', '');
                    changessaved(dockectDtlID);
                } else if (result.status_code === 304) {
                    $(obj).css('background-color', 'red');
                    $(obj).attr('title', 'Quantity exceed!');
                }
            },
            error: function (result) {
                console.log(result);
            }
        });
    }
    function deleteDeliveryLbl(docketLblID) {
        $.ajax({
            type: 'POST',
            url: '<?php echo Yii::app()->createUrl("deliveryDocketLabel/deleteLbl"); ?>',
            data: {'id': docketLblID},
            dataType: 'json',
            success: function (result) {
                $('#dl_' + docketLblID).remove();
            },
            error: function (result) {
                console.log(result);
            }
        });
    }

    function deleteRecord(id) {
        var r = confirm("Are you sure you want to delete this record?");

        if (r === true) {

            $.ajax({
                type: 'POST',
                url: '<?php echo Yii::app()->createUrl("deliveryDocketDetails/ajaxDelete"); ?>',
                data: {'id': id},
                dataType: 'json',
                success: function (result) {

                    if (result.success == true) {
                        $('#maindtlrow_' + id).remove();
                    } else {
                        alert(result.message);
                    }



                },
                error: function (result) {
                    alert('error when delete delivery docket detail');
                }
            });
        }
    }


    function deletedeliveryLbl(id) {
        var r = confirm("Are you sure you want to delete this record?");

        if (r === true) {

            $.ajax({
                type: 'POST',
                url: '<?php echo Yii::app()->createUrl("deliveryDocketLabel/deleteLbl"); ?>',
                data: {'id': id},
                dataType: 'json',
                success: function (result) {

                    if (result.success == true) {
                        $('#dl_' + id).remove();
                    } else {
                        alert(result.message);
                    }





                },
                error: function (result) {
                    alert('error in delete');
                }
            });
        }
    }
</script>
<style>
    #delivery-labels-grid table thead tr th{
        background-image: none;
        background-color: #82B8D6;

    }

    .foo{
        background-color: #E5F1F4;
    }

    .bar{
        background-color: #FFFFFF;
    }

    .maindetailrow{
        width: 100%;
    }

    .maincell{
        width: 100%;        

    }

    .maintbl{
        width: 100%;

    }

    .maintbl tr{
        width: 100%;
    }

    .maintbl:first-child tr td:first-child{
        width: 5%;
    }

    .textinput{
        text-align: center;width: 5%;
    }

    .centercls{
        text-align: center;

    }   

    .rightcls{
        text-align: right;
    }   

    input.centercls{
        width: 40px;
    }

    input.rightcls{
        width: 50px;
    }



    .button-column img{
        cursor: pointer;
        width: 20px;
        height: 20px;
    }

    .subrow{
        width: 100%;
        border: 1px solid #666;

    }

    .subrow:first-child td{
        background-color: #FFFFFF;
    }

    .subrow:first-child td{
        width: 100%;

    }

    .fullwidth{
        width: 100%;
    }

    .subrowgrid tr{
        width: 100%;
    }

    .subrowgrid:first-child tr{
        background-color: #e5eCf9;
    }

    .subrowgrid:last-child tr{
        border: 1px solid #DDD;
    }

    .column1{
        width: 10%;
    }

    .column2{
        width: 35%;
    }

    .column3{
        width: 30%
    }

    .column2half{
        width: 25%;
    }

    .column1half{
        width: 15%;
    }

    .subrowgrid tr th{
        text-align: center;
    }

    .subrowgrid textArea{
        width: 100%;height: 100%;
    }

    .subrowgrid img{
        width:100px;
        height:100px;
    }


    .viewsizecolor{
        border: 1px solid #DDD;
        border-radius: 15px;
        cursor: pointer;
        text-align: center;    
    }

    .uploadimg{
        border: 1px solid #DDD;
        border-radius: 15px;
        cursor: pointer;
        text-align: center;  
        margin-bottom: 10px;

    }

    .saveimg{
        border: 1px solid #DDD;
        border-radius: 15px;
        cursor: pointer;
        text-align: center;  
        margin-bottom: 5px;
        display: none;

    }

    .mouseoverbutton{
        background-color: #DDD;
        border: 1px solid #FFD324;
    }

    .sizeqtycolordiv{

    }

    .sizeqtycolordiv table{
        width: 100%;
    }

    .sizeqtycolordiv table tr{
        width: 100%;
    }

    .sizeqtycolordiv table:first-child tr{
        background-color: #DDD;
    }

    .sizeqtycolordiv table tr th,td{
        text-align: center;
    }

    .sizeqtycolordiv table:first-child tr div{
        border: 1px solid #FFFFFF;
        border-radius: 15px;
        cursor: pointer;
        text-align: center;
        width: 50%;
        margin: auto;
    }

    .sizeqtycolordiv table tr:not(:first-child){
        background-color: #E6EFC2;
    }

    .sizeqtycolordiv table input{
        width: 100%;
    }

    .counter{

    }

    .savemessage{
        width: 100%;        
        font-weight: bold;
        color: #00aa00;
        display: none;

    }

    .prodecs{

    }

    .viewlongdesc{
        border: 1px solid #DDD;
        border-radius: 15px;
        cursor: pointer;
        color: #BCE774;
        margin: 5px;
    }

    .prolngdesc{

    }

    #workorder-list-view tbody td{
        text-align: left;
        padding-left: 50px;

    }

    .dl-n-clm{
        width: 5%;
    }
    .dl-box-clm{
        width: 15%;
    }

    .dl-note-clm{
        width: 45%;
    }

    .dl-qty-clm{
        width: 15%;
    }

    .dl-btn-clm{
        width: 20%;
    }

    .dl-inputs{
        width: 95%;
        margin: 0;
        padding: 0;
    }

    .txt-center{
        text-align: center;
    }

</style>