<?php
$this->breadcrumbs = array(
    'Delivery Dockets' => array('index'),
    'Manage',
);

$backtojob = null;

if(isset($_GET['job_id'])){
    $job = Jobs::model()->findByPk($_GET['job_id']);
    $backtojob =  array('label' => 'Back to : ' . $job->jobNum, 'url' => array('jobs/view', 'id' => $job->id));
}
$jobinfocusmenu = null;
if(isset(Yii::app()->session['job_in_focus_id'])){
    $jobinfocusmenu = array('label' => 'JOB IN FOCUS', 'url' => array('jobs/jobFlow'),'linkOptions'=>array('style'=>'background-color:orange;'));
}
$this->menu = array(
        $jobinfocusmenu,
        $backtojob,
        //array('label'=>'List DeliveryDockets', 'url'=>array('index')),
        //array('label'=>'Create DeliveryDockets', 'url'=>array('create')),
);

Yii::app()->clientScript->registerScript('search', "
$('.search-button').click(function(){
	$('.search-form').toggle();
	return false;
});
$('.search-form form').submit(function(){
	$.fn.yiiGridView.update('delivery-dockets-grid', {
		data: $(this).serialize()
	});
	return false;
});
");
?>

<h1>Manage Delivery Dockets for <?php echo $model->job->jobNum; ?></h1>

<p>
    You may optionally enter a comparison operator (<b>&lt;</b>, <b>&lt;=</b>, <b>&gt;</b>, <b>&gt;=</b>, <b>&lt;&gt;</b>
    or <b>=</b>) at the beginning of each of your search values to specify how the comparison should be done.
</p>

<?php echo CHtml::link('Advanced Search', '#', array('class' => 'search-button')); ?>
<div class="search-form" style="display:none">
    <?php
    $this->renderPartial('_search', array(
        'model' => $model,
    ));
    ?>
</div><!-- search-form -->

<?php
$this->widget('zii.widgets.grid.CGridView', array(
    'id' => 'delivery-dockets-grid',
    'dataProvider' => $model->search(),
    'filter' => $model,
    'columns' => array(
        'id',
        array(
            'name'=>'createdDtm',
            'value'=>'date(GlobalVars::get("DateFormat"),strtotime($data->createdDtm))'
        ),
        //'quoteId',
        //'wrkorderId',
        //'jobId',
         array(
            'name'=>'job_number',
            'value'=>'$data->job->jobNum'
        ),
         array(
            'name'=>'invoice_number',
            'value'=>'$data->invoice->invoiceNum'
        ),
        
        //'invoice.invoiceNum',
        'diliveryDocketNum',
        
        'contactName',
        'conNote',
        'companyName',
        'companyAddress',
        'telephone1',
        'telephone2',
        array(
            'name'=>'shippedBy',
            'value'=>'!empty($data->ShippingLine) ? $data->ShippingLine->name : "Not Set"'
        ),
        
        array(
            'class' => 'CButtonColumn',
            'template' => '{view}{sep1}{update}{sep2}{delete}',
            'buttons' => array(
                'view' => array
                    (
                    'label' => 'View',
                    'imageUrl' => false,
                ),
                'sep1' => array
                    (
                    'label' => ' | ',
                    'url' => '',
                    'imageUrl' => false,
                    
                ),
                'update' => array
                    (
                    'label' => 'Update',
                    'imageUrl' => false,
                ),
                'sep2' => array
                    (
                    'label' => ' | ',
                    'url' => '',
                    'imageUrl' => false,
                    
                ),
                'delete' => array
                    (
                    'label' => 'Delete',
                    'imageUrl' => false,
                ),
            )
        ),
    ),
));
?>
