<?php
$this->breadcrumbs = array(
    'Developer Notes' => array('index'),
    'Manage',
);

$this->menu = array(
    //array('label'=>'List DeveloperNote', 'url'=>array('index')),
    array('label' => 'Create Developer Note', 'url' => array('create')),
);

Yii::app()->clientScript->registerScript('search', "
$('.search-button').click(function(){
	$('.search-form').toggle();
	return false;
});
$('.search-form form').submit(function(){
	$.fn.yiiGridView.update('developer-note-grid', {
		data: $(this).serialize()
	});
	return false;
});
");
?>

<h1>Manage Developer Notes</h1>



<?php
$this->widget('zii.widgets.grid.CGridView', array(
    'id' => 'developer-note-grid',
    'dataProvider' => $model->search(),
    'filter' => $model,
    'columns' => array(
        array(
            'name' => 'id',
            'htmlOptions' => array('style' => 'width:20px;')
        ),
        'ticketNumber',
        'developer',
        'description',
        'status',
        'datetime',
        /*
          'createdBy',
         */
        array(
            'class' => 'CButtonColumn',
            'template' => '{view}{sep1}{update}{sep2}{delete}',
            'buttons' => array(
                'view' => array
                    (
                    'label' => 'View',
                    'imageUrl' => false,
                ),
                'sep1' => array
                    (
                    'label' => ' | ',
                    'imageUrl' => false,
                ),
                'update' => array
                    (
                    'label' => 'Update',
                    'imageUrl' => false,
                ),
                'sep2' => array
                    (
                    'label' => ' | ',
                    'imageUrl' => false,
                ),
                 'delete' => array
                    (
                    'label' => 'Delete',
                    'imageUrl' => false,
                ),
            ),
        ),
    ),
));
?>
