<div class="form">

    <?php   

    $form = $this->beginWidget('CActiveForm', array(
        'id' => 'emails-form',
        'enableAjaxValidation' => false,
    ));
    ?>

    <p class="note">Fields with <span class="required">*</span> are required.</p>

    <?php echo $form->errorSummary($model); ?>

    <div class="row">
        <?php echo $form->labelEx($model, 'fromaddress'); ?>
        <?php echo $form->textField($model, 'fromaddress', array('size' => 60, 'maxlength' => 255)); ?>
        <?php echo $form->error($model, 'fromaddress'); ?>
    </div>
    <div class="row">
        <?php echo $form->labelEx($model, 'toemailaddresses'); ?>
        <?php echo $form->textField($model, 'toemailaddresses', array('size' => 60, 'maxlength' => 255)); ?>
        <?php echo $form->error($model, 'toemailaddresses'); ?>
    </div>
    <div class="clear"></div>
    <div class="row">
        <?php echo $form->labelEx($model, 'ccemailaddresses'); ?>
        <?php echo $form->textField($model, 'ccemailaddresses', array('placeholder' => 'use comma(;) to add multiple addresses', 'style' => 'width:620px;')); ?>
        <?php echo $form->error($model, 'ccemailaddresses'); ?>
    </div>
    <div class="clear"></div>
    <div class="row">
        <?php echo $form->labelEx($model, 'bccEmailAddresses'); ?>
        <?php echo $form->textField($model, 'bccEmailAddresses', array('placeholder' => 'use comma(;) to add multiple addresses', 'maxlength' => 255, 'style' => 'width:620px;')); ?>
        <?php echo $form->error($model, 'bccEmailAddresses'); ?>
    </div>
    <div class="clear"></div>
    <div class="row">
        <?php echo $form->labelEx($model, 'subject'); ?>
        <?php echo $form->textField($model, 'subject', array('size' => 60, 'maxlength' => 255, 'style' => 'width:620px;')); ?>
        <?php echo $form->error($model, 'subject'); ?>
    </div>
    <div class="clear"></div>
    <div class="row">
        <?php echo $form->labelEx($model, 'bodyText'); ?>
        <?php echo $form->textArea($model, 'bodyText', array('style' => 'width:650px;height:350px')); ?>
        <?php echo $form->error($model, 'bodyText'); ?>
    </div>
    <div class="clear"></div>
    <div class="row">
        <?php
        echo CHtml::link('Attach File', array(
            '#',
            'id' => ''
        ), array('style' => 'margin-left:10px;', 'onclick' => 'showFileInventoryModal("select-inventory-file-item-model");return false;'));
        ?>
    </div>
    <div class="clear"></div>
    <div class="row">
        <?php echo $form->labelEx($model, 'fileattachment'); ?>
        <?php
        echo
        $form->textField($model, 'fileattachment', array('size' => 60, 'maxlength' => 255, 'readonly' => true));
        echo CHtml::link('View PDF', array(
            'fileInventory/viewfile',
            'id' => $emailattachement->fileinventory_id
        ), array('style' => 'margin-left:10px;', 'target' => '_blank'));



        echo $form->hiddenField($model, 'type', array('size' => 60, 'maxlength' => 255));
        ?>
        <?php echo $form->error($model, 'fileattachment'); ?>
    </div>

    <?php if(isset($_GET['type']) && $_GET['type'] == 'Quote'): ?>
    <div class="row">
        <?php echo $form->labelEx($model, 'quoteAcceptanceEnablePayLater'); ?>
        <?php echo $form->checkBox($model, 'quoteAcceptanceEnablePayLater', array()); ?>
        <?php echo $form->error($model, 'quoteAcceptanceEnablePayLater'); ?>
    </div>
    <?php endif; ?>

    <div class="row">

        <?php echo $form->textField($emailattachement, 'fileinventory_id', array('style' => 'display:none;')); ?>

    </div>
    <div class="clear"></div>
    <div class="row" id="attachment-section">
        <?php
            if(isset(Yii::app()->session[$model->type])) {

                $fileAttachmentIds = array_filter(explode(',', Yii::app()->session[$model->type]));

                foreach($fileAttachmentIds as $id) {
                    $fileInventory = FileInventory::model()->findByPk($id);
                    echo '<span id="EmailAttachment_holder_'.$id.'"><input size="60" maxlength="255" readonly="readonly" id="EmailAttachments_'.$id.'" type="text" value="'.$fileInventory->filename.'">
                        &nbsp;<a style="margin-left:10px;" target="_blank" href="index.php?r=fileInventory/downloadFile&id='.$id.'">Download File</a>  
                        &nbsp;|&nbsp;<a style="margin-left:10px;"  href="#" onclick="removeAttachment('.$id.');return false;">Remove</a><br /></span>';
                }

            }
            
        ?>
    </div>
    <div class="clear"></div>
    <div class="row buttons">
        <?php echo CHtml::submitButton('Send'); ?>
    </div>

    <?php $this->endWidget(); ?>

</div><!-- form -->
<!-- end add new decoration model -->


<div id="select-inventory-file-item-model" class="modal fade modal-dialog" role="dialog">

    <!-- Modal content-->
    <div class="modal-content">
        <div class="modal-header">

            <h3 style="text-align: center;">Select Attachments</h3>
        </div>
        <div class="modal-body">
            <?php
            
            $this->renderPartial('/fileInventory/_admin_grid', array('model' => $fileInventoryModel));
            ?>
        </div>
        <div class="modal-footer">
            <button type="button" class="btn btn-default" data-dismiss="modal" onclick="addAttachmentFromFileInvenotry();">Add</button>
            <button type="button" class="btn btn-default" data-dismiss="modal">Close</button>
        </div>
    </div>

</div>
<style>
    #select-inventory-file-item-model {
        width: 900px;

    }
</style>
<script src="https://cdn.tiny.cloud/1/0skwx0zckjr5gi6y1ydjqgw6ii9npl8qvvyhlae14aq1ow52/tinymce/5/tinymce.min.js" referrerpolicy="origin"></script>
<script>
    tinymce.init({
        selector: '#Emails_bodyText'
    });

    function showFileInventoryModal(id) {
        showcentermodel(id);
    }

    function showcentermodel(id) {
        $("#" + id).modal('show').css({
            'margin-top': function() {
                return -($(this).height() / 2);
            },
            'margin-left': function() {
                return -($(this).width() / 2);
            },
        })
    }

    function addAttachmentFromFileInvenotry() {

        var values = new Array();
        $.each($("input[name='file-inventory-grid_c0[]']:checked"), function() {
            values.push($(this).val());
            // or you can do something to the actual checked checkboxes by working directly with  'this'
            // something like $(this).hide() (only something useful, probably) :P
        });

        if (values.length > 0) {

            var fileAttachmentIdString = values + "";
            var emailType = $('#Emails_type').val();
            $.ajax({
                type: 'POST',
                url: '<?php echo Yii::app()->createUrl("emails/addFileAttachments"); ?>',
                data: `type=${emailType}&fileAttachmentIdString=${fileAttachmentIdString}`,
                dataType: 'json',
                success: function(result) {


                    let attachments = result.fileInventoryItems;
                    
                    let elements = ``;
                    Object.keys(attachments).forEach((invetoryId) => {
                        console.log(invetoryId, attachments[invetoryId]);
                        elements += `<span id="EmailAttachment_holder_${invetoryId}"><input size="60" maxlength="255" readonly="readonly" id="EmailAttachments_${invetoryId}" type="text" value="${attachments[invetoryId]}">`;
                        elements += `&nbsp;<a style="margin-left:10px;" target="_blank" href="index.php?r=fileInventory/downloadFile&id=${invetoryId}">Download File</a>`;  
                        elements += `&nbsp;|&nbsp;<a style="margin-left:10px;"  href="#" onclick="removeAttachment(${invetoryId});return false;">Remove</a><br /></span>`; 
                    });

                    $('#attachment-section').append(elements);
                    



                },
                error: function(result) {
                    console.log(result);
                }
            });

        }
    }

    function removeAttachment(id) {

        var emailType = $('#Emails_type').val();
            $.ajax({
                type: 'POST',
                url: '<?php echo Yii::app()->createUrl("emails/removeFileAttachments"); ?>',
                data: `type=${emailType}&fileAttachmentId=${id}`,
                dataType: 'json',
                success: function(result) {

                    $(`#EmailAttachment_holder_${id}`).remove();
                    
                },
                error: function(result) {
                    console.log(result);
                }
            });

       
        return false;
    }
</script>