<?php
$this->breadcrumbs=array(
	'Emails'=>array('index'),
	'Manage',
);

$jobmenu = null;

if(isset(Yii::app()->session['job'])){
    $job = Jobs::model()->findByPk(Yii::app()->session['job']);
    $jobmenu = array('label'=>'Back to : ' . $job->jobNum, 'url'=>array('jobs/view','id'=>$job->id));
}

$this->menu=array(
        $jobmenu,
	//array('label'=>'List Emails', 'url'=>array('index')),
	//array('label'=>'Create Emails', 'url'=>array('create')),
);

Yii::app()->clientScript->registerScript('search', "
$('.search-button').click(function(){
	$('.search-form').toggle();
	return false;
});
$('.search-form form').submit(function(){
	$.fn.yiiGridView.update('emails-grid', {
		data: $(this).serialize()
	});
	return false;
});
");
?>

<h1>Manage Emails</h1>
<?php
    foreach(Yii::app()->user->getFlashes() as $key => $message) {
        echo '<div class="flash-' . $key . '">' . $message . "</div>\n";
    }
?>

<p>
You may optionally enter a comparison operator (<b>&lt;</b>, <b>&lt;=</b>, <b>&gt;</b>, <b>&gt;=</b>, <b>&lt;&gt;</b>
or <b>=</b>) at the beginning of each of your search values to specify how the comparison should be done.
</p>

<?php echo CHtml::link('Advanced Search','#',array('class'=>'search-button')); ?>
<div class="search-form" style="display:none">
<?php $this->renderPartial('_search',array(
	'model'=>$model,
)); ?>
</div><!-- search-form -->

<?php $this->widget('zii.widgets.grid.CGridView', array(
	'id'=>'emails-grid',
	'dataProvider'=>$model->search(),
	'filter'=>$model,
	'columns'=>array(
                'subject',
		'fromaddress',
		array(
                    'name'=>'emailAddressSearch',
                    'value'=>'$data->toemailaddresses ."<br />Ccs : <br />" . $data->ccemailaddresses ."<br />Bccs : <br />" . $data->bccEmailAddresses',
                    'type'=>'html'
                ),
           
//            array(
//                'name'=>'bodyText',
//                'value'=>'nl2br(substr(trim($data->bodyText), 0,50))',
//                'type'=>'raw',
//            ),
		array(
                    'name'=>'createdBy',
                    'value'=>'User::model()->findByPk($data->createdBy)->username'
                ),
                array(
                    'name'=>'createdDtm',
                    'value'=>'date(GlobalVars::get("DateFormat"),strtotime($data->createdDtm))'
                ),
		
		 array(
                'class' => 'CButtonColumn',
                'template' => '{view}{sep}{update}{sep2}{delete}',
                'buttons' => array(
                    'view' => array
                        (
                        'label' => 'View',
                        'imageUrl' => false,
                        
                    ),
                    'sep' => array
                        (
                        'label' => ' | ',
                        'imageUrl' => false,
                        
                    ),
                    'update' => array
                        (
                        'label' => 'Update',
                        'imageUrl' => false,
                        
                    ),
                    'sep2' => array
                        (
                        'label' => ' | ',
                        'imageUrl' => false,
                        
                    ),
                    'delete' => array
                        (
                        'label' => 'Delete',
                        'imageUrl' => false,
                        
                    ),
                ),
            ),
	),
)); ?>
