<div class="form">

    <?php
    $form = $this->beginWidget('CActiveForm', array(
        'id' => 'file-inventory-form',
        'enableAjaxValidation' => false,
        'htmlOptions' => array('enctype' => 'multipart/form-data'),
    ));
    ?>

    <p class="note">Fields with <span class="required">*</span> are required.</p>

        <?php echo $form->errorSummary($model); ?>

    <div class="row">
        <?php echo $form->textField($model, 'type', array('style'=>'display:none;')); ?>
         <?php echo $form->textField($model, 'ref_id', array('style'=>'display:none;')); ?>
        <?php echo $form->labelEx($model, 'filename'); ?>
<?php echo $form->fileField($model, 'filename'); ?>
<?php echo $form->error($model, 'filename'); ?>
    </div>	
    <div class="row">
        <label for="FileInventory_documentfilename" class="required">
            Document Name
            <span class="required">*</span>
        </label>
        
        <?php echo $form->textfield($model, 'documentfilename'); ?>
        <?php echo $form->error($model, 'documentfilename'); ?>
    </div>	
    <div class="row">
        <?php echo $form->labelEx($model, 'comments'); ?>
        <?php echo $form->textArea($model, 'comments', array('rows' => 6, 'cols' => 80, 'style' => 'width:300px;')); ?>
        <?php echo $form->error($model, 'comments'); ?>

    </div>	
    <div class="row">
        <?php echo $form->labelEx($model, 'followup_sts_id'); ?>
        <?php echo $form->dropDownList($model,'followup_sts_id', CHtml::listData(FollowupStatus::model()->findAll(array('condition'=>"type = '{$model->statusType}'", 'order' => 'status ASC')), 'id', 'status'), array('empty'=>'Select Status')) ?>
        <?php echo $form->error($model, 'followup_sts_id'); ?>
        
    </div>
    <div class="clear"></div>
    <div style="width:100%;">
        <?php
       
        echo CHtml::submitButton('Upload', array(
            'onclick' => 'javascript: uploadDocument();return false;', // on submit call JS send() function
            'id' => 'upload-submit-btn', // button id        
            'style'=>'float:right',
        ));
         echo CHtml::image('images/loading.gif', '', array('id'=>'doc-upload-processing',  'style' => 'width:35px;float:right;margin-top:5px;display:none;'));
        ?>
    </div>

<?php $this->endWidget(); ?>

</div><!-- form -->

<script>
     function setAddDocument(){
         
         $('#add-doc-form-div').slideDown(500);
         $('#update-doc-form-div').slideUp(500);
     }
     
     function uploadDocument() {
        $('#doc-upload-processing').show(); 
        var fd = new FormData($("#file-inventory-form")[0]);
        //var e = document.getElementById("subrowimage");
        fd.append("FileInventory[ref_id]", $('#FileInventory_ref_id').val());
        fd.append("FileInventory[type]", $('#FileInventory_type').val());
        $.ajax({
            url: '<?php echo Yii::app()->createUrl("fileInventory/uploadDocument"); ?>',
            type: 'POST',
            data: fd,
            //datatype: 'json',
            // async: false,
            beforeSend: function() {
                // do some loading options
            },
            success: function(result) {
               // alert('File has been updated!');
                $.fn.yiiGridView.update("file-inventory-grid");
               if( $('#sales-log-grid').length ) 
                    $.fn.yiiGridView.update("sales-log-grid");
                $('#doc-upload-processing').hide(); 
                clearLog();
                
            },
            complete: function() {
               //$('#doc-upload-processing').hide(); 
            },
            error: function(data) {
                $('#doc-upload-processing').hide(); 
                alert("Error in uploading. Try again later");
            },
            cache: false,
            contentType: false,
            processData: false
        });

        return false;
    }
</script>