<div class="form">

    <?php
    $form = $this->beginWidget('CActiveForm', array(
        'id' => 'update-file-inventory-form',
        'enableAjaxValidation' => false,
        'htmlOptions' => array('enctype' => 'multipart/form-data'),
    ));
    ?>

    <p class="note">Fields with <span class="required">*</span> are required.</p>

        <?php echo $form->errorSummary($model); ?>

    <div class="row">
        <?php echo $form->labelEx($model, 'filename'); ?>
<?php echo $form->fileField($model, 'filename',array('id'=>'updt_filename')); ?>
<?php echo $form->error($model, 'filename'); ?>
    </div>	
    <div class="row">
        <label for="FileInventory_documentfilename" class="required">
            Document Name
            <span class="required">*</span>
        </label>
        <?php echo $form->textfield($model, 'id',array('id'=>'updt_id', 'style'=>'display:none;')); ?>
        <?php echo $form->textfield($model, 'type',array('id'=>'updt_type','style'=>'display:none;')); ?>
        <?php echo $form->textfield($model, 'ref_id',array('id'=>'updt_ref_id','style'=>'display:none;')); ?>
        <?php echo $form->textfield($model, 'documentfilename',array('id'=>'updt_documentfilename')); ?>
        <?php echo $form->error($model, 'documentfilename'); ?>
    </div>	
    <div class="row">
        <?php echo $form->labelEx($model, 'comments'); ?>
        <?php echo $form->textArea($model, 'comments', array('rows' => 6, 'cols' => 80, 'style' => 'width:300px;', 'id'=>'updt_comments')); ?>
        <?php echo $form->error($model, 'comments'); ?>

    </div>	
    <div class="row">
        <?php echo $form->labelEx($model, 'followup_sts_id'); ?>
        <?php echo $form->dropDownList($model,'followup_sts_id', CHtml::listData(FollowupStatus::model()->findAll(array('condition'=>"type = '{$model->statusType}'", 'order' => 'status ASC')), 'id', 'status'), array('empty'=>'Select Status','id'=>'updt_followup_sts_id')) ?>
        <?php echo $form->error($model, 'followup_sts_id'); ?>
        
    </div>
    <div class="clear"></div>
    <div style="width:100%;">
        <?php
        echo CHtml::submitButton('Save', array(
            'onclick' => "javascript: updateDocument();return false;", // on submit call JS send() function
            'id' => 'update-submit-btn', // button id      
            'style'=>'float:right',
        ));
         echo CHtml::image('images/loading.gif', '', array('id'=>'doc-update-processing',  'style' => 'width:35px;float:right;margin-top:5px;display:none;'));
        ?>
    </div>

<?php $this->endWidget(); ?>

</div><!-- form -->

<script>
    function setUpdateFields(id){
        
    
        $.ajax({
            type: 'POST',
            url: '<?php echo Yii::app()->createUrl("fileInventory/fetchFields"); ?>',
            data: {'id': id},
            dataType: 'json',
            success: function(result) {
            
                $('#updt_id').val(result.id);
                $('#updt_documentfilename').val(result.documentfilename);
                $('#updt_comments').val(result.comments);
                $('#updt_followup_sts_id').val(result.followup_sts_id);

            },
            error: function(result) {
                alert('error in fetch document fields');
            }
        });
    }
    
    
    function updateDocument() {
        $('#doc-update-processing').show(); 
        var fd = new FormData($("#update-file-inventory-form")[0]);
        //var e = document.getElementById("subrowimage");
        fd.append("FileInventory[id]", $('#updt_id').val());
        fd.append("FileInventory[documentfilename]", $('#updt_documentfilename').val());
        fd.append("FileInventory[comments]", $('#updt_comments').val());
        fd.append("FileInventory[followup_sts_id]", $('#updt_followup_sts_id').val());
        //fd.append("FileInventory[type]", 'JOB');
        $.ajax({
            url: '<?php echo Yii::app()->createUrl("fileInventory/updateDocument"); ?>',
            type: 'POST',
            data: fd,
            //datatype: 'json',
            // async: false,
            beforeSend: function() {
                // do some loading options
            },
            success: function(result) {
               //alert('File has been updated!');
                $.fn.yiiGridView.update("file-inventory-grid");
                if( $('#sales-log-grid').length ) 
                    $.fn.yiiGridView.update("sales-log-grid");
                $('#doc-update-processing').hide();
                clearLog();

            },
            complete: function() {
                //$('#doc-update-processing').hide();
            },
            error: function(data) {
                $('#doc-update-processing').hide();
                alert("Error in uploading. Try again later");
            },
            cache: false,
            contentType: false,
            processData: false
        });

        return false;
    }
</script>