<?php
if (Yii::app()->controller->id == 'fileInventory') {
    $this->breadcrumbs = array(
        'File Inventories' => array('index'),
        'Manage',
    );

    $this->menu = array(
        array('label' => 'List FileInventory', 'url' => array('index')),
        array('label' => 'Create FileInventory', 'url' => array('create')),
    );

    Yii::app()->clientScript->registerScript('search', "
$('.search-button').click(function(){
	$('.search-form').toggle();
	return false;
});
$('.search-form form').submit(function(){
	$.fn.yiiGridView.update('file-inventory-grid', {
		data: $(this).serialize()
	});
	return false;
});
");
    ?>

    <h1>Manage File Inventories </h1>



    <?php
}
$this->widget('zii.widgets.grid.CGridView', array(
    'id' => 'file-inventory-grid',
    'dataProvider' => $model->search(),
    'filter' => $model,
    'columns' => array(
        //'id',
        array(
            'name' =>  'filename',
            'value' => '$data->getFileView() . "<br><h5 align=\'center\'>" . $data->filename . "</h5>"',
            'type' => 'html',
        ),
        array(
            'name' => 'createdDtm',
            'value' => 'date(GlobalVars::get("DateFormat"),strtotime($data->createdDtm))'
        ),
        
        array(
            'class' => 'CButtonColumn',
            'template' => '{delete}{sep}{download}',
            'buttons' => array
                (                
                'delete' => array
                    (
                    'label' => 'Delete',
                    'imageUrl' => false,
                    'url' => 'Yii::app()->createUrl("fileInventory/delete", array("id"=>$data->id))',
                ),
                'sep' => array
                    (
                    'label' => ' | ',
                    'imageUrl' => false,
                ),
                'download' => array
                    (
                    'label' => 'Download',
                    'imageUrl' => false,
                    'url' => 'Yii::app()->createUrl("fileInventory/downloadFile", array("id"=>$data->id))',
                ),
            ),
        ),
    ),
));
?>
