<div>
    <div class="form">

        <?php
        $form = $this->beginWidget('CActiveForm', array(
            'id' => 'followup-status-form',
            'enableAjaxValidation' => false,
        ));
        ?>

        <p class="note">Fields with <span class="required">*</span> are required.</p>

        <?php echo $form->errorSummary($model); ?>
        <div class="row">
            <?php echo $form->labelEx($model, 'type'); ?>
            <?php
            echo $form->dropDownList($model, 'type', array(
                FollowupStatus::QUOTATION => 'Quotation',
                FollowupStatus::SALES_ORDER => 'Sales Order',
                FollowupStatus::JOB => 'Job',
                FollowupStatus::INVOICE => 'Invoice',
                FollowupStatus::PURCHASE_ORDER => 'Purchase Order',
                FollowupStatus::CUSTOMER => 'Customer',
                FollowupStatus::WEBSTORE_ORDER => 'WebStoreOrder',
                FollowupStatus::OTHER => 'Other'
                    ), array('empty' => '-- Select --'));
            ?>
            <?php echo $form->error($model, 'type'); ?>
        </div>

        <div class="row">
            <?php echo $form->labelEx($model, 'status'); ?>
            <?php echo $form->textField($model, 'status', array('size' => 60, 'maxlength' => 100, 'readonly' => $model->isSystemRequired())); ?>
            <?php echo $form->error($model, 'status'); ?>
        </div>

        <div class="row">
            <?php Yii::import('application.extensions.yii-colorpicker-master.ColorPicker'); ?>
            <?php echo $form->labelEx($model, 'color_hex'); ?>
            <?php
            $this->widget('ColorPicker', array(
                'model' => $model,
                'attribute' => 'color_hex',
                'options' => array(// Optional
                    'pickerDefault' => "ccc", // Configuration Object for JS
                ),
            ));
            ?>
            <?php echo $form->error($model, 'color_hex'); ?>
        </div>

        <div class="row">
            <?php echo $form->labelEx($model, 'send_email_onchange_followup'); ?>
            <?php echo $form->checkBox($model, 'send_email_onchange_followup', array('size' => 60, 'maxlength' => 100)); ?>
            <?php echo $form->error($model, 'send_email_onchange_followup'); ?>
        </div>

        <div class="row">
            <?php echo $form->labelEx($model, 'email_template_text_id'); ?>
            <?php echo $form->dropDownList($model, 'email_template_text_id', CHtml::listData(TemplateText::model()->findAll(array('order' => 'template_id ASC')), 'id', 'name'), array('empty' => '')); ?>
            <?php echo $form->error($model, 'email_template_text_id'); ?>
        </div>

        <div class="clear"></div>
        <div class="row buttons">
            <?php echo CHtml::submitButton($model->isNewRecord ? 'Create' : 'Save'); ?>
        </div>

        <?php $this->endWidget(); ?>

    </div><!-- form --> 
</div>
