<?php
$this->breadcrumbs = array(
    'Followup Statuses' => array('index'),
    'Manage',
);

$this->menu = array(
    //array('label'=>'List FollowupStatus', 'url'=>array('index')),
    array('label' => 'Create Status', 'url' => array('create')),
);

Yii::app()->clientScript->registerScript('search', "
$('.search-button').click(function(){
	$('.search-form').toggle();
	return false;
});
$('.search-form form').submit(function(){
	$.fn.yiiGridView.update('followup-status-grid', {
		data: $(this).serialize()
	});
	return false;
});
");
?>

<h1>Manage Statuses</h1>



<?php
Yii::import('application.extensions.yii-colorpicker-master.ColorPicker');
$this->widget('zii.widgets.grid.CGridView', array(
    'id' => 'followup-status-grid',
    'dataProvider' => $model->search(),
    'filter' => $model,
    'columns' => array(
        'id',
        array(
            'name' => 'type',
            'value' => '$data->type',
            'filter' => CHtml::dropDownList('FollowupStatus[type]', $model->type, array(
                '' => '',
                FollowupStatus::QUOTATION => 'Quotation',
                FollowupStatus::SALES_ORDER => 'Sales Order',
                FollowupStatus::JOB => 'Job',
                FollowupStatus::INVOICE => 'Invoice',
                FollowupStatus::PURCHASE_ORDER => 'Purchase Order',
                FollowupStatus::CUSTOMER => 'Customer',
                FollowupStatus::OTHER => 'Other'
                    )
            ),
        // 'type' => 'raw',
        ),
        array(
            'name' => 'status_sequence',
            'type' => 'raw',
            'value' => 'CHtml::textField("",$data->status_sequence,array("id"=>$data->id,"name"=>"status_sequence","onchange"=>"updateSequence(this.id,this.value);")) . '
            . '"<span class=\'field-success\' style=\'margin-left:5px;display:none;\'><img src=\'images/success_tick.png\' style=\'max-height:20px;\'/></span>" . "<span class=\'field-warning\' style=\'margin-left:5px;display:none;\'><img title=\'not saved!\' src=\'images/warning-tick.png\' style=\'max-height:20px;\'/></span>" ',
        ),
        'status',
        array(
            'name' => 'color_hex',
            'value' => '$data->color_hex ? "<div style=\'background-color:".$data->color_hex.";width:30px;height:30px;\'>&nbsp;</div>" : ""',
            'type' => 'raw'
        ),
        array(
            'class' => 'CButtonColumn',
            'template' => '{view}{sep1}{update}{sep2}{delete}',
            'buttons' => array(
                'view' => array
                    (
                    'label' => 'View',
                    'imageUrl' => false,
                ),
                'sep1' => array
                    (
                    'label' => ' | ',
                    'url' => '',
                    'imageUrl' => false,
                    //'visible' => '!$data->system_required',
                ),
                'update' => array
                    (
                    'label' => 'Update',
                    'imageUrl' => false,
                   // 'visible' => '!$data->system_required',
                ),
                'sep2' => array
                    (
                    'label' => ' | ',
                    'url' => '',
                    'imageUrl' => false,
                    'visible' => '!$data->system_required',
                ),
                'delete' => array
                    (
                    'label' => 'Delete',
                    'imageUrl' => false,
                    'visible' => '!$data->system_required',
                ),
            )
        ),
    ),
));
?>
<script>
    function updateSequence(id, value) {
        $.ajax({
            type: 'POST',
            url: '<?php echo Yii::app()->createUrl("followupStatus/updateStatusSequence"); ?>',
            data: {'id': id, 'value': value},
            dataType: 'json',
            success: function (result) {
                console.log(result);
                showFieldSuccess($('#' + id));
            },
            error: function (result) {
                console.log(result);
                showFieldWarning($('#' + id));
            }
        });
    }

    function showFieldSuccess(obj) {
        $(obj).closest('td').find(".field-warning").hide();
        $(obj).closest('td').find(".field-success").fadeIn(500).fadeOut(1500);
    }

    function showFieldWarning(obj) {
        $(obj).closest('td').find(".field-warning").fadeIn(500);
    }
</script>