<?php
$this->breadcrumbs = array(
    'Goods Issue Notes' => array('index'),
    $model->id,
);

$this->menu = array(
    array('label' => 'Back to : ' . $job->jobNum, 'url' => array('jobs/view', 'id' => $job->id)),
    //array('label'=>'List GoodsIssueNote', 'url'=>array('index')),
    //array('label' => 'Create GoodsIssueNote', 'url' => array('create')),
    //array('label'=>'Update GoodsIssueNote', 'url'=>array('update', 'id'=>$model->id)),
    array('label' => 'Delete GoodsIssueNote', 'url' => '#', 'linkOptions' => array('submit' => array('delete', 'id' => $model->id), 'confirm' => 'Are you sure you want to delete this item?')),
    array('label' => 'Manage GoodsIssueNote', 'url' => array('admin')),
);
?>

<h1>View Goods Issue Note #<?php echo $model->id; ?></h1>

<?php
$this->widget('zii.widgets.CDetailView', array(
    'data' => $model,
    'attributes' => array(
        'id',
        'ginnum',
        array(
            'name' => 'workorder_id',
            'value' => CHtml::link($model->job->workorder->salesorderNumber, array('workorderdetails/admin', 'wid' => $model->workorder_id), array("target" => "_blank")),
            'type' => 'raw',
        ),
        array(
            'name' => 'job.jobNum',
            'value' => CHtml::link($model->job->jobNum, array('jobs/view', 'id' => $model->job_id), array("target" => "_blank")),
            'type' => 'raw',
        ),
        array(
            'name' => 'porder.poNum',
            'value' => CHtml::link($model->porder->poNum, array('purchaseOrders/view', 'id' => $model->po_id), array("target" => "_blank")),
            'type' => 'raw',
        ),
        array(
            'name' => 'supplier_id',
            'value' => CHtml::link(Supplier::model()->findByPk($model->supplier_id)->supnam, array('supplier/view', 'id' => $model->supplier_id), array("target" => "_blank")),
            'type' => 'raw',
        ),
        
        array(
            'name' => 'issuedDtm',
            
            'value'=>  date(GlobalVars::get("DateFormat"),  strtotime($model->issuedDtm)),
        ),
        array(
            'name' => 'createdDtm',
            
            'value'=>  date(GlobalVars::get("DateFormat"),  strtotime($model->createdDtm)),
        ),
        array(
            'name' => 'createdBy',
            'value' => User::model()->findByPk($model->createdBy)->username,
        ),
        array(
            'name' => 'status_id',
            'value' => Status::model()->findByPk($model->status_id)->name,
        ),
        'ginType',
    ),
));
?>
<div class="view">
    <br> <span style="font-size: 1em;font-weight: bold;">Sales Contacts & Activities</span>   
<?php
$salesLog = new SalesLog();
$salesLog->quoteId = $model->job->workorder->quotationId;
$salesLog->workorderId = $model->job->workorder->id;
$salesLog->quoteNum = $model->job->workorder->quotationNumber;
$salesLog->category = $model->ginnum;

$this->renderPartial('/salesLog/_crmgrid', array('salesLog' => $salesLog));
?>    


    <span style="font-size: 1em;font-weight: bold;">Add Sales Contact or Activity</span>  <br> 
    <div class="form">

<?php
$this->renderPartial('/salesLog/_crmform', array('salesLog' => $salesLog));
?>
    </div>
</div>
<div class="clear"></div>

<?php
$grndtls = new GoodsIssueDetails();
$grndtls->gin_id = $model->id;


$this->widget('zii.widgets.grid.CGridView', array(
    'id' => 'po-details-grid',
    'dataProvider' => $grndtls->search(),
    'filter' => null,
    'columns' => array(
        'id',
        array(
            'name' => 'workorderDtl.image',
            'type' => 'raw',
            'value' => 'CHtml::image($data->workorderDtl->getImg())',
            'htmlOptions' => array('style' => 'width:100px;'),
        ),
        array(
            'name' => 'workorderDtl.productsku',
            'value' => '!empty($data->workorderDtl->productsku) ? $data->workorderDtl->prdsrtdesc . $data->workorderDtl->getProdSupplierLink() : $data->workorderDtl->custmproduct . $data->workorderDtl->getProdSupplierLink()',
            'type' => 'raw',
        ),
        array(
            'name' => 'workorderDtl.prdlngdesc',
            'type' => 'raw',
            'htmlOptions' => array('style' => 'width:200px;'),
            'value' => '$data->workorderDtl->prdlngdesc . $data->workorderDtl->getSizeQtyColorTable() ',
        ),
        array(
            'name' => 'workorderDtl.decprtnam',
            'type' => 'raw',
            'htmlOptions' => array('style' => 'width:150px;'),
            'value' => '!empty($data->jobproductdeco->decprtnam) ? $data->jobproductdeco->decdesc . $data->jobproductdeco->getCustomizationDetail() . $data->jobproductdeco->getDecoSupplierLink() : $data->jobproductdeco->customdecoration . $data->jobproductdeco->getCustomizationDetail() . $data->jobproductdeco->getDecoSupplierLink()',
        ),
        array(
            'name' => 'qty',
            'htmlOptions' => array('style' => 'text-align:center'),
        ),
//         array(
//            'name' => 'supplier.supnam',
//            'type' => 'raw',
//            'value' => 'CHtml::link($data->supplier->supnam,array("supplier/view","id"=>$data->supplier->supsno))',
//            'htmlOptions' => array('style' => 'width:100px;'),
//        ),

    /*
      'prodQty',
      'decoQty',
      'customizationDetails',
      'notes',
      'extracomments',
      'sellPriceExVat',
      'sellPriceIncVat',
      'totExVat',
      'totIncVat',
      'image',
      'createdby',
      'createddate',
     */
    ),
));
?>
<div id="comntdiv" class="view">
<?php
echo CHtml::label('Comments', '');
echo CHtml::activeTextArea($model, 'comments', array('rows' => 5, 'style' => 'width:880px;'));
echo CHtml::button('Save Text', array('onclick' => "saveComnt($model->id);",));
?>
</div>

<div style="display: inline;float: right;">
    <?php
    echo CHtml::button('Send GIN', array('onclick' => "", 'disabled' => true));
    echo CHtml::button('Print PDF', array('onclick' => "printPDF($model->id)"));
    ?>
</div>
<script>
    function printPDF(id) {
        var win = window.open('index.php?r=goodsIssueNote/print&id=' + id);
    }
</script>

<script>
    function saveComnt(id) {
        var text = $('#GoodsIssueNote_comments').val();



        $.ajax({
            type: 'POST',
            url: '<?php echo Yii::app()->createUrl("goodsIssueNote/updateComments"); ?>',
            data: {'id': id, 'text': text},
            dataType: 'json',
            success: function(result) {
                if (result.status === 'success') {
                    $('#comntdiv').append("<span id='spstxtmsg' style='display:none;color:#00ff00;font-weight:bold;'>Text are saved successfully.</span>");
                    $('#spstxtmsg').fadeIn(500).fadeOut(2500);
                }
            }
        });

    }




</script>