<h1>Create Goods Received Note</h1>



<div class="form">

    <?php
    $form = $this->beginWidget('CActiveForm', array(
        'id' => 'purchase-orders-_poform-form',
        'enableAjaxValidation' => false,
    ));
    ?>

    <p class="note">Fields with <span class="required">*</span> are required.</p>

    <?php echo $form->errorSummary($model); ?>





    <div class="row">
        <?php echo $form->labelEx($model, 'supplier_id'); ?>
        <?php
        echo $form->dropDownList($model, 'supplier_id', CHtml::listData(Supplier::model()->findAll(array('order' => 'supnam asc')), 'supsno', 'supnam'), array('empty' => 'Select Supplier'));
        ?>
        <?php echo $form->error($model, 'supplier_id'); ?>
    </div>	
    

    <div style="width:100%;">
        <?php echo $form->labelEx($model, 'grnnum'); ?>
        <?php echo $form->textField($model, 'grnnum'); ?>
        <?php echo $form->error($model, 'grnnum'); ?>
    </div>
    <div class="clear"></div>

    <div class="row">
        <?php echo $form->labelEx($model, 'receivedDate'); ?>
        <?php
        Yii::import('application.extensions.CJuiDateTimePicker.CJuiDateTimePicker');
        $this->widget('CJuiDateTimePicker', array(
            'model' => $model, //Model object
            'attribute' => 'receivedDate', //attribute name
            'mode' => 'date', //use "time","date" or "datetime" (default)
            'options' => array("dateFormat" => 'dd-mm-yy', "changeMonth" => 'true', 'changeYear' => 'true'), // jquery plugin options
            'language' => 'en-GB'
        ));
        ?>
        <?php echo $form->error($model, 'receivedDate'); ?>
    </div>


    <div class="clear"></div>
    



<div class="view">
    <h3>GRN Details</h3>
    <?php
    $this->widget('zii.widgets.grid.CGridView', array(
        'id' => 'purchase-orders-details-grid',
        'dataProvider' => $grndetails->search(),
        'filter' => $grndetails,
        'columns' => array(
            //'id',
            array(
                'header' => 'No.',
                'value' => '$this->grid->dataProvider->pagination->currentPage * $this->grid->dataProvider->pagination->pageSize + ($row+1)',
            ),
            array(
                'name' => 'productLine.pdlimage1',
                'type' => 'raw',
                'value' => '(!empty($data->productLine) ? CHtml::image($data->productLine->getImg(), "", array("width" => 100)) : "")',
            ),
            'productLine.pdlpdl',
            //'pdlprdsno',
            'productLine.pdlprdline',
            //'pdlprinted',
            //'pdlcustomyn',
            'productLine.pdldes',
            'qty',
            array(
                'name'=>'cost',
                'value'=>'number_format($data->cost,2)'
            ),
            array(
                'class' => 'CButtonColumn',
                'template' => '{delete}',
                'buttons' => array(
                    'delete' => array
                        (
                        'label' => 'Delete',
                        'imageUrl' => false,
                    ),
                ),
            ),
        ),
    ));
    ?>

    
</div>
    <div class="clear"></div>
    <div class="row buttons">
        <?php echo CHtml::submitButton('Create GRN'); ?>
    </div>
    <div class="clear"></div>

    <?php $this->endWidget(); ?>
    </div>