<?php
Yii::app()->clientScript->registerScript('search', "

$('.search-form form').submit(function(){
	$.fn.yiiGridView.update('gws-product-api-grid', {
		data: $(this).serialize()
	});
	return false;
});
");
?>
<div class="search-form">
    <div class="form">
        <?php
        $form = $this->beginWidget('CActiveForm', array(
            'action' => Yii::app()->createUrl($this->route),
            'method' => 'get',
        ));
        ?>

        <p class="note">Fields with <span class="required">*</span> are required.</p>

        <div class="row">
            <?php echo $form->labelEx($apiFilter, 'supplier'); ?>
            <?php echo $form->textField($apiFilter, 'supplier'); ?>
            <?php echo $form->error($apiFilter, 'supplier'); ?>
        </div>

        <div class="row">
            <?php echo $form->labelEx($apiFilter, 'product_code'); ?>
            <?php echo $form->textField($apiFilter, 'product_code'); ?>
            <?php echo $form->error($apiFilter, 'product_code'); ?>
        </div>
        <div class="row">
            <?php echo $form->labelEx($apiFilter, 'product_Name'); ?>
            <?php echo $form->textField($apiFilter, 'product_Name'); ?>
            <?php echo $form->error($apiFilter, 'product_Name'); ?>
        </div>
        <div class="row">
            <?php echo $form->labelEx($apiFilter, 'category'); ?>
            <?php echo $form->textField($apiFilter, 'category'); ?>
            <?php echo $form->error($apiFilter, 'category'); ?>
        </div>
        <div class="clear"></div> 
        <div class="row buttons">
            <?php echo CHtml::submitButton('Search'); ?>
        </div>
        <div class="clear"></div> 
        <?php $this->endWidget(); ?>
    </div><!-- form -->
</div>
<?php
$this->widget('zii.widgets.grid.CGridView', array(
    'id' => 'gws-product-api-grid',
    'dataProvider' => $dataProvider,
    'filter' => null,
    'columns' => array(
        array(
            'class' => 'CCheckBoxColumn',
        ),
        array(
            'header' => '',
            'value' => 'GwsProductApi::getImage($data)',
            'htmlOptions' => array("style" => "min-height:150px;"),
            'type' => 'html'
        ),
        array(
            'header' => 'Item Description',
            'value' => '"Item # : ". $data["pro_code"] . "<br>Name : ". $data["pro_name"] . "<br>Desc : " .  $data["long_desc"] . "<br>" . GwsProductApi::extractPriceBreaksIntoTable($data)',
            'type' => 'html'
        ),
        'supplier',
        'supplier_name',
        'umo',
        'srp',
        'min_qty'
    ),
));
?>

