
<h1>Manage GWS API Products</h1>
<div class="form">
    <?php
    $form = $this->beginWidget('CActiveForm', array(
        'id' => 'api-filter-form',
        'enableClientValidation' => true,
        'clientOptions' => array(
            'validateOnSubmit' => true,
        ),
    ));
    ?>

    <p class="note">Fields with <span class="required">*</span> are required.</p>

    <div class="row">
        <?php echo $form->labelEx($apiFilter, 'supplier'); ?>
         <?php echo $form->dropDownList($apiFilter, 'supplier', CHtml::listData(Supplier::model()->findAll(array('order' => 'supnam ASC')), 'supsup_fref', 'supnam'), array('empty' => '')); ?>
        <?php echo $form->error($apiFilter, 'supplier'); ?>
    </div>

    <div class="row">
        <?php echo $form->labelEx($apiFilter, 'product_code'); ?>
        <?php echo $form->textField($apiFilter, 'product_code'); ?>
        <?php echo $form->error($apiFilter, 'product_code'); ?>
    </div>
    <div class="row">
        <?php echo $form->labelEx($apiFilter, 'product_Name'); ?>
        <?php echo $form->textField($apiFilter, 'product_Name'); ?>
        <?php echo $form->error($apiFilter, 'product_Name'); ?>
    </div>
    <div class="row">
        <?php echo $form->labelEx($apiFilter, 'category'); ?>
        <?php echo $form->textField($apiFilter, 'category'); ?>
        <?php echo $form->error($apiFilter, 'category'); ?>
    </div>
    <div class="clear"></div> 
    <div class="row buttons">
        <?php echo CHtml::submitButton('Search', array('name' => 'api-search')); ?>
        <?php echo CHtml::submitButton('Clear', array('name' => 'api-clear-form')); ?>
    </div>
       
    <?php $this->endWidget(); ?>
</div><!-- form -->

<?php
$this->widget('zii.widgets.grid.CGridView', array(
    'id' => 'decoration-grid',
    'dataProvider' => $dataProvider,
    'filter' => null,
    'columns' => array(        
        array(
            'header' => '',
            'value' => 'GwsProductApi::getImage($data)',
            'htmlOptions' => array("style"=>"min-height:150px;"),
            'type' => 'html'
        ),
        array(
            'header' => 'Item Description',
             'value' =>  '"Item # : ". $data["pro_code"] . "<br>Name : ". $data["pro_name"] . "<br>Desc : " .  $data["long_desc"] . "<br>" . GwsProductApi::extractPriceBreaksIntoTable($data)',
            'type' => 'html'
        ),        
        'supplier',
        'supplier_name',
        'umo',
        'srp',
        'min_qty',        
        //'pro_code',
       // 'pro_name',
        //'short_desc',
       // 'long_desc' // 
    ),
));
?>

