<div class="form">

    <?php
    $form = $this->beginWidget('CActiveForm', array(
        'id' => 'internal-jobs-form',
        'htmlOptions' => array('enctype' => 'multipart/form-data'),
        'enableAjaxValidation' => false,
    ));
    ?>

    <p class="note">Fields with <span class="required">*</span> are required.</p>

<?php echo $form->errorSummary($model); ?>





    <div class="row">
        <?php echo $form->labelEx($model, 'image'); ?>
<?php echo CHtml::activeFileField($model, 'image'); ?>
<?php echo $form->error($model, 'image'); ?>
    </div>

    <div class="row">
        <?php echo $form->labelEx($model, 'notation'); ?>
<?php echo $form->textarea($model, 'notation', array('size' => 60, 'maxlength' => 255, 'style' => 'width:350px;', 'rows' => 5)); ?>
<?php echo $form->error($model, 'notation'); ?>
    </div>

    <div class="row">
        <?php echo $form->labelEx($model, 'followupDate'); ?>
        <?php
        $todayDate = date(GlobalVars::get("DateFormat")); // current date
        $currentTime = time($todayDate) + 60 * 60 * 11 + 30 * 60; //Change date into time
        $currentTime = date(GlobalVars::get("DateFormat"), $currentTime);
        
        Yii::import('application.extensions.CJuiDateTimePicker.CJuiDateTimePicker');
        $this->widget('CJuiDateTimePicker', array(
            'model' => $model, //Model object
            'attribute' => 'followupDate', //attribute name
            'mode' => 'date', //use "time","date" or "datetime" (default)
            'options' => array("dateFormat" => 'dd-mm-yy', "changeMonth" => 'true', 'changeYear' => 'true', 'minDate' => $currentTime,), // jquery plugin options
            'language' => 'en-GB'
        ));
        ?>
            <?php echo $form->error($model, 'followupDate'); ?>
    </div>

    <div class="row">
        <?php echo $form->labelEx($model, 'dueDate'); ?>
        <?php
        $todayDate = date("d-m-Y g:i a"); // current date
        $currentTime = time($todayDate) + 60 * 60 * 11 + 30 * 60; //Change date into time
        $currentTime = date('d-m-Y', $currentTime);
        
        Yii::import('application.extensions.CJuiDateTimePicker.CJuiDateTimePicker');
        $this->widget('CJuiDateTimePicker', array(
            'model' => $model, //Model object
            'attribute' => 'dueDate', //attribute name
            'mode' => 'date', //use "time","date" or "datetime" (default)
            'options' => array("dateFormat" => 'dd-mm-yy', "changeMonth" => 'true', 'changeYear' => 'true', 'minDate' => $currentTime,), // jquery plugin options
            'language' => 'en-GB'
        ));
        ?>
        <?php echo $form->error($model, 'dueDate'); ?>
    </div>

    

    
</div><!-- form -->
<div class="clear"></div>
<div class="view">
    <?php

$this->widget('zii.widgets.grid.CGridView', array(
    'id' => 'sales-order-decoration-grid',
    'dataProvider' => $dataProvider,    
    'filter' => null,
    'columns' => array(
        
        'id',
        array(
                'name'=>'id',
                'value'=>'CHtml::textField("JobDecorations[ids][$data->id]",$data->id)',
                'type'=>'raw',
                'headerHtmlOptions' => array('style' => 'display:none'),
                'htmlOptions' => array('style' => 'display:none'),
            ),
        array(
            'name' => 'workorderDtl.image',
            'type' => 'raw',
            'value' => 'CHtml::image($data->workorderDtl->getImg())',
            'htmlOptions' => array('style' => 'width:100px;'),
        ),
        
        array(
            'name' => 'workorderDtl.prdlngdesc',
            'type' => 'raw',
            'htmlOptions' => array('style' => 'width:200px;'),
            'value' => '(!empty($data->workorderDtl->productsku) ? $data->workorderDtl->prdsrtdesc . $data->workorderDtl->getProdSupplierLink() : $data->workorderDtl->custmproduct . $data->workorderDtl->getProdSupplierLink()) . $data->workorderDtl->prdlngdesc . $data->workorderDtl->getSizeQtyColorTable() ',
        ),
        array(
            'name' => 'workorderDtl.decprtnam',
            'type' => 'raw',
            'htmlOptions' => array('style' => 'width:150px;'),
            'value' => '!empty($data->workorderDtl->decprtnam) ? $data->workorderDtl->decdesc . $data->workorderDtl->getCustomizationDetail() . $data->workorderDtl->getDecoSupplierLink() : $data->workorderDtl->customdecoration . $data->workorderDtl->getCustomizationDetail() . $data->workorderDtl->getDecoSupplierLink()',
            'footer' => 'Total',
        ),
        array(
            'name' => 'decoQty',
            'htmlOptions' => array('style' => 'text-align:center'),
        ),
//         array(
//            'name' => 'supplier.supnam',
//            'type' => 'raw',
//            'value' => 'CHtml::link($data->supplier->supnam,array("supplier/view","id"=>$data->supplier->supsno))',
//            'htmlOptions' => array('style' => 'width:100px;'),
//        ),
        
    /*
      'prodQty',
      'decoQty',
      'customizationDetails',
      'notes',
      'extracomments',
      'sellPriceExVat',
      'sellPriceIncVat',
      'totExVat',
      'totIncVat',
      'image',
      'createdby',
      'createddate',
     */
    ),
));

?>
</div>
<div class="clear"></div>
<div >
<?php echo CHtml::submitButton('Create'); ?>
    </div>

<?php $this->endWidget(); ?>
