<?php
$this->breadcrumbs = array(
    'Internal Jobs' => array('index'),
    'Manage',
);

$jobmenu = null;

if(isset(Yii::app()->session['job'])){
    $job = Jobs::model()->findByPk(Yii::app()->session['job']);
    $jobmenu = array('label'=>'Back to : ' . $job->jobNum, 'url'=>array('jobs/view','id'=>$job->id));
}
$jobinfocusmenu = null;
if(isset(Yii::app()->session['job_in_focus_id'])){
    $jobinfocusmenu = array('label' => 'JOB IN FOCUS', 'url' => array('jobs/jobFlow'),'linkOptions'=>array('style'=>'background-color:orange;'));
}
$this->menu = array(
    $jobinfocusmenu,
    $jobmenu,
    //array('label'=>'List InternalJobs', 'url'=>array('index')),
    //array('label' => 'Create InternalJobs', 'url' => array('create')),
);

Yii::app()->clientScript->registerScript('search', "
$('.search-button').click(function(){
	$('.search-form').toggle();
	return false;
});
$('.search-form form').submit(function(){
	$.fn.yiiGridView.update('internal-jobs-grid', {
		data: $(this).serialize()
	});
	return false;
});
");
?>

<h1>Manage Internal Jobs</h1>

<p>
    You may optionally enter a comparison operator (<b>&lt;</b>, <b>&lt;=</b>, <b>&gt;</b>, <b>&gt;=</b>, <b>&lt;&gt;</b>
    or <b>=</b>) at the beginning of each of your search values to specify how the comparison should be done.
</p>

<?php echo CHtml::link('Advanced Search', '#', array('class' => 'search-button')); ?>
<div class="search-form" style="display:none">
    <?php
    $this->renderPartial('_search', array(
        'model' => $model,
    ));
    ?>
</div><!-- search-form -->

<?php
$this->widget('zii.widgets.grid.CGridView', array(
    'id' => 'internal-jobs-grid',
    'dataProvider' => $model->search(),
    'filter' => $model,
    'columns' => array(
        'id',
        array(
            'name' => 'job_id',            
            'value'=>'CHtml::link($data->job->jobNum,array("jobs/view","id"=>$data->job->id),array("target"=>"_blank"))',
            'type'=>'raw',
        ),
        'internaljobType',
        'notation',
        
        array(
            'name' => 'image',
            'type' => 'raw',
            'value' => 'CHtml::image("images/artwork/" . $data->image)',
            'htmlOptions' => array('style' => 'width:100px;'),
        ),
        
        array(
            'name' => 'followupDate',
            'value' => 'date(GlobalVars::get("DateFormat"),strtotime($data->followupDate))'
        ),
        array(
            'name' => 'dueDate',
            'value' => 'date(GlobalVars::get("DateFormat"),strtotime($data->dueDate))'
        ),
        array(
            'name' => 'status_id',
            'value' => 'Status::model()->findByPk($data->status_id)->name',
        ),
        /*
          'user_id',
         */
        array(
            'class' => 'CButtonColumn',
            'template' => '{view}{sep}{job_done}{sep3}{print}{sep4}{delete}',
            'buttons' => array(
                'view' => array(
                    'label' => 'View',
                    'imageUrl' => false,
                ),
                'sep' => array(
                    'label' => ' | ',
                    'imageUrl' => false,
                ),
                'job_done' => array(
                    'label' => 'Job Done',
                    'imageUrl' => false,
                    'url' => 'Yii::app()->createUrl("internalJobs/jobdone", array("id"=>$data->id))',
                    'visible'=>'in_array($data->status_id, array(1))',
                ),               
                'sep3' => array(
                    'label' => ' | ',
                    'imageUrl' => false,
                    'visible'=>'$data->purchaseEmbTape()',
                ),
                'print' => array(
                    'label' => 'Print',
                    'imageUrl' => false,
                    'url' => 'Yii::app()->createUrl("internalJobs/print", array("id"=>$data->id))',
                    'options' => array('target' => '_blank'),
                    
                ),
                'sep4' => array(
                    'label' => ' | ',
                    'imageUrl' => false,
                    
                ),
                'delete' => array(
                    'label' => 'Delete',
                    'imageUrl' => false,
                ),
            )
        ),
    ),
));
?>
