<?php
$this->breadcrumbs = array(
    'Internal Jobs' => array('index'),
    'Manage',
);

$jobmenu = null;

if(isset(Yii::app()->session['job'])){
    $job = Jobs::model()->findByPk(Yii::app()->session['job']);
    $jobmenu = array('label'=>'Back to : ' . $job->jobNum, 'url'=>array('jobs/view','id'=>$job->id));
}

$this->menu = array(
    $jobmenu,
    //array('label'=>'List InternalJobs', 'url'=>array('index')),
    //array('label' => 'Create InternalJobs', 'url' => array('create')),
);

Yii::app()->clientScript->registerScript('search', "
$('.search-button').click(function(){
	$('.search-form').toggle();
	return false;
});
$('.search-form form').submit(function(){
	$.fn.yiiGridView.update('internal-jobs-grid', {
		data: $(this).serialize()
	});
	return false;
});
");
?>

<h1>Manage Internal Jobs</h1>

<?php 
    $form = $this->beginWidget('CActiveForm', array(
        'id' => 'outstanding-form',
        'enableAjaxValidation' => false,
    ));
?>
<div class="form view">
    <!-- search on date between created date -->
    <div class="row">
        <label  for="createdDtm">Created Date From</label>
        <?php
        Yii::import('application.extensions.CJuiDateTimePicker.CJuiDateTimePicker');
        $this->widget('CJuiDateTimePicker', array(
            'model' => $model, //Model object
            'attribute' => 'createddatefrom', //attribute name
            'mode' => 'date', //use "time","date" or "datetime" (default)
            'options' => array("dateFormat" => 'dd-mm-yy', "changeMonth" => 'true', 'changeYear' => 'true',
//                             'minDate'=>$currentTime,
            ), // jquery plugin options
            'language' => 'en-GB'
        ));
        ?>
    </div>    
    <div class="row">
        <label  for="createdDtm">Created Date To</label>
        <?php
        
        $this->widget('CJuiDateTimePicker', array(
            'model' => $model, //Model object
            'attribute' => 'createddateto', //attribute name
            'mode' => 'date', //use "time","date" or "datetime" (default)
            'options' => array("dateFormat" => 'dd-mm-yy', "changeMonth" => 'true', 'changeYear' => 'true',
//                             'minDate'=>$currentTime,
            ), // jquery plugin options
            'language' => 'en-GB'
        ));
        ?>

    </div>
    <!-- end -->
    <!-- search on date between follow up dates -->
    <div class="row">
        <label  for="createdDtm">Follow-up Date From</label>
        <?php
        Yii::import('application.extensions.CJuiDateTimePicker.CJuiDateTimePicker');
        $this->widget('CJuiDateTimePicker', array(
            'model' => $model, //Model object
            'attribute' => 'followupdatefrom', //attribute name
            'mode' => 'date', //use "time","date" or "datetime" (default)
            'options' => array("dateFormat" => 'dd-mm-yy', "changeMonth" => 'true', 'changeYear' => 'true',
//                             'minDate'=>$currentTime,
            ), // jquery plugin options
            'language' => 'en-GB'
        ));
        ?>
    </div>    
    <div class="row">
        <label  for="createdDtm">Follow-up Date To</label>
        <?php
        
        $this->widget('CJuiDateTimePicker', array(
            'model' => $model, //Model object
            'attribute' => 'followupdateto', //attribute name
            'mode' => 'date', //use "time","date" or "datetime" (default)
            'options' => array("dateFormat" => 'dd-mm-yy', "changeMonth" => 'true', 'changeYear' => 'true',
//                             'minDate'=>$currentTime,
            ), // jquery plugin options
            'language' => 'en-GB'
        ));
        ?>

    </div>
    <!-- end -->
    <!-- search on date between expected date -->
    <div class="row">
        <label  for="createdDtm">Expected Date From</label>
        <?php
        Yii::import('application.extensions.CJuiDateTimePicker.CJuiDateTimePicker');
        $this->widget('CJuiDateTimePicker', array(
            'model' => $model, //Model object
            'attribute' => 'expecteddatefrom', //attribute name
            'mode' => 'date', //use "time","date" or "datetime" (default)
            'options' => array("dateFormat" => 'dd-mm-yy', "changeMonth" => 'true', 'changeYear' => 'true',
//                             'minDate'=>$currentTime,
            ), // jquery plugin options
            'language' => 'en-GB'
        ));
        ?>
    </div>    
    <div class="row">
        <label  for="createdDtm">Expected Date To</label>
        <?php
        
        $this->widget('CJuiDateTimePicker', array(
            'model' => $model, //Model object
            'attribute' => 'expecteddateto', //attribute name
            'mode' => 'date', //use "time","date" or "datetime" (default)
            'options' => array("dateFormat" => 'dd-mm-yy', "changeMonth" => 'true', 'changeYear' => 'true',
//                             'minDate'=>$currentTime,
            ), // jquery plugin options
            'language' => 'en-GB'
        ));
        ?>

    </div>
    <!-- end -->
    <div class="clear"></div>
    <div class="buttons row">
        <?php echo CHtml::submitButton('Reset'); ?><?php echo CHtml::submitButton('Go'); ?>
        <?php $this->endWidget(); ?>
    </div>
    <div style="float: right;">
        <?php echo CHtml::button('Print PDF',array('style'=>'float:right;','onclick'=>'generatePDF();')); ?>
        <?php echo CHtml::button('Generate Excel',array('style'=>'float:right;','onclick'=>'generateExcel();')); ?>
    
    </div>
     <div class="clear"></div>
</div>

<?php
$this->widget('zii.widgets.grid.CGridView', array(
    'id' => 'internal-jobs-grid',
    'dataProvider' => $model->searchpendingartwork(),
    'filter' => $model,
    'columns' => array(
        
        array(
            'name' => 'id',            
            'filter'=>false,
        ),
        array(
            'name' => 'createdDtm',
            'value' => 'date(GlobalVars::get("DateFormat"),strtotime($data->createdDtm))',
            'filter'=>false,
        ),
        array(
            'name' => 'job_id',
            'value' => '$data->job->jobNum',
            'filter'=>false,
        ),
//         array(
//            'name' => 'internaljobType',            
//            'filter'=>false,
//        ),
          array(
            'name' => 'notation',       
            'filter'=>false,
        ),
        
        
        array(
            'name' => 'image',
            'type' => 'raw',
            'value' => 'CHtml::image("images/artwork/" . $data->image)',
            'htmlOptions' => array('style' => 'width:100px;'),
            'filter'=>false,
        ),
        
        array(
            'name' => 'followupDate',
            'value' => 'date(GlobalVars::get("DateFormat"),strtotime($data->followupDate))',
            'filter'=>false,
        ),
        array(
            'name' => 'dueDate',
            'value' => 'date(GlobalVars::get("DateFormat"),strtotime($data->dueDate))',
            'filter'=>false,
        ),
        array(
            'name' => 'status_id',
            'value' => 'Status::model()->findByPk($data->status_id)->name',
            'filter'=>CHtml::listData(Status::model()->findAll(array('condition'=>"id IN (1,11)")), 'id', 'name'),
        ),
        /*
          'user_id',
         */
        
    ),
));
?>
