<?php
$this->breadcrumbs = array(
    'Internal Jobs' => array('index'),
    $model->id,
);





$jobinfocusmenu = null;
if(isset(Yii::app()->session['job_in_focus_id'])){
    $jobinfocusmenu = array('label' => 'JOB IN FOCUS', 'url' => array('jobs/jobFlow'),'linkOptions'=>array('style'=>'background-color:orange;'));
}
$this->menu = array(
    $jobinfocusmenu,
    array('label' => 'Back to : ' . $job->jobNum, 'url' => array('jobs/view', 'id' => $job->id)),
    //array('label'=>'List InternalJobs', 'url'=>array('index')),
    //array('label'=>'Create InternalJobs', 'url'=>array('create')),
    //array('label'=>'Update InternalJobs', 'url'=>array('update', 'id'=>$model->id)),
    array('label' => 'Delete Internal Jobs', 'url' => '#', 'linkOptions' => array('submit' => array('delete', 'id' => $model->id), 'confirm' => 'Are you sure you want to delete this item?')),
    array('label' => 'Manage Internal Jobs', 'url' => array('admin')),
);
?>

<h1>View Internal Jobs #<?php echo $model->id; ?></h1>
<?php
    foreach(Yii::app()->user->getFlashes() as $key => $message) {
        echo '<div class="flash-' . $key . '">' . $message . "</div>\n";
    }
?>
<?php
$this->widget('zii.widgets.CDetailView', array(
    'data' => $model,
    'attributes' => array(
        'id',
        'interjobnum',
        array(
            'name' => 'job.jobNum',
        ),
        'internaljobType',
        array(
            'name' => 'image',
            'value' => CHtml::image('images/artwork/' . $model->image, '', array('style' => 'width:100px;')),
            'type' => 'raw',
        ),
        'notation',
        array(
            'name'=>'followupDate',
            'value'=>date(GlobalVars::get("DateFormat"), strtotime($model->followupDate)),
            
        ),
        array(
            'name'=>'dueDate',
            'value'=>date(GlobalVars::get("DateFormat"), strtotime($model->dueDate)),
        ),
        
        array(
            'name' => 'status_id',
            'value' => Status::model()->findByPk($model->status_id)->name,
        ),
        array(
            'name' => 'user_id',
            'value' => User::model()->findByPk($model->user_id)->username,
        ),
    ),
));
?>
<div class="view">
    <br> <span style="font-size: 1em;font-weight: bold;">Sales Contacts & Activities</span>   
    <?php
    $salesLog = new SalesLog();
    $salesLog->quoteId = $model->job->workorder->quotationId;
    $salesLog->workorderId = $model->job->workorder->id;
    $salesLog->quoteNum = $model->job->workorder->quotationNumber;
    $salesLog->category = $model->interjobnum;

    $this->renderPartial('/salesLog/_crmgrid', array('salesLog' => $salesLog));
    ?>    


    <span style="font-size: 1em;font-weight: bold;">Add Sales Contact or Activity</span>  <br> 
    <div class="form">

        <?php
        $this->renderPartial('/salesLog/_crmform', array('salesLog' => $salesLog));
        ?>
    </div>
</div>
<div class="clear"></div>

<div class="view">
    <?php
    if ($model->internaljobType == 'Artwork') {


        $internaljobDetail = new InternalJobsDetails();
        $internaljobDetail->internalJob_id = $model->id;
        $dataprovider = $internaljobDetail->search();

        if($dataprovider->itemCount > 0){
        $this->widget('zii.widgets.grid.CGridView', array(
            'id' => 'internal-job-decoration-grid',
            'dataProvider' => $dataprovider,
            'filter' => null,
            'columns' => array(
                'id',
                array(
                    'name' => 'workorderDtl.image',
                    'type' => 'raw',
                    'value' => 'CHtml::image($data->workorderDtl->getImg())',
                    'htmlOptions' => array('style' => 'width:100px;'),
                ),
                array(
                    'name' => 'workorderDtl.prdlngdesc',
                    'type' => 'raw',
                    'htmlOptions' => array('style' => 'width:200px;'),
                    'value' => '(!empty($data->workorderDtl->productsku) ? $data->workorderDtl->prdsrtdesc . $data->workorderDtl->getProdSupplierLink() : $data->workorderDtl->custmproduct . $data->workorderDtl->getProdSupplierLink()) . $data->workorderDtl->prdlngdesc . $data->workorderDtl->getSizeQtyColorTable() ',
                ),
                array(
                    'name' => 'workorderDtl.decprtnam',
                    'type' => 'raw',
                    'htmlOptions' => array('style' => 'width:150px;'),
                    'value' => '!empty($data->getJobDecoration()->decprtnam) ? $data->getJobDecoration()->decdesc . $data->getJobDecoration()->getCustomizationDetail() . $data->getJobDecoration()->getDecoSupplierLink() : $data->getJobDecoration()->customdecoration . $data->getJobDecoration()->getCustomizationDetail() . $data->getJobDecoration()->getDecoSupplierLink()',
                    'footer' => 'Total',
                ),
                array(
                    'name' => 'workorderDtl.decoQty',
                    'htmlOptions' => array('style' => 'text-align:center'),
                ),
//         array(
//            'name' => 'supplier.supnam',
//            'type' => 'raw',
//            'value' => 'CHtml::link($data->supplier->supnam,array("supplier/view","id"=>$data->supplier->supsno))',
//            'htmlOptions' => array('style' => 'width:100px;'),
//        ),

            /*
              'prodQty',
              'decoQty',
              'customizationDetails',
              'notes',
              'extracomments',
              'sellPriceExVat',
              'sellPriceIncVat',
              'totExVat',
              'totIncVat',
              'image',
              'createdby',
              'createddate',
             */
            ),
        ));
        }
    }
    ?>
</div>
    <?php
    if (in_array($model->status_id, array(1)))
        echo CHtml::button('Job Done', array('submit' => array("internalJobs/jobdone", 'id' => $model->id)));
    //if ($model->purchaseEmbTape()) {
        //echo CHtml::button('Purchase Embroidery Tape', array('submit' => array("purchaseOrders/createEmbTapePO", 'id' => $model->id, "type" => "po_emb_tape")));
    //}
    ?>


<div >
<?php
echo CHtml::button('Print PDF', array('onclick' => "printPDF($model->id)", 'style' => 'float: right;'));
?>
</div>
<script>
    function printPDF(id) {
        var win = window.open('index.php?r=internalJobs/print&id=' + id);
    }
</script>