<div>
    <?php
    foreach (Yii::app()->user->getFlashes() as $key => $message) {
        echo '<div class="flash-' . $key . '">' . $message . "</div>\n";
    }
    ?>
</div>
<div class="view">
    <input type="hidden" id="inventoryId" value="<?php echo $model->id;?>" />
    <?php
    $this->widget('zii.widgets.CDetailView', array(
        'data' => $model,
        'attributes' => array(
            array(
                'name' => 'productLine.pdlimage1',
                'type' => 'raw',
                'value' => (!empty($model->productLine) ? CHtml::image($model->productLine->getImg(), "", array("width" => 100)) : ""),
            ),
            'productLine.pdlpdl',
            'productLine.pdlprdline',
            'productLine.pdldes',
            array(
                'name' => 'warehouseId',
                'value' => (!empty($model->warehouseRel) ? $model->warehouseRel->name : ""),
            ),
            array(
                'name' => 'productLine.customer',
                'value' => (!empty($model->productLine->customer) ? $model->productLine->customer->cusnam : ""),
            ),
            array(
                'name' => 'supplier_id',
                'value' => (!empty($model->supplier) ? $model->supplier->supnam : ""),
            ),
        ),
    ));
    ?>
</div>

<div class="clear"></div>


<div class="form">

    <?php
    $form = $this->beginWidget('CActiveForm', array(
        'id' => 'inventory-form',
        'enableAjaxValidation' => false,
    ));
    ?>

    <p class="note">Fields with <span class="required">*</span> are required.</p>

<?php echo $form->errorSummary($model); ?>


    <div class="row">
        <?php echo $form->labelEx($model, 'qty'); ?>
<?php echo $form->textField($model, 'qty'); ?>
<?php echo $form->error($model, 'qty'); ?>
    </div>		


    <div class="clear"></div>
    <div class="row buttons">
    <?php echo CHtml::submitButton($model->isNewRecord ? 'Create' : 'Save'); ?>
    </div>

<?php $this->endWidget(); ?>

</div><!-- form -->

<div class="clear"></div>  

<div class="view">
    <div style="float: left;">
        <h3>Sizes for the Product</h3>
    </div>
    <input type="button" value="Add Sizes" style="float:right;" onclick="showSizesModel();"/>
    <?php
    $inventorySizes = new InventorySizeQtyColor();
    $inventorySizes->inventory_id = $model->id;
    $inventorySizes->inventory_product_id = $model->productLine->pdlsno;
    $this->widget('zii.widgets.grid.CGridView', array(
        'id' => 'sizes-for-prod-grid',
        'dataProvider' => $inventorySizes->search(),
        'filter' => null,
        'columns' => array(
            //'id',
            array(
                'name' => 'product_size_id',
                'value' => 'ProductSize::model()->findByPk($data->product_size_id)->size_name'
            ),
            array(
                'name' => 'qty',
                'value' => 'CHtml::textField("qty[]",$data->qty,array("id"=>$data->id,"name"=>"qty","onchange"=>"updateQty(this.id,this.value);"))."<span style=\'color:green;font-weight:bold;display:none;\' id=\'qty_up_msg_".$data->id."\'>Updated</span>"',
                'type' => 'raw'
            ),
            array(
                'name' => 'color',
                'value' => 'CHtml::textField("color[]",$data->color,array("id"=>$data->id,"name"=>"color","onchange"=>"updateColor(this.id,this.value);"))."<span style=\'color:green;font-weight:bold;display:none;\' id=\'color_up_msg_".$data->id."\'>Updated</span>"',
                'type' => 'raw'
            ),
            array(
                'class' => 'CButtonColumn',
                'template' => '{delete}',
                'buttons' => array(
                    'delete' => array(
                        'label' => 'Delete',
                        'imageUrl' => false,
                        'url' => 'Yii::app()->createUrl("inventorySizeQtyColor/delete", array("id"=>$data->id))',
                        'click' => "function(){
                                            if(confirm('Are you sure you want to delete this item?')){
                                                 $.fn.yiiGridView.update('sizes-for-prod-grid', {  
                                                    type:'POST',
                                                    url:$(this).attr('href'),
                                                    data: {'id': $(this).attr('id')},
                                                    dataType: 'json',
                                                    success:function(result) {
                                                          $('#Inventory_qty').val(result.total_qty);
                                                          $.fn.yiiGridView.update('sizes-for-prod-grid'); 
                                                    }
                                                });
                                            }
                                            return false;
                                    }
                                    ",
                    ),
                )
            ),
        ),
    ));
    ?>

</div>
<!--end new product model-->
<div id="add-sizes-model" class="modal fade" role="dialog">
    <div class="modal-dialog">

        <!-- Modal content-->
        <div class="modal-content">
            <div class="modal-header">

                <h3 style="text-align: center;">Select Sizes</h3>
            </div>
            <div class="modal-body">
                <?php
                $prodBySize = new ProductBySize();
                $prodBySize->pdlsno = $model->productLine->pdlsno;
                $this->widget('zii.widgets.grid.CGridView', array(
                    'id' => 'product-sizes-grid',
                    'dataProvider' => $prodBySize->search(),
                    'filter' => null,
                    'selectableRows' => 100,
                    'columns' => array(
                        array(
                            'class' => 'CCheckBoxColumn',
                        ),
                        array(
                            'name' => 'product_size_id',
                            'value' => '$data->productSizeRel->size_name'
                        ),
                    ),
                ));
                ?>
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-default" data-dismiss="modal" onclick="addsizesfromgrid();">Add</button>
                <button type="button" class="btn btn-default" data-dismiss="modal">Close</button>
            </div>
        </div>

    </div>
</div>
<script>
    
    function addsizesfromgrid() {
        var values = new Array();
        $.each($("input[name='product-sizes-grid_c0[]']:checked"), function () {
            values.push($(this).val());
            // or you can do something to the actual checked checkboxes by working directly with  'this'
            // something like $(this).hide() (only something useful, probably) :P
        });

        if (values.length > 0) {
            var idarrstr = values + "";
            addProductSizes(idarrstr);
        }
    }
    
    function addProductSizes(sizesIds) {
        var inventoryId = $('#inventoryId').val();
        
        $.ajax({
            type: 'POST',
            url: '<?php echo Yii::app()->createUrl("inventory/addProductSizes"); ?>',
            data: {'inventoryId': inventoryId, 'sizesIds': sizesIds},
            dataType: 'json',
            success: function (result) {
                
                $.fn.yiiGridView.update("sizes-for-prod-grid");
                
            },
            error: function (result) {
                //('error in add products');
            }
        });
    }
    
    function showSizesModel() {
        $('#add-sizes-model').modal('show');
    }
    function updateQty(id, value) {
        $.ajax({
            type: 'POST',
            url: '<?php echo Yii::app()->createUrl("InventorySizeQtyColor/updateQuantity"); ?>',
            data: {'id': id, 'value': value},
            dataType: 'json',
            success: function (result) {
                $('#Inventory_qty').val(result.total_qty);
                $('#qty_up_msg_' + id).fadeIn(500).fadeOut(1500);
            },
            error: function (result) {
                //alert('error in update size order');
            }
        });
    }

    function updateColor(id, value) {
        $.ajax({
            type: 'POST',
            url: '<?php echo Yii::app()->createUrl("InventorySizeQtyColor/updateColor"); ?>',
            data: {'id': id, 'value': value},
            dataType: 'json',
            success: function (result) {
                $('#color_up_msg_' + id).fadeIn(500).fadeOut(1500);
            },
            error: function (result) {
                //alert('error in update size order');
            }
        });
    }
</script>