<?php
$this->breadcrumbs = array(
    'Inventories' => array('index'),
    'Manage',
);

$this->menu = array(
    array('label' => 'Create Warehouse', 'url' => array('warehouse/create')),
    array('label' => 'Allocate Items to Warehouses', 'url' => array('inventory/warehouseAllocate')),
);

Yii::app()->clientScript->registerScript('search', "
$('.search-button').click(function(){
	$('.search-form').toggle();
	return false;
});
$('.search-form form').submit(function(){
	$.fn.yiiGridView.update('inventory-grid', {
		data: $(this).serialize()
	});
	return false;
});
");
?>

<h1>Manage Inventory</h1>

<p>
    You may optionally enter a comparison operator (<b>&lt;</b>, <b>&lt;=</b>, <b>&gt;</b>, <b>&gt;=</b>, <b>&lt;&gt;</b>
    or <b>=</b>) at the beginning of each of your search values to specify how the comparison should be done.
</p>

<?php echo CHtml::link('Advanced Search', '#', array('class' => 'search-button')); ?>
<div class="search-form" style="display:none">
    <?php
    $this->renderPartial('_search', array(
        'model' => $model,
    ));
    ?>
</div><!-- search-form -->

<?php
$this->widget('zii.widgets.grid.CGridView', array(
    'id' => 'inventory-grid',
    'dataProvider' => $model->search(),
    'filter' => $model,
    'columns' => array(
        //'id',
        array(
            'name' => 'productLine.pdlimage1',
            'type' => 'raw',
            'value' => '(!empty($data->productLine) ? CHtml::image($data->productLine->getImg(), "", array("width" => 100)) : "")',
        ),
        array(
            'name' => 'productcode_search',
            'value' => '$data->productLine->pdlpdl',
        ),
        array(
            'name' => 'product_shortname_search',
            'value' => '$data->productLine->pdlprdline',
        ),
        array(
            'name' => 'product_description_search',
            'value' => '$data->productLine->pdldes',
        ),
        array(
            'name' => 'warehouse_search',
            'value' => '(!empty($data->warehouseRel) ? $data->warehouseRel->name : "")',
        ),
        array(
            'name' => 'customer_search',
            'value' => '(!empty($data->productLine->customer) ? $data->productLine->customer->cusnam : "")',
        ),
        array(
            'name' => 'supplier_search',
            'value' => '(!empty($data->supplier) ? $data->supplier->supnam : "")',
        ),
        'qty',
//                array(
//                    'name'=>'status',
//                    'value'=>'$data->status_->name'
//                ),
        //'cost_price',
        //'remarks',
        /*

          'po_id',
          'grn_id',
          'createdBy',
          'createdDate',
         */
        array(
            'class' => 'CButtonColumn',
            'template' => '{update}',
            'buttons' => array(
                'update' => array(
                    'label' => 'Update',
                    'imageUrl' => false,
                ),
            )
        ),
    ),
));
?>
