<?php
$this->breadcrumbs = array(
    'Product Lines' => array('index'),
    'Manage',
);

$this->menu = array(
    //array('label'=>'List ProductLine', 'url'=>array('index')),
    array('label' => 'Manage Inventory', 'url' => array('admin')),
);

Yii::app()->clientScript->registerScript('search', "
$('.search-button').click(function(){
	$('.search-form').toggle();
	return false;
});
$('.search-form form').submit(function(){
	$.fn.yiiGridView.update('product-line-grid', {
		data: $(this).serialize()
	});
	return false;
});
");
?>

<h1>Allocate Items to Warehouses</h1>
<div class="view">
    <div class="form">

        <?php
        $form = $this->beginWidget('CActiveForm', array(
            'id' => 'allocate-warehouse-for-products-form',
            'enableAjaxValidation' => false,
        ));


        $this->widget('zii.widgets.grid.CGridView', array(
            'id' => 'warehouse-grid',
            'dataProvider' => $warehouse->search(),
            'filter' => $warehouse,
            'columns' => array(
                array(
                    'class' => 'CCheckBoxColumn',
                ),
                'code',
                'name',
                array(
                    'name' => 'cussno',
                    'value' => '$data->customerRel->cusnam'
                ),
                
            ),
        ));
        ?>


        <div class="clear"></div>
<?php
$this->widget('zii.widgets.grid.CGridView', array(
    'id' => 'warehouse-allocate-inventory-grid',
    'dataProvider' => $model->warehouseSearch(),
    'filter' => $model,
    'selectableRows' => 10,
    'columns' => array(
        array(
            'class' => 'CCheckBoxColumn',
        ),
        array(
            'name' => 'productLine.pdlimage1',
            'type' => 'raw',
            'value' => '(!empty($data->productLine) ? CHtml::image($data->productLine->getImg(), "", array("width" => 100)) : "")',
        ),
        'productLine.pdlpdl',
        'productLine.pdlprdline',
        'productLine.pdldes',
                array(
                    'name' => 'productLine.warehouse',
                    'value' => '(!empty($data->productLine->warehouse) ? $data->productLine->warehouse->name : "")',
                ),
        array(
            'name' => 'productLine.customer',
            'value' => '(!empty($data->productLine->customer) ? $data->productLine->customer->cusnam : "")',
        ),
        array(
            'name' => 'supplier_id',
            'value' => '(!empty($data->supplier) ? $data->supplier->supnam : "")',
        ),
        'qty',
//                array(
//                    'name'=>'status',
//                    'value'=>'$data->status_->name'
//                ),
    //'cost_price',
    //'remarks',
    /*

      'po_id',
      'grn_id',
      'createdBy',
      'createdDate',
     */
//		array(
//			'class'=>'CButtonColumn',
//		),
    ),
));
?>

        <div class="row buttons">
            <?php echo CHtml::submitButton('Allocate', array('name' => 'btn_allocate_inventory')); ?>
        </div>

        <?php
        $this->endWidget();
        ?>
        <div class="clear"></div>
    </div>    
</div>
<div class="clear"></div>
<?php
if (!empty($branch->id)) {
    ?>

    <div class="view">
        <h3>Allocated Products</h3>
        <?php
        $allocatedInventory = new Inventory();
        $allocatedInventory->warehouseId = $branch->id;

        $this->widget('zii.widgets.grid.CGridView', array(
            'id' => 'warehouse-allocate-inventory-grid',
            'dataProvider' => $allocatedInventory->search(),
            'filter' => null,
            'columns' => array(
                //'id',
                array(
                    'name' => 'productLine.pdlimage1',
                    'type' => 'raw',
                    'value' => '(!empty($data->productLine) ? CHtml::image($data->productLine->getImg(), "", array("width" => 100)) : "")',
                ),
                'productLine.pdlpdl',
                'productLine.pdlprdline',
                'productLine.pdldes',
//                array(
//                    'name'=>'productLine.warehouse',
//                    'value'=>'(!empty($data->productLine->warehouse) ? $data->productLine->warehouse->name : "")',
//                ),
                array(
                    'name' => 'productLine.customer',
                    'value' => '(!empty($data->productLine->customer) ? $data->productLine->customer->cusnam : "")',
                ),
                array(
                    'name' => 'supplier_id',
                    'value' => '(!empty($data->supplier) ? $data->supplier->supnam : "")',
                ),
                'qty',
            ),
        ));
        ?>
    </div>

    <?php
}
?>