<?php
$this->breadcrumbs = array(
    'Inventory Art Works' => array('index'),
    'Manage',
);

$this->menu = array(
        //array('label'=>'List InventoryArtWork', 'url'=>array('index')),
        //array('label'=>'Create InventoryArtWork', 'url'=>array('create')),
);

Yii::app()->clientScript->registerScript('search', "
$('.search-button').click(function(){
	$('.search-form').toggle();
	return false;
});
$('.search-form form').submit(function(){
	$.fn.yiiGridView.update('inventory-art-work-grid', {
		data: $(this).serialize()
	});
	return false;
});
");
?>

<h1>Manage Inventory Artwork</h1>



<?php
$this->widget('zii.widgets.grid.CGridView', array(
    'id' => 'inventory-art-work-grid',
    'dataProvider' => $model->search(),
    'filter' => $model,
    'columns' => array(
        'id',
        array(
            'name' => 'image',
            'type' => 'raw',
            'value' => 'CHtml::image("images/artwork/" . $data->image)',
            'htmlOptions' => array('style' => 'width:100px;'),
            'filter' => false,
        ),   
        array(
            'name' => 'job_id',
            'value' => 'CHtml::link($data->job->jobNum,array("jobs/view","id"=>$data->job->id),array("target"=>"_blank"))',
            'type' => 'raw',
        ),
        
        array(
            'name' => 'po_id',
            'value' => '$data->getPurchaseOrderNumLink()',
            'type' => 'raw',
        ),
        array(
            'name' => 'grn_id',
            'value' => '$data->getGrnNumLink()',
            'type' => 'raw',
        ),
        
        
        
        array(
            'name' => 'createdDate',
            'value' => 'date(GlobalVars::get("DateFormat"),  strtotime($data->createdDate))',
            'filter' => false,
        ),
        array(
            'name' => 'user_id',
            'value' => 'User::model()->findByPk($data->user_id)->username',
            'filter' => false,
        ),
        /*
          'job_id',
          'wrkord_id',
          'internaljob_id',
          'po_id',
          'artworkcode',

          'image',
          'embrTapePo_id',
          'screenPrintPo_id',
          'embrTapeCode',
          'embrTapeJob_id',
          'isEmbrTapeAvl',
          'isScrnPrntAvl',
          'createdDate',
          'user_id',
         */
        array(
            'class' => 'CButtonColumn',
            'template' => '{view}',
            'buttons' => array(
                'view' => array(
                    'label' => 'View',
                    'imageUrl' => false,
                    'visible' => 'Yii::app()->user->checkAccess("InventoryArtWork.View")',
                ),
            )
        ),
    ),
));
?>
