<?php

require 'vendor/autoload.php';

//require_once('storage.php');
// Use this class to deserialize error caught
use XeroAPI\XeroPHP\AccountingObjectSerializer;

// Storage Classe uses sessions for storing token > extend to your DB of choice
$storage = new StorageClass();
$xeroTenantId = (string) $storage->getSession()['tenant_id'];

if ($storage->getHasExpired()) {
	$provider = new \League\OAuth2\Client\Provider\GenericProvider(XeroSetting::getGenericProviderOptions());

	$newAccessToken = $provider->getAccessToken('refresh_token', [
		'refresh_token' => $storage->getRefreshToken()
	]);

	// Save my token, expiration and refresh token
	$storage->setToken(
			$newAccessToken->getToken(), $newAccessToken->getExpires(), $xeroTenantId, $newAccessToken->getRefreshToken(), $newAccessToken->getValues()["id_token"]);
}

$config = XeroAPI\XeroPHP\Configuration::getDefaultConfiguration()->setAccessToken((string) $storage->getSession()['token']);
$config->setHost("https://api.xero.com/api.xro/2.0");

$apiInstance = new XeroAPI\XeroPHP\Api\AccountingApi(
		new GuzzleHttp\Client(), $config
);


try {
	$masterCustomer = $model->job->customer->master;

	if (!$masterCustomer) {
		$this->redirect(array('invoice/view', 'id' => $model->id, 'xrerr' => 'Cannot find the master customer!'));
	}

	if ($masterCustomer->xeroContactID) {
		$findContact = $apiInstance->getContact($xeroTenantId, $masterCustomer->xeroContactID);
	}


	if (!$masterCustomer->xeroContactID || !$findContact->getContacts()[0]) {
		$addresses = [];
		$address = new XeroAPI\XeroPHP\Models\Accounting\Address;
		$address->setAddressType('POBOX');
		$address->setAddressLine1($masterCustomer->mcusadd1);
		$address->setAddressLine2($masterCustomer->mcusadd2);
		$address->setAddressLine3($masterCustomer->mcusadd3);
		$address->setCity($masterCustomer->mcustown);
		$address->setRegion($masterCustomer->mcusstate);
		$address->setPostalCode($masterCustomer->mcuspostcode);

		array_push($addresses, $address);

		$phones = [];
		$phone = new XeroAPI\XeroPHP\Models\Accounting\Phone;
		$phone->setPhoneType('DEFAULT');
		$phone->setPhoneNumber($masterCustomer->mcustel);
		array_push($phones, $phone);

//		$phone2 = new XeroAPI\XeroPHP\Models\Accounting\Phone;
//		$phone2->setPhoneType('MOBILE');
//		$phone2->setPhoneNumber($masterCustomer->cusmobtel);
//
//		array_push($phones, $phone2);

		$phone3 = new XeroAPI\XeroPHP\Models\Accounting\Phone;
		$phone3->setPhoneType('FAX');
		$phone3->setPhoneNumber($masterCustomer->mcusfax);

		array_push($phones, $phone3);

		$contact = new XeroAPI\XeroPHP\Models\Accounting\Contact;
		$contact->setContactId($masterCustomer->xeroContactID);
		$contact->setName($masterCustomer->mcusnam);
		$contact->setAddresses($addresses);
		$contact->setEmailAddress($masterCustomer->mcusemail);
		$contact->setPhones($phones);
		$contact->setIsCustomer(true);
	} else {
		$contact = new XeroAPI\XeroPHP\Models\Accounting\Contact;
		$contact->setContactId($masterCustomer->xeroContactID);
	}




	$invoice = new XeroAPI\XeroPHP\Models\Accounting\Invoice;
	$invoice->setInvoiceNumber($model->invoiceNum);
	$invoice->setStatus('DRAFT');
	$reference = $model->job->customerpono ? ('PO : ' . $model->job->customerpono . ' ' . $model->job->jobNum) :  $model->job->jobNum; // PO : XXXXX JOB-000280-113
	$invoice->setReference($reference);
	$invoice->setType('ACCREC');
	$dateObj = new DateTime($model->createdDtm);
	$dateObj->format('Y-m-d');
	$invoice->setDate($dateObj);
	$dueDateObj = new DateTime($model->duedate);
	$dueDateObj->format('Y-m-d');
	$invoice->setDueDate($dueDateObj);
	$invoice->setLineAmountTypes('Exclusive');

	$invoice->setContact($contact);


	$lineItems = [];
	foreach ($modelDetial as $dtl) {
		$workorderdtl = $dtl->workorderdtl;
		$itmQty = $workorderdtl->prodQty;
		$accountCode = 200; //sales default
		if ($xeroAccount = XeroAccount::model()->findByPk($dtl->xero_account_id)) {
			$accountCode = $xeroAccount->code;
		}

		/* --------Product Item -------------- */
		$prodCostPrice = round($workorderdtl->prodCostPrice, 2);
		$prodMarkupRate = round($workorderdtl->prod_supmarg, 4);
		if (!$prodMarkupRate) {
			$prodMarkupRate = $workorderdtl->prodSupp->supmrate;
		}

		$prodMarkedUpPrice = $prodMarkupRate ? round(($prodCostPrice * $prodMarkupRate), 2) : $prodCostPrice;



		/* --------Product USD Freight -------------- */
		$usdFreight = $workorderdtl->prod_usd_freight;
		$usdFreightUnit = $usdFreight ? round($usdFreight / $itmQty, 2) : 0;
		$usdFreightPrice = $usdFreightUnit * $workorderdtl->productFrieghtMarkUpRate;







		/* Group USD price +  Product price */
		$groupProductPrice = $prodMarkedUpPrice + $usdFreightPrice;
		$groupProductPriceLineAmount = $groupProductPrice * $itmQty;
		$productLineItem = getLineItem(array(
			'description' => $workorderdtl->productsku . ' ' . $workorderdtl->prdsrtdesc,
			'quantity' => $itmQty,
			'unitAmount' => $groupProductPrice,
			'lineAmount' => $groupProductPriceLineAmount,
			'accountCode' => $accountCode,
		));

		array_push($lineItems, $productLineItem);




		/* -------- Product Decorations -------------- */
		$decoMaredUpPriceTotal = 0;
		$decoMaredUpPrice = 0;
		foreach ($workorderdtl->rel_multi_deco() as $data) {
			/* -------- decoration item -------------- */
			$decoPrice = ($data->cost_price ? ($data->cost_price * $data->sup_margin) : $data->cost_price);
			$logoSetupPrice = $data->logo_setup_unit_markedup_price;

			if ($queryParams['show_decoration']) {

				$decoCalArr = $data->getDecorationCalculations(
						array(
							'cost_price' => $data->cost_price,
							'sup_margin' => $data->sup_margin,
							'logo_setup' => $data->logo_setup,
							'quantity' => $data->quantity,
							'logo_setup_markup_rate' => $data->logo_setup_markup_rate,
				));

				$decoLineItem = getLineItem(array(
					'description' => $workorderdtl->productsku . ' ' . $data->decprtnam,
					'quantity' => $itmQty,
					'unitAmount' => $decoPrice,
					'lineAmount' => $decoPrice * $itmQty,
					'accountCode' => $accountCode,
				));

				array_push($lineItems, $decoLineItem);
				/* -------- logo setup charge -------------- */

				$logoSetupLineItem = getLineItem(array(
					'description' => $workorderdtl->productsku . ' ' . $data->decprtnam . ' Logo Setup',
					'quantity' => $itmQty,
					'unitAmount' => $logoSetupPrice,
					'lineAmount' => $logoSetupPrice * $itmQty,
					'accountCode' => $accountCode,
				));

				array_push($lineItems, $logoSetupLineItem);
			}



			$decoMaredUpPrice += $decoPrice + $logoSetupPrice;
			$decoMaredUpPriceTotal += ($decoPrice + $logoSetupPrice) * $itmQty;
		}

		if (!$queryParams['show_decoration']) {
			$decoLineItem = getLineItem(array(
				'description' => 'Decoration',
				'quantity' => $itmQty,
				'unitAmount' => $decoMaredUpPrice,
				'lineAmount' => $decoMaredUpPriceTotal,
				'accountCode' => $accountCode,
			));
			array_push($lineItems, $decoLineItem);
		}

		/* -------- Product Other Cost -------------- */

		$otherCostPriceTotal = ($workorderdtl->other_cost_markup_rate ? ($workorderdtl->other_cost * $workorderdtl->other_cost_markup_rate) : $workorderdtl->other_cost);

		foreach ($workorderdtl->rel_other_costs() as $othercost) {
			$otherCostType = OtherCostType::model()->findByPk($othercost->other_cost_id);
			$unit_cost = $othercost->cost;
			if ($otherCostType->devide_by_qty) {
				$unit_cost = $othercost->cost / $itmQty;
			}
			$otherCostWithMarkup = ($workorderdtl->other_cost_markup_rate ? ($unit_cost * $workorderdtl->other_cost_markup_rate) : $unit_cost);
			$otherCostLineItem = getLineItem(array(
				'description' => $otherCostType->name,
				'quantity' => $itmQty,
				'unitAmount' => $otherCostWithMarkup,
				'lineAmount' => ($otherCostWithMarkup * $itmQty),
				'accountCode' => $accountCode,
			));

			array_push($lineItems, $otherCostLineItem);
		}
	}


	$invoice->setLineItems($lineItems);

	//find the invoice
	$findInvoiceResponse = $apiInstance->getInvoices($xeroTenantId, null, null, null, [$model->xero_invoice_id], [$model->invoiceNum], null, ["DRAFT", "SUBMITTED"], null, null, null, null);



	if (count($findInvoiceResponse->getInvoices()) > 0) {
		$xeroInvoiceId = $findInvoiceResponse->getInvoices()[0]->getInvoiceId();
		$xero_status =  $findInvoiceResponse->getInvoices()[0]->getStatus();
		$invoice->setStatus($xero_status);
		
		$apiResponse = $apiInstance->updateInvoice($xeroTenantId, $xeroInvoiceId, $invoice);
		$model->xero_invoice_id = $xeroInvoiceId;
		if ($model->save(false)) {
			$this->redirect(array('invoice/view', 'id' => $model->id, 'xr' => 1));
		}
	} else {

		$apiResponse = $apiInstance->createInvoice($xeroTenantId, $invoice);
		$model->xero_invoice_id = $apiResponse->getInvoices()[0]->getInvoiceId();
		if ($model->save(false)) {
			$this->redirect(array('invoice/view', 'id' => $model->id, 'xr' => 1));
		}
	}

	//print_r($invoice);	exit();
	//echo 'Message: ' . $apiResponse->getInvoices()[0]->getInvoiceId();
} catch (\XeroAPI\XeroPHP\ApiException $e) {
	$error = AccountingObjectSerializer::deserialize(
					$e->getResponseBody(), '\XeroAPI\XeroPHP\Models\Accounting\Error', []
	);
	$message = "ApiException - " . $error->getElements()[0]["validation_errors"][0]["message"];
	//print_r($error->getElements()[0]["validation_errors"]);
	$this->redirect(array('invoice/view', 'id' => $model->id, 'xrerr' => $message));
}

function getLineItem($data = array())
{
	$lineItem = new XeroAPI\XeroPHP\Models\Accounting\LineItem;
	$lineItem->setDescription($data['description']);
	$lineItem->setQuantity($data['quantity']);
	$lineItem->setUnitAmount($data['unitAmount']);
	$lineItem->setLineAmount($data['lineAmount']);
	$lineItem->setAccountCode($data['accountCode']);



	return $lineItem;
}

function getMarginOutOfMarkupMultiplier($rate)
{
	if (!$rate || $rate === 0) {
		return 0;
	}

	$markup_decimal_value = $rate;
	$hold_value = $markup_decimal_value * 100;
	$hold_value2 = $hold_value - 100;
	if (floatval($markup_decimal_value) != 0.0) {
		$new_margin_percentate = ($hold_value2 / $markup_decimal_value);
	} else {
		$new_margin_percentate = $hold_value2;
	}


	return intval($new_margin_percentate);
}
