<?php
$this->breadcrumbs = array(
    'Invoices' => array('index'),
    'Manage',
);
$jobinfocusmenu = null;
$createinvoicemenu = null;
if (isset(Yii::app()->session['job_in_focus_id'])) {
    $jobinfocusmenu = array('label' => 'JOB IN FOCUS', 'url' => array('jobs/jobFlow'), 'linkOptions' => array('style' => 'background-color:orange;'));
    $createinvoicemenu = array('label' => 'Create Invoice', 'url' => array('invoice/create', 'id' => Yii::app()->session['job_in_focus_id']));
}

$refreshMyobMenu = null;
$auth = new MYOBAuth(MyobSetting::getSettings());
if ($auth->checkAccess()) {
	$refreshMyobMenu = array(
		'label' => 'Synchronize MYOB Invoices',
		'url' => array('#'),
		'linkOptions' => array(
			'onclick' => 'myobSynchronizeAll(this);return false;',
			'data-loading-text' => "MYOB Invoices Synchronizing...",
			'data-done-text' => "MYOB Invoices Synchronized!",
			'data-error-text' => "MYOB Synchronizing Error!",
			'style' => 'background-color:#32cd32')
	);
}

$this->menu = array(
    $jobinfocusmenu,
	$refreshMyobMenu,
    $createinvoicemenu,
    //array('label' => 'Xero Update', 'url' => array('invoice/xeroUpdate')),
);

Yii::app()->clientScript->registerScript('search', "
$('.search-button').click(function(){
	$('.search-form').toggle();
	return false;
});
$('.search-form form').submit(function(){
	$.fn.yiiGridView.update('invoice-grid', {
		data: $(this).serialize()
	});
	return false;
});
");
?>
<?php
foreach (Yii::app()->user->getFlashes() as $key => $message) {
    echo '<div class="flash-' . $key . '">' . $message . "</div>\n";
}
?>
<h1>Manage Invoices</h1>

<p>
    You may optionally enter a comparison operator (<b>&lt;</b>, <b>&lt;=</b>, <b>&gt;</b>, <b>&gt;=</b>, <b>&lt;&gt;</b>
    or <b>=</b>) at the beginning of each of your search values to specify how the comparison should be done.
</p>

<?php echo CHtml::link('Advanced Search', '#', array('class' => 'search-button')); ?>
<div class="search-form" style="display:none">
<?php
$this->renderPartial('_search', array(
    'model' => $model,
));
?>
</div><!-- search-form -->

<?php
$this->widget('zii.widgets.grid.CGridView', array(
    'id' => 'invoice-grid',
    'dataProvider' => $model->search(),
    'filter' => $model,
    'columns' => array(
        //'id',
        array(
            'name' => 'duedate',
            'value' => '$data->getRefinedDueDate()'
        ),
       array(
            'name' => 'invoiceNum',
            'value' => '$data->getNumberHtml()',
            'type'=>'html',
        ),
        'quoteNum',
        array(
            'name' => 'job.jobNum',
            'value' => '$data->job->jobNum'
        ),
        array(
            'name' => 'customer.cusnam',
            'value' => '$data->job->customer->cusnam',
        ),
        'comments',
        array(
            'name' => 'amountExVat',
            'value' => 'number_format($data->amountExVat,3)',
            'htmlOptions' => array('style' => 'text-align:right'),
        ),
        array(
            'name' => 'amountIncVat',
            'value' => 'number_format($data->amountIncVat,3)',
            'htmlOptions' => array('style' => 'text-align:right'),
        ),
        array(
            'name'=>'status_id',
            'value'=>'($data->status_id > 0 ? Status::model()->findByPk($data->status_id)->name : "Not Set")',
            'filter'=>CHtml::listData(Status::model()->findAll(array('condition'=>"id IN (1,25,3)", 'order'=>'name asc')), 'id', 'name'),
        ),
        array(
            'name' => 'createdDtm',
            'value' => 'date(GlobalVars::get("DateFormat"),strtotime($data->createdDtm))'
        ),
        /*
          'createdDtm',
          'createdBy',
          
         */
        array(
            'class' => 'CButtonColumn',
            'template' => '{view}{sep1}{print}{sep2}{approve}{sep3}{delete}',
            'buttons' => array(
                'view' => array
                    (
                    'label' => 'View',
                    'imageUrl' => false,
                ),
                'sep1' => array
                    (
                    'label' => ' | ',
                    'url' => '',
                    'imageUrl' => false,
                ),
                'print' => array
                    (
                    'label' => 'Print',
                    'imageUrl' => false,
                    'url' => 'Yii::app()->createUrl("invoice/print", array("id"=>$data->id))',
                    'options' => array('target' => '_blank'),
                ),
                'sep2' => array
                    (
                    'label' => ' | ',
                    'url' => '',
                    'imageUrl' => false,
                    'visible'=>'$data->status_id == 1'
                ),
                'approve' => array
                    (
                    'label' => 'Approve',
                    'imageUrl' => false,
                    'url' => 'Yii::app()->createUrl("invoice/approve", array("id"=>$data->id))',
                    'visible'=>'$data->status_id == 1'
                ),
                'sep3' => array
                    (
                    'label' => ' | ',
                    'url' => '',
                    'imageUrl' => false,
                ),
                'delete' => array
                    (
                    'label' => 'Delete',
                    'imageUrl' => false,
                ),
            )
        ),
    ),
));
?>
<script type="text/javascript">


    function myobSynchronizeAll(e)
    {
        var $this = $(e);
        startMyobStreaming($this);       
        $this.button('loading');

        $.ajax({
            type: 'POST',
            url: '<?php echo Yii::app()->createUrl("invoice/MYOBSyncronizeAll"); ?>',
            data: {},
            dataType: 'json',
            success: function (result) {
                myobSynchronizeDone($this);
            },
            error: function (result) {
                //$this.button('done');
                 console.log(result);
            },

        });
    }

    function startMyobStreaming($this) { /* $this refer to trigered element */
        xhr = new XMLHttpRequest();
        xhr.open("GET", "<?php echo Yii::app()->createUrl("invoice/MYOBSyncronizeAll"); ?>", true);
        xhr.onprogress = function (e) {
			
            var str = e.currentTarget.responseText;
            var res = str.split("~");

            var num = [];
            $.each(res, function (index, value) {
                num.push(value.replace(/[^0-9\/]/g, ''));

            });

            var newArray = num.filter(function (v) {
                return v !== ''
            });

            console.log(num[num.length - 2]);
            
			
			$this.empty();
			$this.text('MYOB Syncronizing... ' + newArray[newArray.length - 1]);
            


        }
        xhr.onreadystatechange = function () {
            if (xhr.readyState == 4) { /* streaming DONE */
                myobSynchronizeDone($this);
            }
        }
        xhr.send();
    }

    function myobSynchronizeDone($this) {
        $this.button('done');
        $('#invoice-grid').yiiGridView('update');
    }
</script>



