<?php
$deliverydocketnavbtn = null;

if ($model->isDOCompleted() == true) {
    $deliverydocketnavbtn = array('label' => 'Manage DO', 'url' => array('deliveryDockets/admin', 'inv_id' => $model->id));
} else {
    $deliverydocketnavbtn = array('label' => 'Create DO', 'url' => array('deliveryDockets/create', 'inv_id' => $model->id));
}

$jobinfocusmenu = null;
if (isset(Yii::app()->session['job_in_focus_id'])) {
    $jobinfocusmenu = array('label' => 'JOB IN FOCUS', 'url' => array('jobs/jobFlow'), 'linkOptions' => array('style' => 'background-color:orange;'));
}

$myobSyncronizeMenu = null;
$auth = new MYOBAuth(MyobSetting::getSettings());
if ($auth->checkAccess()) {
    //$loadinghtml = '&nbsp;<img class="loading-myob" src="images/loading_bar.gif" style="width:60px;height:25px;display:none;">';
    $myobSyncronizeMenu = array(
        'label' => 'Synchronize MYOB',
        'url' => array('#'),
        'linkOptions' => array(
            'id' => $model->id,
            'onclick' => 'myobSynchronize(this);return false;',
            'data-loading-text' => "MYOB Synchronizing...",
            'data-done-text' => "MYOB Synchronized!",
            'data-error-text' => "MYOB Synchronizing Error!",
            'style' => 'background-color:#32cd32')
    );
}

$xeroQueueMenu = null;
$xeroLinkOfInvoice = null;

if (intval(SystemOptions::getOptions()->enbleXero)) {
    //check whethere the order is not uploaded successfully and is queued for revoke
    if ($model->xero_in_queue) {
        $xeroQueueMenu = array('label' => 'Revoke Xero Queue', 'url' => '#', 'linkOptions' => array('submit' => array('toggleXeroQueue', 'id' => $model->id), 'confirm' => 'Are you sure you want to revoke this item from the Xero queue?'));
    } 
    if (!$model->xero_in_queue) {
        $xeroQueueMenu = array('label' => 'Add Xero Queue', 'url' => '#', 'linkOptions' => array('submit' => array('toggleXeroQueue', 'id' => $model->id), 'confirm' => 'Are you sure you want to add this item to the Xero queue?'));
    } 
    
    if( $model->getXeroDeepLink()) {
        $xeroLinkOfInvoice = array('label' => 'Xero View', 'url' =>'#', 'linkOptions' =>array('link' => $model->getXeroDeepLink(), 'onclick' => 'xeroView(this);return false;', 'style' => 'background-color:#00a2d5;'));
    }
}

$this->menu = array(
    $jobinfocusmenu,
    //array('label'=>'List Invoice', 'url'=>array('index')),
    array('label' => 'Back to : ' . $model->job->jobNum, 'url' => array('jobs/view', 'id' => $model->job->id)),
    $xeroLinkOfInvoice,
    $xeroQueueMenu,
    $myobSyncronizeMenu,
    // array('label'=>'Make Payment', 'url'=>array('invoicepayment/create', 'id'=>$model->id)),
    $deliverydocketnavbtn,
    array('label' => 'Update Invoice', 'url' => array('update', 'id' => $model->id)),
    //array('label'=>'Delete Invoice', 'url'=>'#', 'linkOptions'=>array('submit'=>array('delete','id'=>$model->id),'confirm'=>'Are you sure you want to delete this item?')),
    array('label' => 'Manage Invoice', 'url' => array('admin')),
);
?>
<h1>View Invoice :  <?php echo $model->invoiceNum; ?> <?php echo $model->isDOCompleted(); ?></h1>

<div>
    <?php
    foreach (Yii::app()->user->getFlashes() as $key => $message) {
        echo '<div class="flash-' . $key . '">' . $message . "</div>\n";
    }
    ?>
</div>

<?php echo $model->getMYOBError(); ?>
<div class="view">


    <?php
    $this->widget('zii.widgets.CDetailView', array(
        'data' => $model,
        'attributes' => array(
            'id',
            array(
                'name' => 'quoteNum',
            ),
            array(
                'name' => 'job.jobNum',
                'value' => $model->job->jobNum,
            ),
            //'job_id',
            //'customer_id',
            array(
                'name' => 'job.workorder.quotation.customer.master.mcusnam',
                'value' => !empty($model->job) ? $model->job->getMasterCustomerLink() : '',
                'type' => 'raw',
            ),
            array(
                'name' => 'job.workorder.quotation.customer.cusnam',
                'value' => !empty($model->job) ? $model->job->getCustomerLink() : '',
                'type' => 'raw',
            ),
            'comments',
            array(
                'name' => 'amountExVat',
                'value' => number_format($model->getTotExVat(), 2),
            ),
            /*
            array(
                'name' => 'amountIncVat',
                'value' => number_format($model->getTotIncVat(), 2),
            ),
             * 
             */
            array(
                'name' => 'createdDtm',
                'value' => date(GlobalVars::get('DateFormat'), strtotime($model->createdDtm)),
            ),
            array(
                'name' => 'duedate',
                'value' => $model->getRefinedDueDate(),
            ),
            array(
                'name' => 'createdBy',
                'value' => User::model()->findByPk($model->createdBy)->username,
            ),
            array(
                'name' => 'status_id',
                'value' => Status::model()->findByPk($model->status_id)->name,
            ),
            array(
                'label' => 'MYOB',
                'value' => $model->getMYOBLabel(),
                'visible' => $model->getMYOBLabel(),
                'type' => 'raw',
            )
        ),
    ));
    ?>
</div>

<div class="view">
    <h3>Make Payments</h3>
    <?php
    $paymentmodel = new InvoicePayment();
    $paymentmodel->quote_id = $model->quote_id;
    $paymentmodel->workorder_id = $model->job->workorder_id;
    $paymentmodel->job_id = $model->job_id;
    $paymentmodel->invoice_id = $model->id;
    $this->renderPartial('/invoicePayment/_form', array('paymentmodel' => $paymentmodel));
    ?>
    <div class="view">
        <h3>All Payments</h3>
        <?php
        $this->renderPartial('/invoicePayment/_admin', array('paymentmodel' => $paymentmodel));
        ?>
    </div>
    <div  style="display: inline;float: right;">

        <?php
        if ($model->xero_status == 25 && $model->getPaymentCount() > 0)
            echo CHtml::button('Update Xero', array('id' => 'xero_pay_update', 'onclick' => "xeroPaymentUpdate($model->id)"));
        ?>

    </div>
    <div class="clear"></div>
</div>

<div class="view">
    <?php
    $roundingPrecision = (int) GlobalVars::get("RoundingPrecision");
    $subTotal = round(PriceCalculator::getSubTotal($model), $roundingPrecision);
    $subTotalWithSurcharge = $model->surcharge_rate ? ($subTotal * $model->surcharge_rate) : $subTotal;
    $surchargeAmount = $subTotalWithSurcharge - $subTotal;
    $gstTotal = round(PriceCalculator::getGSTTotal($model), $roundingPrecision);


    $formatSubTotal = number_format($subTotal, $roundingPrecision);
    $formatGSTTotal = number_format($gstTotal, $roundingPrecision);
    $formattTotal = number_format(($subTotalWithSurcharge + $gstTotal), $roundingPrecision);

    $surchargeType = $model->surcharge_id ? Surcharge::model()->findByPk($model->surcharge_id)->surcharge_type : '';
    ?>

    <!-- Nav tabs -->
    <ul class="nav nav-tabs" role="tablist" style="margin-top: 2%;">

        <li class="active"><a href="#default-sec" role="tab" data-toggle="tab" >Default</a></li>

        <li><a href="#seperate-detail-sec" role="tab" data-toggle="tab" >In Detail</a></li>

    </ul>
    <div class="tab-content">
        <div class="tab-pane active" id="default-sec" style="padding-top: 0;margin-top: 0;">
            <?php
            $this->widget('zii.widgets.grid.CGridView', array(
                'id' => 'invoice-details-grid',
                'dataProvider' => $invoiceDtlsDataProvider,
                'filter' => null,
                'columns' => array(
                    'id',
                    array(
                        'name' => 'workorderdtl.image',
                        'type' => 'raw',
                        'value' => 'CHtml::image($data->workorderdtl->getImg())',
                        'htmlOptions' => array('style' => 'width:100px;'),
                    ),
                    array(
                        'name' => 'workorderdtl.prdlngdesc',
                        'type' => 'raw',
                        'htmlOptions' => array('style' => 'width:200px;'),
                        'value' => '(!empty($data->workorderdtl->productsku) ? $data->workorderdtl->productsku . " <br> " . $data->workorderdtl->prdsrtdesc . $data->workorderdtl->getProdSupplierLink() : $data->workorderdtl->custmproduct . $data->workorderdtl->getProdSupplierLink()) . $data->workorderdtl->prdlngdesc . $data->workorderdtl->getSizeQtyColorTable() . $data->getOnFlagsLabelsHtml() ',
                    ),
                    array(
                        'name' => 'workorderdtl.decprtnam',
                        'type' => 'raw',
                        'htmlOptions' => array('style' => 'width:150px;'),
                        'value' => '$data->workorderdtl->getMultiDecoDetailsHtml()',
                    ),
                    array(
                        'name' => 'xero_account_id',
                        'value' => 'XeroAccount::model()->findByPk($data->xero_account_id)->code . " - " . XeroAccount::model()->findByPk($data->xero_account_id)->name',
                        'type' => 'html',
                        'htmlOptions' => array('style' => 'text-align:center'),
                        'visible' => (int) SystemOptions::getOptions()->enbleXero
                    ),
                    array(
                        'name' => 'qty',
                        'htmlOptions' => array('style' => 'text-align:center'),
                    ),
                    array(
                        'name' => 'systemTaxRateId',
                        'value' => '$data->systemTaxRateId ? SystemTaxCode::model()->findByPk($data->systemTaxRateId)->code : "GST"',
                        'htmlOptions' => array('style' => 'text-align:center'),
                    ),
                    array(
                        'name' => 'sellPriceExVat',
                        'value' => 'number_format($data->sellPriceExVat,' . $roundingPrecision . ')',
                        'htmlOptions' => array('style' => 'text-align:right;width:12%;'),
                        'footer' => '<div style="font-weight:bold;font-size:1.2em;text-align:right;width:100%;">Sub Total :</div>
                         <div style="font-weight:bold;font-size:1.2em;text-align:right;width:100%;">' . ($surchargeType ? $surchargeType . ':' : 'Surcharge:') . '</div>
						 <div style="font-weight:bold;font-size:1.2em;text-align:right;width:100%;">Sub + Surcharge:</div>
						 <div style="font-weight:bold;font-size:1.2em;text-align:right;width:100%;">GST :</div>
                         <div style="font-weight:bold;font-size:1.2em;text-align:right;width:100%;border-bottom:1px double #000;">Total :</div>
                         <div style="font-weight:bold;font-size:1.2em;text-align:right;width:100%;">Paid Amount :</div>
                          <div style="font-weight:bold;font-size:1.2em;text-align:right;width:100%;">Balance :</div>',
                    ),
                    array(
                        'name' => 'totExVat',
                        'value' => 'number_format($data->totExVat,' . $roundingPrecision . ')',
                        'htmlOptions' => array('style' => 'text-align:right;width:12%;'),
                        'footer' => '<div id="sub_ttl" style="font-weight:bold;font-size:1.2em;text-align:right;width:100%;">' . $formatSubTotal . '</div>
                         <div id="gst_ttl" style="font-weight:bold;font-size:1.2em;text-align:right;width:100%;">' . number_format($surchargeAmount, 2) . '</div>
						 <div id="gst_ttl" style="font-weight:bold;font-size:1.2em;text-align:right;width:100%;">' . number_format($subTotalWithSurcharge, 2) . '</div>
						 <div id="gst_ttl" style="font-weight:bold;font-size:1.2em;text-align:right;width:100%;">' . $formatGSTTotal . '</div>
                         <div id="ttl_amnt" style="font-weight:bold;font-size:1.2em;text-align:right;width:100%;border-bottom:1px double #000;">' . $formattTotal . '</div>
                         <div id="paid_amnt" style="font-weight:bold;font-size:1.2em;text-align:right;width:100%;">' . number_format($model->getPaidAmount(), $roundingPrecision) . '</div>
                         <div id="blnce_amnt" style="font-weight:bold;font-size:1.2em;text-align:right;width:100%;">' . number_format((round(($subTotalWithSurcharge + $gstTotal), $roundingPrecision) - $model->getPaidAmount()), $roundingPrecision) . '</div>',
                    ),
                    array(
                        'class' => 'CButtonColumn',
                        'template' => '{line_opt}',
                        'buttons' => array(
                            'line_opt' => array
                                (
                                'label' => 'Line Options',
                                'imageUrl' => false,
                                'click' => "function(link,success,data){
                                    var Url = link.currentTarget.href;
                                    var paramId = getUrlParameter(Url, 'id');
                                    console.log(paramId);
                                     showLineFlagSettings(paramId);
                                    return false;
                              }",
                                'url' => 'Yii::app()->createUrl("invoiceDetail/deleteed", array("id"=>$data->id))',
                ),
                        )
                    ),
                ),
            ));
            ?>
        </div>

        <div class="tab-pane" id="seperate-detail-sec" style="padding-top: 0;margin-top: 0;">
            <?php
            $this->widget('zii.widgets.grid.CGridView', array(
                'id' => 'post-grid',
                'dataProvider' => $model->arrayDataProvider(),
                'columns' => array(
                    array(
                        'header' => 'Description',
                        'value' => '$data["description"]',
                    ),
                    array(
                        'header' => 'Quantity',
                        'value' => '$data["quantity"]',
                        'htmlOptions' => array('style' => 'text-align:center;'),
                    ),
                    array(
                        'header' => 'Account Code',
                        'value' => '$data["accountCode"]',
                        'htmlOptions' => array('style' => 'text-align:center;'),
                    ),
                    array(
                        'header' => 'Unit Price (Ex GST)',
                        'value' => 'number_format($data["unitAmount"], 2)',
                        'htmlOptions' => array('style' => 'text-align:right;width:12%;'),
                        'footer' => '<div style="font-weight:bold;font-size:1.2em;text-align:right;width:100%;">Sub Total :</div>
                         <div style="font-weight:bold;font-size:1.2em;text-align:right;width:100%;">' . ($surchargeType ? $surchargeType . ':' : 'Surcharge:') . '</div>
						 <div style="font-weight:bold;font-size:1.2em;text-align:right;width:100%;">Sub + Surcharge:</div>
						 <div style="font-weight:bold;font-size:1.2em;text-align:right;width:100%;">GST :</div>
                         <div style="font-weight:bold;font-size:1.2em;text-align:right;width:100%;border-bottom:1px double #000;">Total :</div>
                         <div style="font-weight:bold;font-size:1.2em;text-align:right;width:100%;">Paid Amount :</div>
                          <div style="font-weight:bold;font-size:1.2em;text-align:right;width:100%;">Balance :</div>',
                    ),
                    array(
                        'name' => 'Line Amount (Ex GST)',
                        'value' => 'number_format($data["lineAmount"], 2)',
                        'htmlOptions' => array('style' => 'text-align:right;width:12%;'),
                        'footer' => '<div id="sub_ttl" style="font-weight:bold;font-size:1.2em;text-align:right;width:100%;">' . $formatSubTotal . '</div>
                         <div id="gst_ttl" style="font-weight:bold;font-size:1.2em;text-align:right;width:100%;">' . number_format($surchargeAmount, 2) . '</div>
						 <div id="gst_ttl" style="font-weight:bold;font-size:1.2em;text-align:right;width:100%;">' . number_format($subTotalWithSurcharge, 2) . '</div>
						 <div id="gst_ttl" style="font-weight:bold;font-size:1.2em;text-align:right;width:100%;">' . $formatGSTTotal . '</div>
                         <div id="ttl_amnt" style="font-weight:bold;font-size:1.2em;text-align:right;width:100%;border-bottom:1px double #000;">' . $formattTotal . '</div>
                         <div id="paid_amnt" style="font-weight:bold;font-size:1.2em;text-align:right;width:100%;">' . number_format($model->getPaidAmount(), $roundingPrecision) . '</div>
                         <div id="blnce_amnt" style="font-weight:bold;font-size:1.2em;text-align:right;width:100%;">' . number_format((round(($subTotalWithSurcharge + $gstTotal), $roundingPrecision) - $model->getPaidAmount()), $roundingPrecision) . '</div>',
                    ),
                ),
            ));
            ?>

        </div>
    </div>
    <div class="clear"></div>

</div>
<div id="specailcomntdiv" class="view">
    <?php
    echo CHtml::label('Special Comment', '');
    echo CHtml::activeTextArea($model, 'specialcmnt', array('rows' => 5, 'style' => 'width:98%;', 'invoice_id' => $model->id));
    ?>
</div>

<div style="float: right;display: inline;">
    <?php
    echo CHtml::checkBox('notes_flag', array(''), array('id' => 'notes_flag', 'style' => 'display: inline;'));
    ?>
    <label style="width:150px;display: inline;">
        <?php echo 'Show Notes in PDF'; ?> 
    </label>
</div>

<div style="float: right;display: inline;">
    <?php
    echo CHtml::checkBox('custmz_flag', array(''), array('id' => 'custmz_flag', 'style' => 'display: inline;'));
    ?>
    <label style="width:150px;display: inline;">
        <?php echo 'Show Customisation Details in PDF'; ?> 
    </label>
</div>

<div style="float: right;display: inline;">
    <?php
    echo CHtml::checkBox('price_flag', array(''), array('id' => 'price_flag', 'style' => 'display: inline;'));
    ?>
    <label style="width:150px;display: inline;">
        <?php echo 'Show Price in PDF'; ?> 
    </label>
</div>
<div style="float: right;display: inline;">
    <?php
    echo CHtml::checkBox('deco_flag', array(''), array('id' => 'deco_flag', 'style' => 'display: inline;'));
    ?>
    <label style="width:150px;display: inline;">
        <?php echo 'Show Decoration in PDF'; ?> 
    </label>
</div>
<div style="float: right;display: inline;">
    <?php
    echo CHtml::checkBox('lngdesc_flag', false, array('id' => 'lngdesc_flag', 'style' => 'display: inline;'));
    ?>
    <label style="width:150px;display: inline;">
        <?php echo 'Show Long Description in PDF'; ?> 
    </label>
</div>
<div style="float: right;display: inline;">
    <?php
    echo CHtml::checkBox('seperate_lines_flag', false, array('id' => 'seperate_lines_flag', 'style' => 'display: inline;'));
    ?>
    <label style="width:150px;display: inline;">
        <?php echo 'Show items as seperate lines'; ?> 
    </label>
</div>

<div class="clear"></div>
<div  style="display: inline;float: right;">
    <span id="resend_msg" style="color: #007700;font-weight: bold;">  </span>
    <?php
    if ((int) SystemOptions::getOptions()->enbleXero) {
        if (in_array($model->status_id, array(1, 25)) || $model->xero_status == 1) {
            echo CHtml::button('Update Xero', array('onclick' => "xeroUpdate($model->id)"));
        } else if ($model->status_id == 25 && $model->xero_status == 25 && $model->xero_makePayments <> 1) {
            echo CHtml::button('Update Xero', array('onclick' => "xeroUpdate($model->id)"));
        }
    }

//echo CHtml::button('Update Xero', array('onclick' => "xeroUpdate($model->id)"));
    echo CHtml::button('Resend PDF & CSV', array('onclick' => "resendPDFCSV($model->id)"));
    echo CHtml::button('Send Invoice', array('onclick' => "sendEmail($model->id,'Invoice')"));

//echo CHtml::button('Print Kulbardi PDF', array('onclick' => "printKulbardiPDF($model->id)", 'style' => 'background-color:#C45C1B;'));
    echo CHtml::button('Print PDF', array('onclick' => "printPDF($model->id)"));
    ?>
</div>
<script src="https://cdnjs.cloudflare.com/ajax/libs/bootbox.js/5.4.0/bootbox.min.js"></script>
<script>
    
    function xeroView(e) {        
        var win = window.open($(e).attr('link'));
    }

    var getUrlParameter = function getUrlParameter(Url, sParam) {
        var sPageURL = Url,
                sURLVariables = sPageURL.split('&'),
                sParameterName,
                i;

        for (i = 0; i < sURLVariables.length; i++) {
            sParameterName = sURLVariables[i].split('=');

            if (sParameterName[0] === sParam) {
                return sParameterName[1] === undefined ? true : decodeURIComponent(sParameterName[1]);
            }
        }
        return false;
    };

    function showLineFlagSettings(id) {
        $.ajax({
            type: 'POST',
            url: '<?php echo Yii::app()->createUrl("invoiceDetail/fetchDetailFlags"); ?>',
            data: {id: id},
            dataType: 'json',
            success: function (result) {


                var options = {};
                options.selected = result.flags;

                options.inputOptions = [
                    {
                        text: 'Hide on PDF',
                        value: 'hide_on_pdf',
                    },
                ];

                bootbox.prompt({
                    title: "Line Options",
                    value: options.selected,
                    inputType: 'checkbox',
                    inputOptions: options.inputOptions,
                    callback: function (result) {
                        if (result) {
                            var obj = {};
                            obj.id = id;
                            obj.flags = result;

                            //if no flag has been selected  then 'flags' array will be empty, so we need to add the flag attributes manually to the object to turn them off
                            if (!obj.flags.length) {
                                obj.offFlags = ['hide_on_pdf'];
                            }
                            updateLineOptionFlags(obj);
                        }
                    }
                });


            },
            error: function (result) {
                console.log(result);
            }
        });



    }

    function updateLineOptionFlags(obj) {

        $.ajax({
            type: 'POST',
            url: '<?php echo Yii::app()->createUrl("invoiceDetail/updateDetailFlags"); ?>',
            data: obj,
            dataType: 'json',
            success: function (result) {

                if (result.success) {
                   $.fn.yiiGridView.update('invoice-details-grid');
                }
            },
            error: function (result) {
                console.log(result);
            }
        });
    }


    

    function myobSynchronize(e)
    {
        var $this = $(e);
        $this.button('loading');
        $.ajax({
            type: 'POST',
            url: '<?php echo Yii::app()->createUrl("invoice/MYOBSyncronize"); ?>',
            data: {'id': $(e).attr('id')},
            dataType: 'json',
            success: function (result) {
                $this.button('done');
                location.reload(true);
            },
            error: function (result) {
                $this.button('error');
                location.reload(true);
            }
        });
    }

    $(document).on('keyup change paste', '#Invoice_specialcmnt', function () {
        saveSpecialComnt($(this).attr('invoice_id'));

    });

    function saveSpecialComnt(id) {
        var text = $('#Invoice_specialcmnt').val();



        $.ajax({
            type: 'POST',
            url: '<?php echo Yii::app()->createUrl("invoice/updatespecialcmnt"); ?>',
            data: {'id': id, 'text': text},
            dataType: 'json',
            success: function (result) {
                if (result.status === 'success') {
                    $('#specailcomntdiv').append("<span id='spstxtmsg' style='display:none;color:#007700;font-weight:bold;'>Text has been saved successfully.</span>");
                    $('#spstxtmsg').fadeIn(500).fadeOut(1500);
                }
            }
        });

    }

    function xeroUpdate(id) {

        var notes_show = $('#notes_flag').is(':checked');
        var cutmz_show = $('#custmz_flag').is(':checked');
        var price_show = $('#price_flag').is(':checked');
        var deco_show = $('#deco_flag').is(':checked');
        var lngdesc_show = $('#lngdesc_flag').is(':checked');
        var seperate_lines_show = $('#seperate_lines_flag').is(':checked');
        var win = window.open('index.php?r=invoice/xeroUpdate&id=' + id
                + '&price_show=' + price_show
                + '&deco_show=' + deco_show
                + '&cutmz_show=' + cutmz_show
                + '&notes_show=' + notes_show
                + '&lngdesc_show=' + lngdesc_show
                + '&seperate_lines_show=' + seperate_lines_show
                );
    }

    function xeroPaymentUpdate(id) {
        var win = window.open('index.php?r=invoicePayment/xeroUpdate&id=' + id);
    }

    function resendPDFCSV(id) {
        $('#resend_msg').css('color', '#007700');
        $('#resend_msg').empty();
        $('#resend_msg').html('Trying to resend files. Please wait...');
        $.ajax({
            type: 'POST',
            url: '<?php echo Yii::app()->createUrl("invoice/ajaxSendPDFCSV"); ?>',
            data: {'id': id},
            dataType: 'json',
            success: function (result) {
                //alert(result);
                if (result.status === 'success') {
                    $('#resend_msg').empty();
                    $('#resend_msg').html('PDF & CSV files are successfully resend to ' + result.recipient_email);
                } else {
                    $('#resend_msg').css('color', '#c67605');
                    $('#resend_msg').empty();
                    $('#resend_msg').html('Cannot resend the files. Please try again.');
                }
            },
            error: function (result) {
                $('#resend_msg').css('color', '#00ff00');
                $('#resend_msg').empty();
                $('#resend_msg').html('Error while sending the files.');
            },
        });
    }

    function printPDF(id) {
        var notes_show = $('#notes_flag').is(':checked');
        var cutmz_show = $('#custmz_flag').is(':checked');
        var price_show = $('#price_flag').is(':checked');
        var deco_show = $('#deco_flag').is(':checked');
        var lngdesc_show = $('#lngdesc_flag').is(':checked');
        var seperate_lines_show = $('#seperate_lines_flag').is(':checked');
        var win = window.open('index.php?r=invoice/print&id=' + id
                + '&price_show=' + price_show
                + '&deco_show=' + deco_show
                + '&cutmz_show=' + cutmz_show
                + '&notes_show=' + notes_show
                + '&lngdesc_show=' + lngdesc_show
                + '&seperate_lines_show=' + seperate_lines_show
                );

    }

    function printKulbardiPDF(id) {
        var notes_show = $('#notes_flag').is(':checked');
        var cutmz_show = $('#custmz_flag').is(':checked');
        var price_show = $('#price_flag').is(':checked');
        var deco_show = $('#deco_flag').is(':checked');
        var lngdesc_show = $('#lngdesc_flag').is(':checked');
        var win = window.open('index.php?r=invoice/print&id=' + id + '&price_show=' + price_show + '&deco_show='
                + deco_show + '&cutmz_show=' + cutmz_show + '&notes_show=' + notes_show + '&lngdesc_show=' + lngdesc_show + '&tempt=2');

    }

    function sendEmail(id, emailtype) {
        var notes_show = $('#notes_flag').is(':checked');
        var cutmz_show = $('#custmz_flag').is(':checked');
        var price_show = $('#price_flag').is(':checked');
        var deco_show = $('#deco_flag').is(':checked');
        var lngdesc_show = $('#lngdesc_flag').is(':checked');
        var win = window.open('index.php?r=emails/create&id=' + id + '&type=' + emailtype + '&price_show=' + price_show + '&deco_show=' + deco_show + '&cutmz_show=' + cutmz_show + '&notes_show=' + notes_show + '&lngdesc_show=' + lngdesc_show);
    }


    function updateInvoice(id) {

        $.ajax({
            type: 'POST',
            url: '<?php echo Yii::app()->createUrl("invoice/ajaxTotal"); ?>',
            data: {'id': id},
            dataType: 'json',
            success: function (result) {

                $('#sub_ttl').html(result.sub_total);
                $('#gst_ttl').html(result.gst_total);
                $('#ttl_amnt').html(result.total_amount);
                $('#paid_amnt').html(result.paid_amount);
                $('#blnce_amnt').html(result.balance_amount);
            },
            error: function (result) {

            },
        });
    }

    function deletepay(id) {
        $.ajax({
            type: 'POST',
            url: '<?php echo Yii::app()->createUrl("invoicePayment/deletePay"); ?>',
            data: {'id': id},
            dataType: 'json',
            success: function (result) {
                $.fn.yiiGridView.update("invoice-payment-grid");
                updateInvoice(result.invoice_id);
            },
            error: function (result) {

            },
        });
    }



</script>