<?php

require 'vendor/autoload.php';

//require_once('storage.php');
// Use this class to deserialize error caught
use XeroAPI\XeroPHP\AccountingObjectSerializer;

// Storage Classe uses sessions for storing token > extend to your DB of choice
$storage = new StorageClass();
$xeroTenantId = (string) $storage->getSession()['tenant_id'];

if ($storage->getHasExpired()) {
	$provider = new \League\OAuth2\Client\Provider\GenericProvider(XeroSetting::getGenericProviderOptions());

	$newAccessToken = $provider->getAccessToken('refresh_token', [
		'refresh_token' => $storage->getRefreshToken()
	]);

	// Save my token, expiration and refresh token
	$storage->setToken(
			$newAccessToken->getToken(), $newAccessToken->getExpires(), $xeroTenantId, $newAccessToken->getRefreshToken(), $newAccessToken->getValues()["id_token"]);
}

$config = XeroAPI\XeroPHP\Configuration::getDefaultConfiguration()->setAccessToken((string) $storage->getSession()['token']);
$config->setHost("https://api.xero.com/api.xro/2.0");

$apiInstance = new XeroAPI\XeroPHP\Api\AccountingApi(
		new GuzzleHttp\Client(), $config
);


try {
	$masterCustomer = $model->job->customer->master;

	if (!$masterCustomer) {
		$this->redirect(array('invoice/view', 'id' => $model->id, 'xrerr' => 'Cannot find the master customer!'));
	}

	if ($masterCustomer->xeroContactID) {
		$findContact = $apiInstance->getContact($xeroTenantId, $masterCustomer->xeroContactID);
	}


	if (!$masterCustomer->xeroContactID || !$findContact->getContacts()[0]) {
		$addresses = [];
		$address = new XeroAPI\XeroPHP\Models\Accounting\Address;
		$address->setAddressType('POBOX');
		$address->setAddressLine1($masterCustomer->mcusadd1);
		$address->setAddressLine2($masterCustomer->mcusadd2);
		$address->setAddressLine3($masterCustomer->mcusadd3);
		$address->setCity($masterCustomer->mcustown);
		$address->setRegion($masterCustomer->mcusstate);
		$address->setPostalCode($masterCustomer->mcuspostcode);

		array_push($addresses, $address);

		$phones = [];
		$phone = new XeroAPI\XeroPHP\Models\Accounting\Phone;
		$phone->setPhoneType('DEFAULT');
		$phone->setPhoneNumber($masterCustomer->mcustel);
		array_push($phones, $phone);

//		$phone2 = new XeroAPI\XeroPHP\Models\Accounting\Phone;
//		$phone2->setPhoneType('MOBILE');
//		$phone2->setPhoneNumber($masterCustomer->cusmobtel);
//
//		array_push($phones, $phone2);

		$phone3 = new XeroAPI\XeroPHP\Models\Accounting\Phone;
		$phone3->setPhoneType('FAX');
		$phone3->setPhoneNumber($masterCustomer->mcusfax);

		array_push($phones, $phone3);

		$contact = new XeroAPI\XeroPHP\Models\Accounting\Contact;
		$contact->setContactId($masterCustomer->xeroContactID);
		$contact->setName($masterCustomer->mcusnam);
		$contact->setAddresses($addresses);
		$contact->setEmailAddress($masterCustomer->mcusemail);
		$contact->setPhones($phones);
		$contact->setIsCustomer(true);
	} else {
		$contact = new XeroAPI\XeroPHP\Models\Accounting\Contact;
		$contact->setContactId($masterCustomer->xeroContactID);
	}




	$invoice = new XeroAPI\XeroPHP\Models\Accounting\Invoice;
	$invoice->setInvoiceNumber($model->invoiceNum);
	$invoice->setStatus('DRAFT');
	$invoice->setReference($model->job->jobNum);
	$invoice->setType('ACCREC');
	$dateObj = new DateTime($model->createdDtm);
	$dateObj->format('Y-m-d');
	$invoice->setDate($dateObj);
	$dueDateObj = new DateTime($model->duedate);
	$dueDateObj->format('Y-m-d');
	$invoice->setDueDate($dueDateObj);
	$invoice->setLineAmountTypes('Exclusive');

	$invoice->setContact($contact);


	$lineItems = [];
	foreach ($modelDetial as $dtl) {
		$workorderdtl = $dtl->workorderdtl;
		$itmQty = $workorderdtl->prodQty;
		$accountCode = 200; //sales default
		if ($xeroAccount = XeroAccount::model()->findByPk($dtl->xero_account_id)) {
			$accountCode = $xeroAccount->code;
		}

		/* --------Product Item -------------- */
		
		$decription = $workorderdtl->productsku . "\n" . $workorderdtl->prdsrtdesc . "\n" . $workorderdtl->getMultiDecoDetailsHtmlExLink();

		$productLineItem = getLineItem(array(
			'description' => $decription,
			'quantity' => $itmQty,
			'unitAmount' => $dtl->sellPriceExVat,
			'lineAmount' => ($dtl->sellPriceExVat * $itmQty),
			'accountCode' => $accountCode,
		));

		array_push($lineItems, $productLineItem);
	}





	$invoice->setLineItems($lineItems);

	//find the invoice
	$findInvoiceResponse = $apiInstance->getInvoices($xeroTenantId, null, null, null, [$model->xero_invoice_id], [$model->invoiceNum], null, ["DRAFT", "SUBMITTED"], null, null, null, null);



	if (count($findInvoiceResponse->getInvoices()) > 0) {
		$xeroInvoiceId = $findInvoiceResponse->getInvoices()[0]->getInvoiceId();
		$apiResponse = $apiInstance->updateInvoice($xeroTenantId, $xeroInvoiceId, $invoice);
		$model->xero_invoice_id = $xeroInvoiceId;
		if ($model->save(false)) {
			$this->redirect(array('invoice/view', 'id' => $model->id, 'xr' => 1));
		}
	} else {

		$apiResponse = $apiInstance->createInvoice($xeroTenantId, $invoice);
		$model->xero_invoice_id = $apiResponse->getInvoices()[0]->getInvoiceId();
		if ($model->save(false)) {
			$this->redirect(array('invoice/view', 'id' => $model->id, 'xr' => 1));
		}
	}

	//print_r($invoice);	exit();
	//echo 'Message: ' . $apiResponse->getInvoices()[0]->getInvoiceId();
} catch (\XeroAPI\XeroPHP\ApiException $e) {
	$error = AccountingObjectSerializer::deserialize(
					$e->getResponseBody(), '\XeroAPI\XeroPHP\Models\Accounting\Error', []
	);
	$message = "ApiException - " . $error->getElements()[0]["validation_errors"][0]["message"];
	//print_r($error->getElements()[0]["validation_errors"]);
	$this->redirect(array('invoice/view', 'id' => $model->id, 'xrerr' => $message));
}

function getLineItem($data = array())
{
	$lineItem = new XeroAPI\XeroPHP\Models\Accounting\LineItem;
	$lineItem->setDescription($data['description']);
	$lineItem->setQuantity($data['quantity']);
	$lineItem->setUnitAmount($data['unitAmount']);
	$lineItem->setLineAmount($data['lineAmount']);
	$lineItem->setAccountCode($data['accountCode']);



	return $lineItem;
}

function getMarginOutOfMarkupMultiplier($rate)
{
	if (!$rate || $rate === 0) {
		return 0;
	}

	$markup_decimal_value = $rate;
	$hold_value = $markup_decimal_value * 100;
	$hold_value2 = $hold_value - 100;
	if (floatval($markup_decimal_value) != 0.0) {
		$new_margin_percentate = ($hold_value2 / $markup_decimal_value);
	} else {
		$new_margin_percentate = $hold_value2;
	}


	return intval($new_margin_percentate);
}
