<?php

/**
 * each invoice raw will be sent as separate fields
 * i.e.
 * line 1 - item --- qty * price
 * line 2 - USD freight --- qty * price
 * line 3 - decoration --- qty * price
 * line 4 - logo setup charge  --- qty * price
 * line 5 - another decoration --- qty * price
 * line 6 - logo setup charge  --- qty * price
 * line 7 - other cost --- qty * price
 * line 8 - another other cost --- qty * price
 * line 9 - Freight --- qty * price
 * ----- repeat for next item ------------------
 * 
 */
require Yii::app()->basePath . '/extensions/XeroOAuth-PHP/lib/XeroOAuth.php';
define('BASE_PATH', Yii::app()->basePath);
define("XRO_APP_TYPE", "Private");
define("OAUTH_CALLBACK", "oob");
$useragent = "XeroOAuth-PHP Private App Test";
$xerosettings = XeroSetting::getSetting();
$signatures = array(
	'consumer_key' => trim($xerosettings->consumer_key), //'KVITWHTB0W8G3ILHSPQWPN5ZQ0T3TP',
	'shared_secret' => trim($xerosettings->shared_secret), //'LEGCHGZBABQKQYNN47QHVBCCA0Y2D8',
	// API versions
	'core_version' => '2.0',
	'payroll_version' => '1.0',
	'file_version' => '1.0'
);

if (XRO_APP_TYPE == "Private" || XRO_APP_TYPE == "Partner") {
	$signatures ['rsa_private_key'] = BASE_PATH . '/../../ssl/certs/privatekey.pem';
	$signatures ['rsa_public_key'] = BASE_PATH . '/../../ssl/certs/publickey.cer';
}

$XeroOAuth = new XeroOAuth(array_merge(array(
			'application_type' => XRO_APP_TYPE,
			'oauth_callback' => OAUTH_CALLBACK,
			'user_agent' => $useragent
				), $signatures));
include Yii::app()->basePath . '/extensions/XeroOAuth-PHP/tests/testRunner.php';

$initialCheck = $XeroOAuth->diagnostics();
$checkErrors = count($initialCheck);
if ($checkErrors > 0) {
	// you could handle any config errors here, or keep on truckin if you like to live dangerously
	foreach ($initialCheck as $check) {
		echo 'Error: ' . $check . PHP_EOL;
	}
} else {
	$session = persistSession(array(
		'oauth_token' => $XeroOAuth->config ['consumer_key'],
		'oauth_token_secret' => $XeroOAuth->config ['shared_secret'],
		'oauth_session_handle' => ''
	));
	$oauthSession = retrieveSession();

	if (isset($oauthSession ['oauth_token'])) {
		$XeroOAuth->config ['access_token'] = $oauthSession ['oauth_token'];
		$XeroOAuth->config ['access_token_secret'] = $oauthSession ['oauth_token_secret'];

		if (!empty($model) && !empty($modelDetial)) {
			$status = "DRAFT";
			//first check for the status if PO already uploaded to Xero
			if ($model->xero_invoice_id) {
				$response = $XeroOAuth->request('GET', $XeroOAuth->url('Invoices/' . $model->xero_invoice_id, 'core'), array(), null, 'json');
				if ($XeroOAuth->response['code'] == 200) {

					$arr = json_decode($XeroOAuth->response['response'], true);
					$status = $arr['Invoices'][0]['Status'];
				}
			}

			$xml = getInvoiceXML($model, $modelDetial, $status);

			$response = $XeroOAuth->request('POST', $XeroOAuth->url('Invoices', 'core'), array(), $xml);

			if ($XeroOAuth->response['code'] == 200) {
				$invoice = $XeroOAuth->parseResponse($XeroOAuth->response['response'], $XeroOAuth->response['format']);


				$xmlarr = xmlToArray($invoice->Invoices[0]->Invoice);


				$model->xero_invoice_id = $xmlarr['Invoice']['InvoiceID']['value'];
				if ($model->save(false)) {

					$this->redirect(array('invoice/view', 'id' => $model->id, 'xr' => 1));
				} else {
					echo 'not saved : ', json_encode($XeroOAuth);
					exit();
					outputError($XeroOAuth);
				}

//                echo "" . count($invoice->Invoices[0]) . " invoice created in this Xero organisation.";
//                if (count($invoice->Invoices[0]) > 0) {
//                    echo "The first one is: </br>";
//                    pr($invoice->Invoices[0]->Invoice);
//                }
			} else {
				$response = $XeroOAuth->parseResponse($XeroOAuth->response['response'], $XeroOAuth->response['format']);
				$responseArr = xml2array($response);

				if (isset($responseArr["Elements"])) {
					$elements = xml2array($responseArr["Elements"]);
					if (isset($elements['DataContractBase']['ValidationErrors'])) {
						$validationErrors = $elements['DataContractBase']['ValidationErrors'];
						$errormsg = '';
						foreach ($validationErrors as $key => $value) {

							$errormsg = $value['Message'];
						}
						if (!empty($errormsg) && $erroeMsg = "Invoice on Xero not of valid status for modification") {
							//invoice cannot modify
							Yii::app()->user->setFlash('notice', $errormsg);
							$this->redirect(array('invoice/view', 'id' => $model->id));
						}
					}
				}



				$responseArr = xml2array($response);

				RecursiveItem::emptyMessage();
				RecursiveItem::messegeRecursive($responseArr);

				$errorMessage = "Xero Error";
				$errorMessage .= '<br>' . RecursiveItem::getMessage();
				Yii::app()->user->setFlash('error', $errorMessage);
				$this->redirect(array('invoice/view', 'id' => $model->id));
			}
		} else {
			echo 'empty model or details';
		}


		//include Yii::app()->basePath .'/extensions/XeroOAuth-PHP/tests/tests.php';
	}

	//testLinks ();
}

function getInvoiceXML($model, $modelDetial, $status = "DRAFT")
{
	$xml = "<Invoices>
              <Invoice>";
	$xml .= "<InvoiceNumber>" . $model->invoiceNum . "</InvoiceNumber>";
	$xml .= "<Status>" . $status . "</Status>";
	$xml .= "<Reference>" . $model->job->jobNum . "</Reference>";
	$xml .= "<Type>ACCREC</Type>";

//    $xml .="<SubTotal>300</SubTotal>";
//    $xml .="<TotalTax>60</TotalTax>";
//    $xml .="<Total>360</Total>";
//    $xml .="<AmountPaid>0</AmountPaid>";
//    $xml .="<AmountDue>360</AmountDue>";


	$xml .= "<Contact>";

	$customername = $model->job->customer->cusnam;
	if (!empty($customername)) {
		$xml .= "<Name>" . $customername . "</Name>";
	} else {
		$xml .= "<Name>Not Set</Name>";
	}





	$addresses = $model->job->customer->getFullAddress();
	if (!empty($addresses)) {
		$xml .= "<Address>" . $addresses . "</Address>";
	}

//        $xml .= "<AddressType>POBOX</AddressType>";
//        $xml .= "<AddressLine>16/6A, Saman Place, Ratnapura</AddressLine>";
//        $xml .= "</Address>";
	$email = $model->job->customer->cusemail;
	if (!empty($email))
		$xml .= "<EmailAddress>" . $email . "</EmailAddress>";


	$telephone = $model->job->customer->custel;
	if (!empty($telephone))
		$xml .= "<Phone>" . $telephone . "</Phone>";
//        $xml .= "<PhoneType>DEFAULT</PhoneType>";
//        $xml .= "<PhoneNumber>+94773081727</PhoneNumber>";
//        $xml .= "</Phones>";


	$xml .= "</Contact>";

	$xml .= "<Date>" . date('Y-m-d', strtotime($model->createdDtm)) . "</Date>";
	if ($model->duedate != '0000-00-00 00:00:00')
		$xml .= "<DueDate>" . date('Y-m-d', strtotime($model->duedate)) . "</DueDate>";
	$xml .= "<LineAmountTypes>Exclusive</LineAmountTypes>
                    <LineItems>";
	foreach ($modelDetial as $dtl) {
		$model = $dtl->workorderdtl;
		$itmQty = $model->prodQty;
		$accountCode = 200;//sales default
		if ($xeroAccount = XeroAccount::model()->findByPk($dtl->xero_account_id) ) {
			$accountCode = $xeroAccount->code;
		}

		/* --------Product Item -------------- */
		$prodCostPrice = round($model->prodCostPrice, 2);
		$prodMarkupRate = round($model->prod_supmarg, 4);
		if (!$prodMarkupRate) {
			$prodMarkupRate = $model->prodSupp->supmrate;
		}

		$prodMarkedUpPrice = intval($prodMarkupRate) ? round(($prodCostPrice * $prodMarkupRate), 2) : $prodCostPrice;

		

		/* --------Product USD Freight -------------- */
		$usdFreight = $model->prod_usd_freight;
		$usdFreightUnit = $usdFreight ? round($usdFreight / $itmQty, 2) : 0;
		$usdFreightPrice = $usdFreightUnit * $model->productFrieghtMarkUpRate;

		

		/* -------- Product Other Cost -------------- */
		$otherCostMarkupRate = $model->other_cost_markup_rate;
		$otherCosts = WorkorderOtherCost::model()->findAll("workorder_detail_id = '{$dtl->workorderdtl->id}'");
		$otherCostPriceTotal = 0;
		foreach ($otherCosts as $costData) {			
			$otherCostPrice = $costData->cost * $otherCostMarkupRate;
			$otherCostPriceTotal += ($otherCostPrice * $itmQty);
			
		}
		
		/* Group USD frieght + other costs price into product price */
		$xml .= getLineItemXML(array(
			'description' => $model->productsku . ' ' . $model->prdsrtdesc,
			'quantity' => $itmQty,
			'unitAmount' => $prodMarkedUpPrice + $usdFreightPrice + ( $otherCostPriceTotal  ? round(($otherCostPriceTotal / $itmQty), 2) : 0),
			'lineAmount' => (($prodMarkedUpPrice + $usdFreightPrice + $otherCostPriceTotal ) * $itmQty),
			'accountCode' =>$accountCode,
		));


		/* -------- Product Decorations -------------- */
		$decorationTotal = 0;
		$decoCostPrice = 0;
		foreach ($model->rel_multi_deco() as $data) {
			/* -------- decoration item -------------- */
			$decoPrice = $data->cost_price * $data->sup_margin;
			$xml .= getLineItemXML(array(
				'description' => $model->productsku . ' ' . $data->decprtnam,
				'quantity' => $itmQty,
				'unitAmount' => $decoPrice,
				'lineAmount' => $decoPrice * $itmQty,
				'accountCode' =>$accountCode,
			));
			/* -------- logo setup charge -------------- */
			$logoSetupPrice = $data->logo_setup_unit_markedup_price;
			$xml .= getLineItemXML(array(
				'description' => $model->productsku . ' ' . $data->decprtnam . ' Logo Setup',
				'quantity' => $itmQty,
				'unitAmount' => $logoSetupPrice,
				'lineAmount' => $logoSetupPrice * $itmQty,
				'accountCode' =>$accountCode,
			));

			$decoCalArr = $data->getDecorationCalculations(
					array(
						'cost_price' => $data->cost_price,
						'sup_margin' => $data->sup_margin,
						'logo_setup' => $data->logo_setup,
						'quantity' => $data->quantity,
						'logo_setup_markup_rate' => $data->logo_setup_markup_rate,
			));

			$decoCostPrice += $data->cost_price + $decoCalArr['logo_setup_unit_price'];
			$decorationTotal += $decoCalArr['sup_markedup_price'] + $decoCalArr['logo_setup_unit_markedup_price'];
		}
		
	}


	$xml .= "</LineItems>
                     </Invoice>
            </Invoices>";

	return $xml;
}

function getLineItemXML($data = array())
{
	$xml = "<LineItem>";
	$xml .= "<Description>" . $data['description'] . "</Description>";
	$xml .= "<Quantity>" . $data['quantity'] . "</Quantity>";
	$xml .= "<UnitAmount>" . $data['unitAmount'] . "</UnitAmount>";
	$xml .= "<LineAmount>" . $data['lineAmount'] . "</LineAmount>";
	$xml .= "<AccountCode>". $data['accountCode'] ."</AccountCode>";
	$xml .= "</LineItem>";

	return $xml;
}

function getItemXML($modelDetial)
{
	$xml .= "<Items>";


	foreach ($modelDetial as $dtl) {
		$xml .= "<Item>";
		$code = (!empty($dtl->workorderdtl->productsku) ? $dtl->workorderdtl->productsku : $dtl->workorderdtl->custmproduct );
		$xml .= "<Code>" . $code . "</Code>";
		$xml .= "<Name>" . $dtl->workorderdtl->prdsrtdesc . "</Name>";
		$xml .= "<Description>" . $dtl->workorderdtl->prdlngdesc . "</Description>";
		$xml .= "</Item>";
	}



	$xml .= "</Items>";

	return $xml;
}

function xmlToArray(SimpleXMLElement $xml)
{
	$parser = function (SimpleXMLElement $xml, array $collection = []) use (&$parser) {
		$nodes = $xml->children();
		$attributes = $xml->attributes();

		if (0 !== count($attributes)) {
			foreach ($attributes as $attrName => $attrValue) {
				$collection['attributes'][$attrName] = strval($attrValue);
			}
		}

		if (0 === $nodes->count()) {
			$collection['value'] = strval($xml);
			return $collection;
		}

		foreach ($nodes as $nodeName => $nodeValue) {
			if (count($nodeValue->xpath('../' . $nodeName)) < 2) {
				$collection[$nodeName] = $parser($nodeValue);
				continue;
			}

			$collection[$nodeName][] = $parser($nodeValue);
		}

		return $collection;
	};

	return array(
		$xml->getName() => $parser($xml)
	);
}

function getMarginOutOfMarkupMultiplier($rate)
{
	if (!$rate || $rate === 0) {
		return 0;
	}

	$markup_decimal_value = $rate;
	$hold_value = $markup_decimal_value * 100;
	$hold_value2 = $hold_value - 100;
	if (floatval($markup_decimal_value) != 0.0) {
		$new_margin_percentate = ($hold_value2 / $markup_decimal_value);
	} else {
		$new_margin_percentate = $hold_value2;
	}


	return intval($new_margin_percentate);
}

?>
