<?php
$refreshXeroMenu = array(
        'label' => 'Synchronize Xero Invoices',
        'url' => array('#'),
        'linkOptions' => array(
            'onclick' => 'xeroSynchronizeAll(this);return false;',
            'data-loading-text' => "Xero Invoices Synchronizing...",
            'data-done-text' => "Xero Invoices Synchronized!",
            'data-error-text' => "Xero Synchronizing Error!",
            'data-auth-text' => "Xero Authentication Error!",
            'style' => 'background-color:#32cd32')
    );


$this->menu = array(
    //$jobinfocusmenu,
    $refreshXeroMenu,
        //$createinvoicemenu,
        //array('label' => 'Xero Update', 'url' => array('invoice/xeroUpdate')),
);
?>
<?php
foreach (Yii::app()->user->getFlashes() as $key => $message) {
    echo '<div class="flash-' . $key . '">' . $message . "</div>\n";
}
?>
<h1>Xero Invoices Queue </h1>

<section>
    <div id="xero-message" style="color: #F19031;">Xero Response messages</div>
</section>

<?php
$this->widget('zii.widgets.grid.CGridView', array(
    'id' => 'invoice-queue-grid',
    'dataProvider' => $model->searchXeroQueue(),
    'filter' => $model,
    'columns' => array(
        array(
            'name' => 'xero_to_be_sent',
            'value' => 'CHtml::checkBox($data->id,$data->xero_to_be_sent,array("class" => "toXeroCheckbox"))',
            'type' => 'raw',
            'htmlOptions' => array('class' => 'toXeroCheckbox'),
        ),
        array(
            'name' => 'duedate',
            'value' => '$data->getRefinedDueDate()'
        ),
        array(
            'name' => 'invoiceNum',
            'value' => '$data->getNumberHtml()',
            'type' => 'html',
        ),
        array(
            'name' => 'master_customer_search',
            'value' => '$data->job->master->mcusnam',
            'type' => 'html',
        ),
        array(
            'name' => 'job.jobNum',
            'value' => '$data->job->jobNum'
        ),
        array(
            'name' => 'customer.cusnam',
            'value' => '$data->job->customer->cusnam',
        ),
        'comments',
        array(
            'name' => 'amountExVat',
            'value' => 'number_format($data->amountExVat,3)',
            'htmlOptions' => array('style' => 'text-align:right'),
        ),
        array(
            'name' => 'amountIncVat',
            'value' => 'number_format($data->amountIncVat,3)',
            'htmlOptions' => array('style' => 'text-align:right'),
        ),
        array(
            'name' => 'status_id',
            'value' => '($data->status_id > 0 ? Status::model()->findByPk($data->status_id)->name : "Not Set")',
            'filter' => CHtml::listData(Status::model()->findAll(array('condition' => "id IN (1,25,3)", 'order' => 'name asc')), 'id', 'name'),
        ),
        array(
            'name' => 'createdDtm',
            'value' => 'date(GlobalVars::get("DateFormat"),strtotime($data->createdDtm))'
        ),
        /*
          'createdDtm',
          'createdBy',

         */
        array(
            'class' => 'CButtonColumn',
            'template' => '{view}{sep1}{print}{sep2}{revoke}',
            'buttons' => array(
                'view' => array
                    (
                    'label' => 'View',
                    'imageUrl' => false,
                ),
                'sep1' => array
                    (
                    'label' => ' | ',
                    'url' => '',
                    'imageUrl' => false,
                ),
                'print' => array
                    (
                    'label' => 'Print',
                    'imageUrl' => false,
                    'url' => 'Yii::app()->createUrl("invoice/print", array("id"=>$data->id))',
                    'options' => array('target' => '_blank'),
                ),
                'sep2' => array
                    (
                    'label' => ' | ',
                    'url' => '',
                    'imageUrl' => false,
                ),
                'revoke' => array
                    (
                    'label' => 'Revoke',
                    'imageUrl' => false,
                    'url' => 'Yii::app()->createUrl("invoice/toggleXeroQueue", array("id"=>$data->id))',
                    'click' => 'js: function(){toggleQueue($(this).attr("href"));return false;}'
                ),
            )
        ),
    ),
));
?>
<script type="text/javascript">

    $('.toXeroCheckbox').on('change', function () {
        if($(this).prop('checked')) {
            if($(this).attr('id')) {
                 toggleXeroSync({id:$(this).attr('id'), xeroSync:1});
            }
        } else {
             if($(this).attr('id')) {
                 toggleXeroSync({id:$(this).attr('id'), xeroSync:0});
             }
        }
        
    });

    function toggleXeroSync(obj) {
        $.ajax({
            type: 'POST',
            url: '<?php echo Yii::app()->createUrl("invoice/toggleXeroSync"); ?>',
            data: obj,
            dataType: 'json',
            success: function (result) {
                
            },
            error: function (result) {
                console.log(result);
            },

        });
    }

    /**
    * revoke from the Xero queue
    * */
    function toggleQueue(url) {
        $.ajax({
            type: 'POST',
            url: url,
            data: {},
            dataType: 'json',
            success: function (result) {
                if (result.success) {
                    $.fn.yiiGridView.update("invoice-queue-grid");
                }
            },
            error: function (result) {

            },

        });
    }

    function xeroSynchronizeAll(e)
    {
        $('#xero-message').html('');
        const $this = $(e);        
        $this.button('loading');

        $.ajax({
            type: 'POST',
            url: '<?php echo Yii::app()->createUrl("invoice/xeroQueuePush"); ?>',
            data: {},
            dataType: 'json',
            success: function (result) { 
                
                if (result?.messages) {
                    //array of message
                    const markupArr = result.messages.map( msg => `<p>${msg}</p>` );
                    let markupHtml = '';
                    markupArr.forEach(element => markupHtml += element);                  
                    $('#xero-message').html(markupHtml);
                    
                    
                }
                
                if (!result.success && result?.type === 'auth') {
                    $this.button('auth');
                    return;
                }
               
                if (!result.success) {
                    $this.button('error');
                    return;
                }
                
                if (result.success) {
                    $this.button('done');
                    $('#invoice-queue-grid').yiiGridView('update');
                    return;
                }                    
            },
            error: function (result) {                
                $this.button('error');
            },

        });
    }
    
</script>



