<div class="form view">
    <div>
        <?php
        $form = $this->beginWidget('CActiveForm', array(
            'id' => 'job-artwork-form',
            'enableAjaxValidation' => false,
            'htmlOptions' => array('enctype' => 'multipart/form-data'),
        ));
        ?>

        <p class="note">Fields with <span class="required">*</span> are required.</p>

        <?php echo $form->errorSummary($model); ?>


        <div class="row" id="exist_img_logo" style="display: none;border: 1px solid #C9E0ED;width: 600px;">
            <?php echo $form->labelEx($model, 'archiveImageLogo'); ?>
            <img id="exist_img_src" src="" style="width: 600px;" />
        </div>

        
            <div class="clear"></div>



            <div class="row">
                <?php echo $form->textField($model, 'inventory_id', array('style' => 'display:none;')); ?>
                <?php echo $form->textField($model, 'job_id', array('style' => 'display:none;')); ?>
                <?php echo $form->textField($model, 'job_deco_id_str', array('style' => 'display:none;')); ?>
                <?php echo $form->labelEx($model, 'productColor'); ?>
                <?php echo $form->textField($model, 'productColor', array('size' => 60, 'maxlength' => 100)); ?>
                <?php echo $form->error($model, 'productColor'); ?>
            </div>
            
            <div class="row">
                <?php echo $form->labelEx($model, 'decorationType'); ?>
                <?php echo $form->textField($model, 'decorationType', array('size' => 60, 'maxlength' => 100)); ?>
                <?php echo $form->error($model, 'decorationType'); ?>
            </div>

            <div class="row">
                <?php echo $form->labelEx($model, 'decorationPosition'); ?>
                <?php echo $form->textField($model, 'decorationPosition', array('size' => 60, 'maxlength' => 100)); ?>
                <?php echo $form->error($model, 'decorationPosition'); ?>
            </div>

            <div class="row">
                <?php echo $form->labelEx($model, 'logoName'); ?>
                <?php echo $form->textField($model, 'logoName', array('size' => 60, 'maxlength' => 200)); ?>
                <?php echo $form->error($model, 'logoName'); ?>
            </div>

            <div class="row">
                <?php echo $form->labelEx($model, 'printSize'); ?>
                <?php echo $form->textField($model, 'printSize', array('size' => 60, 'maxlength' => 100)); ?>
                <?php echo $form->error($model, 'printSize'); ?>
            </div>

            <div class="row">
                <?php echo $form->labelEx($model, 'printColor'); ?>
                <?php echo $form->textField($model, 'printColor', array('size' => 60, 'maxlength' => 100)); ?>
                <?php echo $form->error($model, 'printColor'); ?>
            </div>

            <div class="row">
                <?php echo $form->labelEx($model, 'designNumber'); ?>
                <?php echo $form->textField($model, 'designNumber', array('size' => 60, 'maxlength' => 100)); ?>
                <?php echo $form->error($model, 'designNumber'); ?>
            </div>

            <div class="row">
                <?php echo $form->labelEx($model, 'isRepeatDesign'); ?>
                <?php echo $form->checkbox($model, 'isRepeatDesign'); ?>
                <?php echo $form->error($model, 'isRepeatDesign'); ?>
            </div>
            <div class="row">
                <?php echo $form->labelEx($model, 'jobPriority'); ?>
                <?php echo $form->textField($model, 'jobPriority', array('size' => 60, 'maxlength' => 100)); ?>
                <?php echo $form->error($model, 'jobPriority'); ?>
            </div>
            <div class="clear"></div>
            <div class="row">
                <?php echo $form->labelEx($model, 'followupDate'); ?>
                <?php
                $todayDate = date(GlobalVars::DATE_FORMAT); // current date
                $currentTime = time($todayDate) + 60 * 60 * 11 + 30 * 60; //Change date into time
                $currentTime = date(GlobalVars::get(GlobalVars::DATE_FORMAT), $currentTime);

                Yii::import('application.extensions.CJuiDateTimePicker.CJuiDateTimePicker');
                $this->widget('CJuiDateTimePicker', array(
                    'model' => $model, //Model object
                    'attribute' => 'followupDate', //attribute name
                    'mode' => 'date', //use "time","date" or "datetime" (default)
                    'options' => array("dateFormat" => 'dd-mm-yy', "changeMonth" => 'true', 'changeYear' => 'true', 'minDate' => $currentTime,), // jquery plugin options
                    'language' => 'en-GB'
                ));
                ?>
                <?php echo $form->error($model, 'followupDate'); ?>
            </div>
            <div class="row">
                <?php echo $form->labelEx($model, 'dueDate'); ?>
                <?php
                Yii::import('application.extensions.CJuiDateTimePicker.CJuiDateTimePicker');
                $this->widget('CJuiDateTimePicker', array(
                    'model' => $model, //Model object
                    'attribute' => 'dueDate', //attribute name
                    'mode' => 'date', //use "time","date" or "datetime" (default)
                    'options' => array("dateFormat" => 'dd-mm-yy', "changeMonth" => 'true', 'changeYear' => 'true'), // jquery plugin options
                    'language' => 'en-GB'
                ));
                ?>
                <?php echo $form->error($model, 'dueDate'); ?>
            </div>
            <div class="clear"></div>
            <div style="width: 100%;">
                <?php echo $form->labelEx($model, 'comments'); ?>
                <?php echo $form->textArea($model, 'comments', array('rows' => 6, 'style' => 'width:67%;')); ?>
                <?php echo $form->error($model, 'comments'); ?>
            </div>

            <div class="clear"></div>           
            
            
            <div class="row buttons">
                <?php echo CHtml::submitButton($model->isNewRecord ? 'Create' : 'Save', array('onclick' => 'checkDueDate();return false;')); ?>
            </div>

            <?php $this->endWidget(); ?>
            <div class="clear"></div>

    </div>
</div><!-- form -->