

<div class="form view">
    <div >
        <?php
        $form = $this->beginWidget('CActiveForm', array(
            'id' => 'job-artwork-form',
            'enableAjaxValidation' => false,
            'htmlOptions' => array('enctype' => 'multipart/form-data'),
        ));
        ?>

        <p class="note">Fields with <span class="required">*</span> are required.</p>

        <?php echo $form->errorSummary($model); ?>


        <div class="row" id="exist_img_logo" style="display: none;border: 1px solid #C9E0ED;width: 600px;">
            <?php echo $form->labelEx($model, 'archiveImageLogo'); ?>
            <img id="exist_img_src" src="" style="width: 600px;"/>
        </div>

        <?php
        if ($model->id > 0) {
            ?>
            <div class="row" style="border: 1px solid #C9E0ED;">
                <?php
                echo CHtml::image('images/artwork/job/' . $model->artworkjobNum . '/' . $model->archiveImageLogo, '', array('style' => 'width:600px;'));
            }
            ?>
        </div>
        <div class="clear"></div>



        <div class="row">
            <?php echo $form->textField($model, 'inventory_id', array('style' => 'display:none;')); ?>
            <?php echo $form->textField($model, 'job_id', array('style' => 'display:none;')); ?>
            <?php echo $form->textField($model, 'job_deco_id_str', array('style' => 'display:none;')); ?>
            <?php echo $form->labelEx($model, 'productColor'); ?>
            <?php echo $form->textField($model, 'productColor', array('size' => 60, 'maxlength' => 100)); ?>
            <?php echo $form->error($model, 'productColor'); ?>
        </div>

        <div class="row" id="upload_img_logo">
            <?php echo $form->labelEx($model, 'archiveImageLogo'); ?>
            <?php echo $form->fileField($model, 'archiveImageLogo', array('size' => 60, 'maxlength' => 255)); ?>
            <?php echo $form->error($model, 'archiveImageLogo'); ?>
        </div>

        <div class="row">
            <?php echo $form->labelEx($model, 'decorationType'); ?>
            <?php echo $form->textField($model, 'decorationType', array('size' => 60, 'maxlength' => 100)); ?>
            <?php echo $form->error($model, 'decorationType'); ?>
        </div>
        
        <div class="row">
            <?php echo $form->labelEx($model, 'decorationPosition'); ?>
            <?php echo $form->textField($model, 'decorationPosition', array('size' => 60, 'maxlength' => 100)); ?>
            <?php echo $form->error($model, 'decorationPosition'); ?>
        </div>
        
        <div class="row">
            <?php echo $form->labelEx($model, 'logoName'); ?>
            <?php echo $form->textField($model, 'logoName', array('size' => 60, 'maxlength' => 200)); ?>
            <?php echo $form->error($model, 'logoName'); ?>
        </div>

        <div class="row">
            <?php echo $form->labelEx($model, 'printSize'); ?>
            <?php echo $form->textField($model, 'printSize', array('size' => 60, 'maxlength' => 100)); ?>
            <?php echo $form->error($model, 'printSize'); ?>
        </div>

        <div class="row">
            <?php echo $form->labelEx($model, 'printColor'); ?>
            <?php echo $form->textField($model, 'printColor', array('size' => 60, 'maxlength' => 100)); ?>
            <?php echo $form->error($model, 'printColor'); ?>
        </div>

        <div class="row">
            <?php echo $form->labelEx($model, 'designNumber'); ?>
            <?php echo $form->textField($model, 'designNumber', array('size' => 60, 'maxlength' => 100)); ?>
            <?php echo $form->error($model, 'designNumber'); ?>
        </div>

        <div class="row">
            <?php echo $form->labelEx($model, 'isRepeatDesign'); ?>
            <?php echo $form->checkbox($model, 'isRepeatDesign'); ?>
            <?php echo $form->error($model, 'isRepeatDesign'); ?>
        </div>
        <div class="row">
            <?php echo $form->labelEx($model, 'jobPriority'); ?>
            <?php echo $form->textField($model, 'jobPriority', array('size' => 60, 'maxlength' => 100)); ?>
            <?php echo $form->error($model, 'jobPriority'); ?>
        </div>
        <div class="clear"></div>
        <div class="row">
            <?php echo $form->labelEx($model, 'followupDate'); ?>
            <?php
            $todayDate = date(GlobalVars::DATE_FORMAT); // current date
            $currentTime = time($todayDate) + 60 * 60 * 11 + 30 * 60; //Change date into time
            $currentTime = date(GlobalVars::get(GlobalVars::DATE_FORMAT), $currentTime);

            Yii::import('application.extensions.CJuiDateTimePicker.CJuiDateTimePicker');
            $this->widget('CJuiDateTimePicker', array(
                'model' => $model, //Model object
                'attribute' => 'followupDate', //attribute name
                'mode' => 'date', //use "time","date" or "datetime" (default)
                'options' => array("dateFormat" => 'dd-mm-yy', "changeMonth" => 'true', 'changeYear' => 'true', 'minDate' => $currentTime,), // jquery plugin options
                'language' => 'en-GB'
            ));
            ?>
            <?php echo $form->error($model, 'followupDate'); ?>
        </div>
        <div class="row">
            <?php echo $form->labelEx($model, 'dueDate'); ?>
            <?php
            Yii::import('application.extensions.CJuiDateTimePicker.CJuiDateTimePicker');
            $this->widget('CJuiDateTimePicker', array(
                'model' => $model, //Model object
                'attribute' => 'dueDate', //attribute name
                'mode' => 'date', //use "time","date" or "datetime" (default)
                'options' => array("dateFormat" => 'dd-mm-yy', "changeMonth" => 'true', 'changeYear' => 'true'), // jquery plugin options
                'language' => 'en-GB'
            ));
            ?>
            <?php echo $form->error($model, 'dueDate'); ?>
        </div>
        <div class="clear"></div>
        <div style="width: 100%;">
            <?php echo $form->labelEx($model, 'comments'); ?>
            <?php echo $form->textArea($model, 'comments', array('rows' => 6, 'style' => 'width:67%;')); ?>
            <?php echo $form->error($model, 'comments'); ?>
        </div>

        <div class="clear"></div>
        <?php
        if (isset($subjobstasks)) {
            ?>
            <div class="view">
                <h3>Sub Jobs</h3>
                <?php
                $this->widget('zii.widgets.grid.CGridView', array(
                    'id' => 'job-artwork-subjob-grid',
                    'dataProvider' => $subjobstasks->search(),
                    'filter' => null,
                    'columns' => array(
                        //'id',
                        array(
                            'name' => 'subArtworkJobId',
                            'value' => '$data->subjob->name',
                        ),
                        //'jobArtworkId',
                        array(
                            'name' => 'note',
                            'type' => 'raw',
                            'value' => 'CHtml::textField(JobArtworkSubjob::model()->note,$data->note,array("style"=>"width:98%;", "id"=>"note_" . $data->id,"onchange"=>"subjobupdate($data->id,\'note\');"))',
                            'htmlOptions' => array('style' => 'width:25%;')
                        ),
                        array(
                            'name' => 'statusId',
                            'type' => 'raw',
                            //'value'=>'$data->RelStatus->name',
                            'value' => 'CHtml::dropDownList(JobArtworkSubjob::model()->statusId,$data->RelStatus->id, Chtml::listData(Status::model()->findAll(array("condition"=>"id in (1,4,10,11,17,18,19,22,23)","order"=>"name asc")), "id", "name"),array("style"=>"width:98%;","empty"=>"Select", "id"=>"statusId_" . $data->id, "onchange"=>"subjobupdate($data->id,\'statusId\');"))',
                            'htmlOptions' => array('style' => 'width:20%;')
                        ),
                        array(
                            'name' => 'statusDate',
                            'value' => 'date("Y-m-d H:i:s",strtotime($data->statusDate))'
                        ),
                        array(
                            'name' => 'dueDate',
                            'value' => 'date("Y-m-d",strtotime($data->dueDate))'
                        ),
                        /*
                          'createdBy',
                         * 
                         */
                        array(
                            'class' => 'CButtonColumn',
                            'template' => '{delete}',
                            'buttons' => array(
                                'delete' => array
                                    (
                                    'label' => 'Delete',
                                    'imageUrl' => false,
                                    'url' => 'Yii::app()->createUrl("jobArtworkSubjob/delete", array("id"=>$data->id))',
                                ),
                            ),
                        ),
                    ),
                ));
                ?>
            </div>
            <?php
        }
        ?>
        <div class="view">
            <h3>Add Sub Jobs</h3>
            <?php
            Yii::app()->clientScript->registerScript('tr-event-propagation', '$("#sub-artwork-job-grid tr").click(function(event){
    event.stopPropagation();
});');
            $this->widget('zii.widgets.grid.CGridView', array(
                'id' => 'sub-artwork-job-grid',
                'dataProvider' => $subjobs->search(),
                'filter' => $subjobs,
                'selectableRows' => 100,
                'columns' => array(
                    array(
                        'class' => 'CCheckBoxColumn',
                    ),
                    array(
                        'name'=>'jobCategory',
                        'filter'=>false,
                    ),
                    array(
                        'name'=>'productCategory',
                        'filter'=>false,
                    ),
                    array(
                        'name'=>'name',
                        'filter'=>false,
                    ),
                    
                    array(
                        'name' => 'dueDate',
                        'value' => function ($data, $row, $column) {
                            $controller = $column->grid->owner;
                            $controller->widget('application.extensions.CJuiDateTimePicker.CJuiDateTimePicker', array(
                                'model' => new SubArtworkJob(), //Model object
                                'attribute' => 'dueDate', //attribute name
                                'mode' => 'date', //use "time","date" or "datetime" (default)
                                'options' => array("dateFormat" => 'yy-mm-dd', "changeMonth" => 'true', 'changeYear' => 'true'), // jquery plugin options
                                'htmlOptions' => array('id' => 'dueDate_' . $data->id, 'value' => $data->dueDate, 'name'=>"SubArtworkJob[dueDate][$data->id]" ,"style"=>"width:95%;"),
                                'language' => 'en-GB'
                            ));
                        },
                        'htmlOptions' =>array('style'=>'width:25%;'),        
                        'filter'=>false,        
                    ),
                ),
            ));
            ?>

        </div>
        <div class="clear"></div>
        <div class="row buttons">
            <?php echo CHtml::submitButton($model->isNewRecord ? 'Create' : 'Save', array('onclick'=>'checkDueDate();return false;')); ?>
        </div>

        <?php $this->endWidget(); ?>
        <div class="clear"></div>

    </div>
</div><!-- form -->

<script>
    
    function checkDueDate(){
       
        var checkedcount = 0;
        var validdatecount = 0;
        var r = /^(\d{4})\-(\d{2})\-(\d{2})$/;
        $('#sub-artwork-job-grid table tbody tr').each(function(index,element){
                var dateval = $(this).children('td:last-child').children('input').val();
                if(($(this).children('td:first-child').children('input[type=checkbox]').is(':checked') === true)){
                     checkedcount++;
                     if(r.test(dateval))
                      validdatecount++;
                }
               
        });
        
        if(checkedcount === 0){
            $("#job-artwork-form").submit();
        }else if(checkedcount !== 0 && validdatecount !== 0 && (checkedcount === validdatecount)){
            $("#job-artwork-form").submit();
        } else {
            alert('Date format not valid!');
        };
    }
    
    function subjobupdate(id, field) {
        var value = $('#' + field + '_' + id).val();
        $.ajax({
            type: 'POST',
            url: '<?php echo Yii::app()->createUrl("jobArtworkSubjob/updateField"); ?>',
            data: {'id': id, 'field': field, 'value': value},
            dataType: 'json',
            success: function(result) {
                $.fn.yiiGridView.update("sales-log-grid");
                $.fn.yiiGridView.update("job-artwork-subjob-grid");
            },
            error: function(result) {
                alert('error in update');
            }
        });
    }
</script>
