<?php


Yii::app()->clientScript->registerScript('search', "
$('.search-button').click(function(){
	$('.search-form').toggle();
	return false;
});
$('.search-form form').submit(function(){
	$.fn.yiiGridView.update('job-artwork-grid', {
		data: $(this).serialize()
	});
	return false;
});
");
?>

<h1>Artwork Jobs Due In Next 7 Days</h1>



<?php
$this->widget('zii.widgets.grid.CGridView', array(
    'id' => 'job-artwork-grid',
    'dataProvider' => $model->searchDue(7),
    'filter' => $model,
    'columns' => array(
        array(
            'name' => 'dueDate',
            'value' => 'date(GlobalVars::get(GlobalVars::DATE_FORMAT),  strtotime($data->dueDate))',
        ),
        array(
            'name' => 'archiveImageLogo',
            'value' => 'CHtml::image("images/artwork/job/" . $data->artworkjobNum . "/" . $data->archiveImageLogo, "", array("style" => "width:150px;"))',
            'type' => 'raw',
        ),
        'artworkjobNum',
        //'productColor',		
        //'decorationType',
        'logoName',
        //'printSize',
        //'printColor',
        'designNumber',
        //'isRepeatDesign',
        'comments',
        //'signOffTerms',
        'jobType',
        array(
            'name' => 'job_status_id',
            'value' => 'Status::getStatusName($data->job_status_id)',
            'filter'=>CHtml::listData(Status::model()->findAll(array('condition'=>"id IN (5,17,18)")), 'id', 'name'),
        ),
        array(
            'name' => 'approve_status_id',
            'value' => 'Status::getStatusName($data->approve_status_id)',
            'filter'=>CHtml::listData(Status::model()->findAll(array('condition'=>"id IN (22,23)")), 'id', 'name'),
        ),
//        array(
//            'name' => 'approveDate',
//            'value' => '(!empty($data->approveDate) ? date(GlobalVars::get(GlobalVars::DATE_FORMAT),  strtotime($data->approveDate)) : "Not Set")',
//        ),
        array(
            'name' => 'createdDate',
            'value' => 'date(GlobalVars::get(GlobalVars::DATE_FORMAT),  strtotime($data->createdDate))',
        ),
        array(
            'class' => 'CButtonColumn',
            'template' => '{view}',
            'buttons' => array(
                'view' => array
                    (
                    'label' => 'View',
                    'imageUrl' => false,
                ),
                
            ),
        ),
    ),
));
?>
