<?php
$this->breadcrumbs = array(
    'Job Artworks' => array('index'),
    'Manage',
);

$this->menu = array(
        //array('label'=>'List JobArtwork', 'url'=>array('index')),
        //array('label'=>'Create JobArtwork', 'url'=>array('create')),
);

Yii::app()->clientScript->registerScript('search', "
$('.search-button').click(function(){
	$('.search-form').toggle();
	return false;
});
$('.search-form form').submit(function(){
	$.fn.yiiGridView.update('job-artwork-grid', {
		data: $(this).serialize()
	});
	return false;
});
");
?>

<h1>Outstanding Artwork Jobs</h1>

<?php 
    $form = $this->beginWidget('CActiveForm', array(
        'id' => 'outstanding-form',
        'enableAjaxValidation' => false,
    ));
?>
<div class="form view">
    <!-- search on date between created date -->
    <div class="row">
        <label  for="createdDtm">Created Date From</label>
        <?php
        Yii::import('application.extensions.CJuiDateTimePicker.CJuiDateTimePicker');
        $this->widget('CJuiDateTimePicker', array(
            'model' => $model, //Model object
            'attribute' => 'createddatefrom', //attribute name
            'mode' => 'date', //use "time","date" or "datetime" (default)
            'options' => array("dateFormat" => 'dd-mm-yy', "changeMonth" => 'true', 'changeYear' => 'true',
//                             'minDate'=>$currentTime,
            ), // jquery plugin options
            'language' => 'en-GB'
        ));
        ?>
    </div>    
    <div class="row">
        <label  for="createdDtm">Created Date To</label>
        <?php
        
        $this->widget('CJuiDateTimePicker', array(
            'model' => $model, //Model object
            'attribute' => 'createddateto', //attribute name
            'mode' => 'date', //use "time","date" or "datetime" (default)
            'options' => array("dateFormat" => 'dd-mm-yy', "changeMonth" => 'true', 'changeYear' => 'true',
//                             'minDate'=>$currentTime,
            ), // jquery plugin options
            'language' => 'en-GB'
        ));
        ?>

    </div>
    <!-- end -->
    <!-- search on date between follow up dates -->
    <div class="row">
        <label  for="createdDtm">Follow-up Date From</label>
        <?php
        Yii::import('application.extensions.CJuiDateTimePicker.CJuiDateTimePicker');
        $this->widget('CJuiDateTimePicker', array(
            'model' => $model, //Model object
            'attribute' => 'followupdatefrom', //attribute name
            'mode' => 'date', //use "time","date" or "datetime" (default)
            'options' => array("dateFormat" => 'dd-mm-yy', "changeMonth" => 'true', 'changeYear' => 'true',
//                             'minDate'=>$currentTime,
            ), // jquery plugin options
            'language' => 'en-GB'
        ));
        ?>
    </div>    
    <div class="row">
        <label  for="createdDtm">Follow-up Date To</label>
        <?php
        
        $this->widget('CJuiDateTimePicker', array(
            'model' => $model, //Model object
            'attribute' => 'followupdateto', //attribute name
            'mode' => 'date', //use "time","date" or "datetime" (default)
            'options' => array("dateFormat" => 'dd-mm-yy', "changeMonth" => 'true', 'changeYear' => 'true',
//                             'minDate'=>$currentTime,
            ), // jquery plugin options
            'language' => 'en-GB'
        ));
        ?>

    </div>
    <!-- end -->
    <!-- search on date between expected date -->
    <div class="row">
        <label  for="createdDtm">Due Date From</label>
        <?php
        Yii::import('application.extensions.CJuiDateTimePicker.CJuiDateTimePicker');
        $this->widget('CJuiDateTimePicker', array(
            'model' => $model, //Model object
            'attribute' => 'duedatefrom', //attribute name
            'mode' => 'date', //use "time","date" or "datetime" (default)
            'options' => array("dateFormat" => 'dd-mm-yy', "changeMonth" => 'true', 'changeYear' => 'true',
//                             'minDate'=>$currentTime,
            ), // jquery plugin options
            'language' => 'en-GB'
        ));
        ?>
    </div>    
    <div class="row">
        <label  for="createdDtm">Due Date To</label>
        <?php
        
        $this->widget('CJuiDateTimePicker', array(
            'model' => $model, //Model object
            'attribute' => 'duedateto', //attribute name
            'mode' => 'date', //use "time","date" or "datetime" (default)
            'options' => array("dateFormat" => 'dd-mm-yy', "changeMonth" => 'true', 'changeYear' => 'true',
//                             'minDate'=>$currentTime,
            ), // jquery plugin options
            'language' => 'en-GB'
        ));
        ?>

    </div>
    <!-- end -->
    <div class="clear"></div>
    <div class="buttons row">
        <?php echo CHtml::submitButton('Reset'); ?><?php echo CHtml::submitButton('Go'); ?>
        <?php $this->endWidget(); ?>
    </div>
    <div style="float: right;">
        <?php echo CHtml::button('Print PDF',array('style'=>'float:right;','onclick'=>'generatePDF();', 'disabled'=>true)); ?>
        <?php echo CHtml::button('Generate Excel',array('style'=>'float:right;','onclick'=>'generateExcel();', 'disabled'=>true)); ?>
    
    </div>
     <div class="clear"></div>
</div>


<?php
$this->widget('zii.widgets.grid.CGridView', array(
    'id' => 'job-artwork-grid',
    'dataProvider' => $model->searchOutstanding(),
    'filter' => $model,
    'columns' => array(
         array(
            'name' => 'dueDate',
            'value' => 'date(GlobalVars::get(GlobalVars::DATE_FORMAT),  strtotime($data->dueDate))',
        ),
        array(
            'name' => 'archiveImageLogo',
            'value' => 'CHtml::image("images/artwork/job/" . $data->artworkjobNum . "/" . $data->archiveImageLogo, "", array("style" => "width:150px;"))',
            'type' => 'raw',
        ),
        'artworkjobNum',
        //'productColor',		
        //'decorationType',
        'logoName',
        //'printSize',
        //'printColor',
        'designNumber',
        //'isRepeatDesign',
        'comments',
        //'signOffTerms',
        array(
            'name'=>'jobType',
            
        ),
        array(
            'name' => 'job_status_id',
            'value' => 'Status::getStatusName($data->job_status_id)',
            'filter'=>CHtml::listData(Status::model()->findAll(array('condition'=>"id IN (1,2,5,10,14,15,16,18,25)",'order'=>'name asc')), 'id', 'name'),
        ),
        array(
            'name' => 'approve_status_id',
            'value' => 'Status::getStatusName($data->approve_status_id)',
            'filter'=>CHtml::listData(Status::model()->findAll(array('condition'=>"id IN (22,23)")), 'id', 'name'),
        ),
//        array(
//            'name' => 'approveDate',
//            'value' => '(!empty($data->approveDate) ? date(GlobalVars::get(GlobalVars::DATE_FORMAT),  strtotime($data->approveDate)) : "Not Set")',
//        ),
        array(
            'name' => 'createdDate',
            'value' => 'date(GlobalVars::get(GlobalVars::DATE_FORMAT),  strtotime($data->createdDate))',
        ),        
    ),
));
?>
