<?php
$pomenue = null;
$jobdonemenu = null;
$backtojob = null;
$updatemenu = null;
$cancelmenu = null;
$manageartworkmenu = null;

if (!empty($model->po_id) && Yii::app()->user->checkAccess("PurchaseOrders.View")) {
    $po = PurchaseOrders::model()->findByPk($model->po_id);
    if (!empty($po)) {
        $pomenue = array('label' => $po->poNum, 'url' => array('purchaseOrders/view', 'id' => $po->id));
    }
}

if (!in_array($model->job_status_id, array(3, 11)) && Yii::app()->user->checkAccess("JobArtwork.Done")) {
    $jobdonemenu = array('label' => 'Job Done', 'url' => array('done', 'id' => $model->id));
}

if(Yii::app()->user->checkAccess('Jobs.Admin')){
    $backtojob = array('label' => 'Back to : ' . $model->job->jobNum, 'url' => array('jobs/view', 'id' => $model->job->id));
}


if(Yii::app()->user->checkAccess("JobArtwork.Update")){
    $updatemenu = array('label' => 'Update', 'url' => array('update', 'id' => $model->id));
}

if(Yii::app()->user->checkAccess("JobArtwork.Cancel")){
    $cancelmenu = array('label' => 'Cancel', 'url' => '#', 'linkOptions' => array('style' => 'background-color:#CC3300', 'submit' => array('delete', 'id' => $model->id), 'confirm' => 'Are you sure you want to delete this item?'));
    
}

if(Yii::app()->user->checkAccess("JobArtwork.Admin")){
    $manageartworkmenu =  array('label' => 'Manage Artwork Job', 'url' => array('admin'));
}

$this->menu = array(
    $backtojob,
    $pomenue,
    $updatemenu,
    $jobdonemenu,
    $cancelmenu,
   $manageartworkmenu,
);
?>

<h1>View Artwork Job #<?php echo $model->artworkjobNum; ?></h1>
<?php
foreach (Yii::app()->user->getFlashes() as $key => $message) {
    echo '<div class="flash-' . $key . '">' . $message . "</div>\n";
}

if (isset($_GET['send']) && $_GET['send'] == 1) {
    echo '<div style="color:#00ff00;font-weight:bold;font-size:1.2em;">Confirmation email has been sent to customer</div>';
} else if (isset($_GET['send']) && $_GET['send'] == 0) {
    echo '<div style="color:#ff0000;font-weight:bold;font-size:1.2em;">Confirmation email sending to customer is failed.</div>';
}
?>
<div class="view">
    <div style="width: 50%;float: left;">
        <p style="font-size: 1.2em; font-weight: bold;">Artwork Main Details</p>
        <?php
        $this->widget('zii.widgets.CDetailView', array(
            'data' => $model,
            'attributes' => array(
                'id',
                'productColor',
                //'archiveImageLogo',
                'decorationType',
                'decorationPosition',
                'logoName',
                'printSize',
                'printColor',
                'designNumber',
                'isRepeatDesign',
                'comments',
                'signOffTerms',
                'jobType',
                array(
                    'name' => 'followupDate',
                    'value' => date(GlobalVars::get("DateFormat"), strtotime($model->followupDate)),
                ),
                array(
                    'name' => 'dueDate',
                    'value' => date(GlobalVars::get("DateFormat"), strtotime($model->dueDate)),
                ),
                array(
                    'name' => 'job_status_id',
                    'value' => Status::getStatusName($model->job_status_id),
                ),
                array(
                    'name' => 'approve_status_id',
                    'value' => Status::getStatusName($model->approve_status_id),
                ),
                'createdDate',
                'approveDate',
                'jobPriority'
            ),
        ));
        ?>
    </div>
    <div style="width: 50%;float: right;">
        <p style="font-size: 1.2em; font-weight: bold;">Imagery</p>
        <?php
        $this->widget('zii.widgets.CDetailView', array(
            'data' => $model,
            'attributes' => array(
                array(
                    'name' => 'archiveImageLogo',
                    'value' => CHtml::image('images/artwork/job/' . $model->artworkjobNum . '/' . $model->archiveImageLogo, '', array('style' => 'width:150px;')),
                    'type' => 'raw',
                ),
            ),
        ));
        ?>
    </div>
    <div style="width: 50%;float: right;">
        <p style="font-size: 1.2em; font-weight: bold;">Item Details</p>
        <?php
        $this->widget('zii.widgets.grid.CGridView', array(
            'id' => 'artwork-logo-archive-grid',
            'dataProvider' => $decorationproducts,
            'filter' => null,
            'summaryText' => '',
            'columns' => array(
                'id',
//                array(
//                    'name' => 'workorderDtl.image',
//                    'type' => 'raw',
//                    //'value' => 'CHtml::image($data->workorderDtl->getImg())',
//                    'htmlOptions' => array('style' => 'width:100px;'),
//                ),
                array(
                    'name' => 'workorderDtl.productsku',
                ),
                array(
                    'name' => 'workorderDtl.prdsrtdesc',
                ),
            ),
        ));
        ?>
    </div>
    <div style="width: 50%;float: right;">
        <p style="font-size: 1.2em; font-weight: bold;">Customer Details</p>
        <?php
        $this->widget('zii.widgets.CDetailView', array(
            'data' => $model,
            'attributes' => array(
                array(
                    'label' => 'Name',
                    'value' => $model->job->workorder->getCustomerLink(),
                    'type' => 'raw',
                ),
            ),
        ));
        ?>
    </div>
    <div class="clear"></div>
</div>

<div class="view">
    <p style="font-size: 1.2em; font-weight: bold;">Artwork History</p>
    <?php
    $logoarchive = new ArtworkLogoArchive();
    $logoarchive->job_artowk_id = $model->id;
    $this->renderPartial('/artworkLogoArchive/_admin', array('model' => $logoarchive));
    ?>
</div>
<div class="clear"></div>
<?php 
if(Yii::app()->user->checkAccess("FileInventory.UpdateDocument")){
?>
<div id="add-documents-div" class="view">
    <h3>Attached Documents</h3>
    <?php
    $fileinventory = new FileInventory();
    $fileinventory->type = 'ARTWORKJOB';
    $fileinventory->ref_id = $model->id;
    $fileinventory->statusType = 'ManageDocument';
    $this->renderPartial('/fileInventory/admin', array('model' => $fileinventory));
    echo CHtml::button('Add Document', array('submit' => '', 'onclick' => 'setAddDocument();return false;', 'style' => 'float:right;'));
    ?>
    <div class="clear"></div> 
    <div id="add-doc-form-div" class="view" style="display: none;">
        <br> <span style="font-size: 1em;font-weight: bold;">Add Documents</span> 
        <?php
        $this->renderPartial('/fileInventory/_form', array('model' => $fileinventory));
        ?>
        <div class="clear"></div> 
    </div>

    <div id="update-doc-form-div" class="view" style="display: none;">
        <br> <span style="font-size: 1em;font-weight: bold;">Update Documents</span> 
        <?php
        $this->renderPartial('/fileInventory/_form_update', array('model' => $fileinventory));
        ?>
        <div class="clear"></div>    
    </div>

</div>
<?php 
}
?>
<div class="clear"></div>
<div class="view">
    <h3>Sub Jobs</h3>
    <?php
    $this->widget('zii.widgets.grid.CGridView', array(
        'id' => 'job-artwork-subjob-grid',
        'dataProvider' => $artworksubjobs->search(),
        'filter' => null,
        'columns' => array(
            array(
                'name' => 'sortOrderVal',
                'type' => 'raw',
                'value' => 'CHtml::textField(JobArtworkSubjob::model()->sortOrderVal,$data->sortOrderVal,array("style"=>"width:85%;", "id"=>"sortOrderVal_" . $data->id,"onchange"=>"subjobupdate($data->id,\'sortOrderVal\');"))',
                'htmlOptions' => array('style' => 'width:8%;')
            ),
            array(
                'name' => 'subjob.jobCategory',
            //'value' => '$data->subjob->name',
            ),
            array(
                'name' => 'subArtworkJobId',
                'value' => '$data->subjob->name',
            ),
            //'jobArtworkId',
            array(
                'name' => 'note',
                'type' => 'raw',
                'value' => 'CHtml::textField(JobArtworkSubjob::model()->note,$data->note,array("style"=>"width:98%;", "id"=>"note_" . $data->id,"onchange"=>"subjobupdate($data->id,\'note\');"))',
                'htmlOptions' => array('style' => 'width:25%;')
            ),
            array(
                'name' => 'statusId',
                'type' => 'raw',
                //'value'=>'$data->RelStatus->name',
                'value' => 'CHtml::dropDownList(JobArtworkSubjob::model()->statusId,$data->RelStatus->id, Chtml::listData(Status::model()->findAll(array("condition"=>"id in (1,4,10,11,17,18,19,22,23)","order"=>"name asc")), "id", "name"),array("empty"=>"Select", "id"=>"statusId_" . $data->id, "onchange"=>"subjobupdate($data->id,\'statusId\');"))',
            //'htmlOptions'=>array('style'=>'width:45%;')
            ),
            array(
                'name' => 'statusDate',
                'value' => 'date("Y-m-d H:i:s",strtotime($data->statusDate))'
            ),
            array(
                'name' => 'dueDate',
                'value' => 'date("Y-m-d",strtotime($data->dueDate))'
            ),
            array(
                'class' => 'CButtonColumn',
                'template' => '{delete}',
                'buttons' => array(
                    'delete' => array
                        (
                        'label' => 'Delete',
                        'imageUrl' => false,
                        'url' => 'Yii::app()->createUrl("jobArtworkSubjob/delete", array("id"=>$data->id))',
                    ),
                ),
            ),
        ),
    ));
    ?>
    <div class="clear"></div>
    <div style="color: lightgreen;">All changes are saved automatically when change values.</div>
</div>
<div class="clear"></div>
<?php 
if(Yii::app()->user->checkAccess("JobArtwork.AddSubJobs")){
?>
<div class="view">
    <h3>Add Sub Jobs</h3>
    <?php
    Yii::app()->clientScript->registerScript('tr-event-propagation', '$("#sub-artwork-job-grid tr").click(function(event){
    event.stopPropagation();
});');

    $form = $this->beginWidget('CActiveForm', array(
        'id' => 'add-sub-job-form',
        'enableAjaxValidation' => false,
    ));
    echo $form->textField($model, 'id', array('style' => 'display:none;'));
    $this->widget('zii.widgets.grid.CGridView', array(
        'id' => 'sub-artwork-job-grid',
        'dataProvider' => $subjobs->search(),
        'filter' => $subjobs,
        'selectableRows' => 100,
        'columns' => array(
            array(
                'class' => 'CCheckBoxColumn',
            ),
            array(
                'name' => 'jobCategory',
                'filter' => false,
            ),
            array(
                'name' => 'productCategory',
                'filter' => false,
            ),
            array(
                'name' => 'name',
                'filter' => false,
            ),
            array(
                'name' => 'dueDate',
                'value' => function ($data, $row, $column) {
                    $controller = $column->grid->owner;
                    $controller->widget('application.extensions.CJuiDateTimePicker.CJuiDateTimePicker', array(
                        'model' => new SubArtworkJob(), //Model object
                        'attribute' => 'dueDate', //attribute name
                        'mode' => 'date', //use "time","date" or "datetime" (default)
                        'options' => array("dateFormat" => 'yy-mm-dd', "changeMonth" => 'true', 'changeYear' => 'true'), // jquery plugin options
                        'htmlOptions' => array('id' => 'dueDate_' . $data->id, 'value' => $data->dueDate, 'name' => "SubArtworkJob[dueDate][$data->id]", "style" => "width:95%;"),
                        'language' => 'en-GB'
                    ));
                },
                'htmlOptions' => array('style' => 'width:25%;'),
                'filter' => false,
            ),
        ),
    ));
    ?>
    <div class="clear"></div>
    <?php echo CHtml::submitButton('Add', array('style' => "float:right;", 'onclick' => "checkDueDate();return false;")); ?>
    <div class="clear"></div>
    <?php $this->endWidget(); ?>
</div>

<?php 
}
?>


<div class="clear"></div>
<?php 
if(Yii::app()->user->checkAccess('SalesLog.Log')){
?>
<div class="view">
    <br> <span style="font-size: 1em;font-weight: bold;">CRM</span>   
    <div style="display: inline;float: right;" ><img id="sales-contact-div-fold" src="images/less_details.png" style="width: 20px;height: 20px;cursor: pointer;" onclick="hide('sales-contact-div');"/></div>

    <div id="sales-contact-div">


        <?php
        $salesLog = new SalesLog();
        $salesLog->tbl_id = $model->id;
        $salesLog->category = 'JobArtwork';

        $this->renderPartial('/salesLog/_crmgrid', array('salesLog' => $salesLog));
        ?>    


        <span style="font-size: 1em;font-weight: bold;">Add CRM</span>  <br> 
        <div class="form">

            <?php
            $this->renderPartial('/salesLog/_crmform', array('salesLog' => $salesLog));
            ?>
            <div class="clear"></div>
        </div>
    </div>
</div>
<?php 
}
?>
<div class="clear"></div>
<?php 
if(Yii::app()->user->checkAccess('SignOffLog.Log')){
?>
<div class="view">
    <br> <span style="font-size: 1em;font-weight: bold;">Sign Off Terms</span>   
    <?php
    $signofflog = new SignOffLog();
    $signofflog->model = 'JobArtwork';
    $signofflog->model_id = $model->id;

    $this->renderPartial('/signOffLog/_admin', array('signoffLog' => $signofflog));
    ?>    



    <div class="view">
        <span style="font-size: 1em;font-weight: bold;">Add Sign Off Term</span>  <br> 
        <?php
        $this->renderPartial('/signOffLog/_inc_form', array('signoffLog' => $signofflog));
        ?>
        <div class="clear"></div>
    </div>



    <div class="clear"></div>
</div>
<?php 
}
?>
<div class="clear"></div>
<div>
    <?php
//begin send to approve
    if(Yii::app()->user->checkAccess('JobArtwork.ClientApproval')){
    echo '<div class="view">';
    $form = $this->beginWidget('CActiveForm', array(
        'id' => 'job-artwork-form',
        'enableAjaxValidation' => false,
        'htmlOptions' => array('enctype' => 'multipart/form-data'),
        'action' => Yii::app()->createUrl('jobArtwork/clientApproval'),
    ));
    echo $form->textField($model, 'id', array('style' => 'display:none;'));

    echo CHtml::submitButton('Go', array('style' => 'margin-left:5px;background-color:#CC3300;float:right;', 'name' => 'manual_appr_btn'));
    echo $form->dropDownList($model, 'approve_status_id', CHtml::listData(Status::model()->findAll('id in(22,23)'), 'id', 'name'), array('empty' => 'Select Approval Type', 'style' => 'float:right;', 'onchange' => 'showRejectionNote();'));

    echo '<div class="clear"></div>';
    echo '<div style="display:none;" id="rejection_note_div">';
    echo $form->labelEx($model, 'rejectionNote', array('style' => 'float:left;'));
    echo $form->textArea($model, 'rejectionNote', array('style' => 'width:750px;height:100px; float:right;'));
    echo '</div>';
    
    echo '<div class="clear"></div>';

    echo '</div>';
    $this->endWidget();
    }
//end of sent to approve
    echo '<div class="clear"></div>';

    if ($model->jobType == JobArtwork::JOB_TYPE_USE_EXIST)
        echo CHtml::button('Do As Internal Job', array('onclick' => "doasinternalJob($model->id)", 'style' => 'float: left;', 'disabled'=>!Yii::app()->user->checkAccess('JobArtwork.DoAsInternalJob')));

    if (empty($model->po_id))
        echo CHtml::button('Purchase Artwork', array('onclick' => "purchaseArtwork($model->id)", 'style' => 'float: left;', 'disabled'=>!Yii::app()->user->checkAccess('PurchaseOrders.PurchaseArtwork')));




    echo CHtml::button('Print PDF', array('onclick' => "printPDF($model->id)", 'style' => 'float: right;', 'disabled'=>!Yii::app()->user->checkAccess('JobArtwork.Print')));
    if ($model->job_status_id != 22 && $model->approve_status_id != 22)
        echo CHtml::button('Send to Approve', array('onclick' => "sendToApprove($model->id,'ArtworkApp')", 'style' => 'float: right;', 'disabled'=>!Yii::app()->user->checkAccess('Emails.Create')));
    if (!in_array($model->job_status_id, array(3, 4)) && !in_array($model->approve_status_id, array(4, 22))) {
        $accessurl = Yii::app()->createUrl('jobArtwork/sendCustomerApproval', array('id' => $model->id));
        echo CHtml::button('Send E-mail for Approval', array('onclick' => "sendToCusApprove($model->id,'AwCusApp')", 'style' => 'float:right;', 'disabled'=>!Yii::app()->user->checkAccess('Emails.Create')));
    }
    ?>
</div>


<script>

        function checkDueDate() {

            var checkedcount = 0;
            var validdatecount = 0;
            var r = /^(\d{4})\-(\d{2})\-(\d{2})$/;
            $('#sub-artwork-job-grid table tbody tr').each(function(index, element) {
                var dateval = $(this).children('td:last-child').children('input').val();
                if (($(this).children('td:first-child').children('input[type=checkbox]').is(':checked') === true)) {
                    checkedcount++;
                    if (r.test(dateval))
                        validdatecount++;
                }

            });

            if (checkedcount === 0) {
                postSubJobs();
            } else if (checkedcount !== 0 && validdatecount !== 0 && (checkedcount === validdatecount)) {
                postSubJobs();
            } else {
                alert('Date format not valid!');
            }
            ;
        }

        function postSubJobs() {
            var fd = new FormData($("#add-sub-job-form")[0]);

            $.ajax({
                url: '<?php echo Yii::app()->createUrl("jobArtwork/addSubJobs"); ?>',
                type: 'POST',
                data: fd,
                //datatype: 'json',
                // async: false,
                beforeSend: function() {
                    // do some loading options
                },
                success: function(result) {

                    $.fn.yiiGridView.update("job-artwork-subjob-grid");
                    $.fn.yiiGridView.update("sales-log-grid");


                },
                complete: function() {
                    // success alerts
                },
                error: function(data) {
                    alert("There may a error on saving. Try again later");
                },
                cache: false,
                contentType: false,
                processData: false
            });

            return false;
        }

        function subjobupdate(id, field) {
            var value = $('#' + field + '_' + id).val();

            $.ajax({
                type: 'POST',
                url: '<?php echo Yii::app()->createUrl("jobArtworkSubjob/updateField"); ?>',
                data: {'id': id, 'field': field, 'value': value},
                dataType: 'json',
                success: function(result) {

                    $.fn.yiiGridView.update("sales-log-grid");
                    $.fn.yiiGridView.update("job-artwork-subjob-grid");
                },
                error: function(result) {
                    alert('error in update');
                }
            });
        }

        function doasinternalJob(id) {
            window.location.href = 'index.php?r=jobArtwork/doAsInternalJob&id=' + id;
        }

        function purchaseArtwork(id) {
            window.location.href = 'index.php?r=purchaseOrders/purchaseArtwork&id=' + id;
        }

        function printPDF(id) {
            var win = window.open('index.php?r=jobArtwork/print&id=' + id);
        }

        function sendToApprove(id, emailtype) {

            var win = window.open('index.php?r=emails/create&id=' + id + '&type=' + emailtype);
        }

        function sendToCusApprove(id, emailtype) {

            var win = window.open('index.php?r=emails/create&id=' + id + '&type=' + emailtype);
        }

        function showRejectionNote() {
            if ($('#JobArtwork_approve_status_id').val() == '23') {
                $('#rejection_note_div').slideDown(300);
            } else {
                $('#rejection_note_div').slideUp(300);
            }
        }
</script>


