<?php
$pomenue = null;
$jobdonemenu = null;
$backtojob = null;
$updatemenu = null;
$cancelmenu = null;
$manageartworkmenu = null;

if (!empty($model->po_id) && Yii::app()->user->checkAccess("PurchaseOrders.View")) {
    $po = PurchaseOrders::model()->findByPk($model->po_id);
    if (!empty($po)) {
        $pomenue = array('label' => $po->poNum, 'url' => array('purchaseOrders/view', 'id' => $po->id));
    }
}

if (!in_array($model->job_status_id, array(3, 11)) && Yii::app()->user->checkAccess("JobArtwork.Done")) {
    $jobdonemenu = array('label' => 'Job Done', 'url' => array('done', 'id' => $model->id));
}

if(Yii::app()->user->checkAccess('Jobs.Admin')){
    $backtojob = array('label' => 'Back to : ' . $model->job->jobNum, 'url' => array('jobs/view', 'id' => $model->job->id));
}


if(Yii::app()->user->checkAccess("JobArtwork.Update")){
    $updatemenu = array('label' => 'Update', 'url' => array('update', 'id' => $model->id));
}

if(Yii::app()->user->checkAccess("JobArtwork.Cancel")){
    $cancelmenu = array('label' => 'Cancel', 'url' => '#', 'linkOptions' => array('style' => 'background-color:#CC3300', 'submit' => array('delete', 'id' => $model->id), 'confirm' => 'Are you sure you want to delete this item?'));
    
}

if(Yii::app()->user->checkAccess("JobArtwork.Admin")){
    $manageartworkmenu =  array('label' => 'Manage Artwork Job', 'url' => array('admin'));
}

$this->menu = array(
    $backtojob,
    $pomenue,
    $updatemenu,
    $jobdonemenu,
    $cancelmenu,
   $manageartworkmenu,
);
?>

<h1>View Artwork Job #<?php echo $model->artworkjobNum; ?></h1>
<?php
foreach (Yii::app()->user->getFlashes() as $key => $message) {
    echo '<div class="flash-' . $key . '">' . $message . "</div>\n";
}

if (isset($_GET['send']) && $_GET['send'] == 1) {
    echo '<div style="color:#00ff00;font-weight:bold;font-size:1.2em;">Confirmation email has been sent to customer</div>';
} else if (isset($_GET['send']) && $_GET['send'] == 0) {
    echo '<div style="color:#ff0000;font-weight:bold;font-size:1.2em;">Confirmation email sending to customer is failed.</div>';
}
?>
<div class="view">
    <div style="width: 100%;float: left;">
        <p style="font-size: 1.2em; font-weight: bold;">Artwork Main Details</p>
        <?php
        $this->widget('zii.widgets.CDetailView', array(
            'data' => $model,
            'attributes' => array(
                'id',
                array(
                    'label' => 'Name',
                    'value' => $model->job->workorder->getCustomerLink(),
                    'type' => 'raw',
                ),
                'productColor',
                //'archiveImageLogo',
                'decorationType',
                'decorationPosition',
                'logoName',
                'printSize',
                'printColor',
                'designNumber',
                'isRepeatDesign',
                'comments',
                'signOffTerms',
                'jobType',
                array(
                    'name' => 'followupDate',
                    'value' => date(GlobalVars::get("DateFormat"), strtotime($model->followupDate)),
                ),
                array(
                    'name' => 'dueDate',
                    'value' => date(GlobalVars::get("DateFormat"), strtotime($model->dueDate)),
                ),
                array(
                    'name' => 'job_status_id',
                    'value' => Status::getStatusName($model->job_status_id),
                ),
                array(
                    'name' => 'approve_status_id',
                    'value' => Status::getStatusName($model->approve_status_id),
                ),
                'createdDate',
                'approveDate',
                'jobPriority'
            ),
        ));
        ?>
    </div>   
    
    <div class="clear"></div>
</div>

<div class="view">
        <?php include '_proofs.php'; ?>
   
</div>
<div class="view">
    <?php include '_online_artwork_accept_log_section.php'; ?>
</div>

<div class="clear"></div>

<div class="view">
    <br> <span style="font-size: 1em;font-weight: bold;">CRM</span>   
    <div style="display: inline;float: right;" ><img id="sales-contact-div-fold" src="images/less_details.png" style="width: 20px;height: 20px;cursor: pointer;" onclick="hide('sales-contact-div');"/></div>

    <div id="sales-contact-div">


        <?php
        $salesLog = new SalesLog();
        $salesLog->tbl_id = $model->id;
        $salesLog->category = 'JobArtwork';

        $this->renderPartial('/salesLog/_crmgrid', array('salesLog' => $salesLog));
        ?>    


        <span style="font-size: 1em;font-weight: bold;">Add CRM</span>  <br> 
        <div class="form">

            <?php
            $this->renderPartial('/salesLog/_crmform', array('salesLog' => $salesLog));
            ?>
            <div class="clear"></div>
        </div>
    </div>
</div>

<div class="clear"></div>
<?php 
if(Yii::app()->user->checkAccess('SignOffLog.Log')){
?>
<div class="view">
    <br> <span style="font-size: 1em;font-weight: bold;">Sign Off Terms</span>   
    <?php
    $signofflog = new SignOffLog();
    $signofflog->model = 'JobArtwork';
    $signofflog->model_id = $model->id;

    $this->renderPartial('/signOffLog/_admin', array('signoffLog' => $signofflog));
    ?>    



    <div class="view">
        <span style="font-size: 1em;font-weight: bold;">Add Sign Off Term</span>  <br> 
        <?php
        $this->renderPartial('/signOffLog/_inc_form', array('signoffLog' => $signofflog));
        ?>
        <div class="clear"></div>
    </div>



    <div class="clear"></div>
</div>
<?php 
}
?>
<div class="clear"></div>
<div>
    <?php
//begin send to approve
    if(Yii::app()->user->checkAccess('JobArtwork.ClientApproval')){
    echo '<div class="view">';
    $form = $this->beginWidget('CActiveForm', array(
        'id' => 'job-artwork-form',
        'enableAjaxValidation' => false,
        'htmlOptions' => array('enctype' => 'multipart/form-data'),
        'action' => Yii::app()->createUrl('jobArtwork/clientApproval'),
    ));
    echo $form->textField($model, 'id', array('style' => 'display:none;'));

    echo CHtml::submitButton('Go', array('style' => 'margin-left:5px;background-color:#CC3300;float:right;', 'name' => 'manual_appr_btn'));    
    echo $form->dropDownList($model, 'approve_status_id', CHtml::listData(Status::model()->findAll('id in(22,23)'), 'id', 'name'), array('empty' => 'Select Approval Type', 'style' => 'float:right;', 'onchange' => 'showRejectionNote();'));
    echo '<span>Manual Approval&nbsp;</span>';
    echo '<div class="clear"></div>';
    echo '<div style="display:none;" id="rejection_note_div">';
    echo $form->labelEx($model, 'rejectionNote', array('style' => 'float:left;'));
    echo $form->textArea($model, 'rejectionNote', array('style' => 'width:750px;height:100px; float:right;'));
    echo '</div>';
    
    echo '<div class="clear"></div>';

    echo '</div>';
    $this->endWidget();
    }
//end of sent to approve
    echo '<div class="clear"></div>';

    if ($model->jobType == JobArtwork::JOB_TYPE_USE_EXIST)
        echo CHtml::button('Do As Internal Job', array('onclick' => "doasinternalJob($model->id)", 'style' => 'float: left;', 'disabled'=>!Yii::app()->user->checkAccess('JobArtwork.DoAsInternalJob')));

    if (empty($model->po_id))
        echo CHtml::button('Purchase Artwork', array('onclick' => "purchaseArtwork($model->id)", 'style' => 'float: left;', 'disabled'=>!Yii::app()->user->checkAccess('PurchaseOrders.PurchaseArtwork')));




    echo CHtml::button('Print PDF', array('onclick' => "printPDF($model->id)", 'style' => 'float: right;', 'disabled'=>!Yii::app()->user->checkAccess('JobArtwork.Print')));
    if ($model->job_status_id != 22 && $model->approve_status_id != 22)
        echo CHtml::button('Send to Approve', array('onclick' => "sendToApprove($model->id,'ArtworkApp')", 'style' => 'float: right;', 'disabled'=>!Yii::app()->user->checkAccess('Emails.Create')));
    if (!in_array($model->job_status_id, array(3, 4)) && !in_array($model->approve_status_id, array(4, 22))) {
        $accessurl = Yii::app()->createUrl('jobArtwork/sendCustomerApproval', array('id' => $model->id));
        echo CHtml::button('Send E-mail for Approval', array('onclick' => "sendToCusApprove($model->id,'AwCusApp')", 'style' => 'float:right;', 'disabled'=>!Yii::app()->user->checkAccess('Emails.Create')));
    }
    ?>
</div>


<script>

        function checkDueDate() {

            var checkedcount = 0;
            var validdatecount = 0;
            var r = /^(\d{4})\-(\d{2})\-(\d{2})$/;
            $('#sub-artwork-job-grid table tbody tr').each(function(index, element) {
                var dateval = $(this).children('td:last-child').children('input').val();
                if (($(this).children('td:first-child').children('input[type=checkbox]').is(':checked') === true)) {
                    checkedcount++;
                    if (r.test(dateval))
                        validdatecount++;
                }

            });

            if (checkedcount === 0) {
                postSubJobs();
            } else if (checkedcount !== 0 && validdatecount !== 0 && (checkedcount === validdatecount)) {
                postSubJobs();
            } else {
                alert('Date format not valid!');
            }
            ;
        }

        function postSubJobs() {
            var fd = new FormData($("#add-sub-job-form")[0]);

            $.ajax({
                url: '<?php echo Yii::app()->createUrl("jobArtwork/addSubJobs"); ?>',
                type: 'POST',
                data: fd,
                //datatype: 'json',
                // async: false,
                beforeSend: function() {
                    // do some loading options
                },
                success: function(result) {

                    $.fn.yiiGridView.update("job-artwork-subjob-grid");
                    $.fn.yiiGridView.update("sales-log-grid");


                },
                complete: function() {
                    // success alerts
                },
                error: function(data) {
                    alert("There may a error on saving. Try again later");
                },
                cache: false,
                contentType: false,
                processData: false
            });

            return false;
        }

        function subjobupdate(id, field) {
            var value = $('#' + field + '_' + id).val();

            $.ajax({
                type: 'POST',
                url: '<?php echo Yii::app()->createUrl("jobArtworkSubjob/updateField"); ?>',
                data: {'id': id, 'field': field, 'value': value},
                dataType: 'json',
                success: function(result) {

                    $.fn.yiiGridView.update("sales-log-grid");
                    $.fn.yiiGridView.update("job-artwork-subjob-grid");
                },
                error: function(result) {
                    alert('error in update');
                }
            });
        }

        function doasinternalJob(id) {
            window.location.href = 'index.php?r=jobArtwork/doAsInternalJob&id=' + id;
        }

        function purchaseArtwork(id) {
            window.location.href = 'index.php?r=purchaseOrders/purchaseArtwork&id=' + id;
        }

        function printPDF(id) {
            var win = window.open('index.php?r=jobArtwork/print&id=' + id);
        }

        function sendToApprove(id, emailtype) {

            var win = window.open('index.php?r=emails/create&id=' + id + '&type=' + emailtype);
        }

        function sendToCusApprove(id, emailtype) {

            var win = window.open('index.php?r=emails/create&id=' + id + '&type=' + emailtype);
        }

        function showRejectionNote() {
            if ($('#JobArtwork_approve_status_id').val() == '23') {
                $('#rejection_note_div').slideDown(300);
            } else {
                $('#rejection_note_div').slideUp(300);
            }
        }
</script>


