<h1>Online Artwork Acceptance : <?php echo $artwork->artworkjobNum; ?> </h1>

<div class="order-template view">
	<div style="float: right">
		<?php
		echo CHtml::button('Accept', array('class' => 'acceptopt', 'onclick' => 'return false;', 'accepttype' => JobArtworkOnlineAcceptenceLog::LOG_STATUS_ACCEPT, 'acceptext' => 'ACCEPT'));
		echo CHtml::button('Decline', array('class' => 'acceptopt', 'style' => 'background-color:#CC3300;', 'onclick' => 'return false;', 'accepttype' => JobArtworkOnlineAcceptenceLog::LOG_STATUS_DECLINE, 'acceptext' => 'DECLINE'));

		?>
	</div>
	<div class="clear"></div>
	<?php

	echo $artwork_template;
	?>
</div>
<div class="order-acceptane-response-success" style="border: 1px solid greenyellow;padding: 10px;text-align: center;display: none;margin-top: 2%;">
	<h3 class="success-response-message">&nbsp;</h3>
	<h4>Thank you for your response. Our sales team will be notified and respond accordingly.</h4>
</div>
<div class="order-acceptane-response-error" style="border: 1px solid #EE5757;padding: 10px;color: #CC3300;text-align: center;display: none;margin-top: 2%;">
	<h3>Online Artwork acceptance is failed!</h3>
	<h4>&nbsp;</h4>
</div>
<input type="hidden" id="order-acceptance-seceret" value="<?php echo $artwork->onlineAcceptenceLog->link_secret; ?>" />
<script src="https://cdnjs.cloudflare.com/ajax/libs/bootbox.js/5.4.0/bootbox.min.js"></script>
<script type="text/javascript">
	$(document).on('click', '.acceptopt', function() {
		acceptPrompt({
			accepttype: $(this).attr('accepttype'),
			'acceptext': $(this).attr('acceptext')
		});
	});

	function validateAcceptence(promtObj) {
		promtObj.validationError = "";
		var selected = [];
		$('#artwork-accept-form input:checked').each(function() {
			selected.push($(this).attr('name'));
		});

		//validation only be applied when going to accept the quote
		if (promtObj.acceptext == 'ACCEPT') {
			if (selected.length > 0) {
				return true;
			} else {
				promtObj.validationError = "Please select at least one artwork proof and then 'Accept' the Artwork";
				return false;
			}
		} else {
			return true;
		}



	}

	function acceptPrompt(promtObj) {

		if (validateAcceptence(promtObj)) {

			bootbox.prompt({
				title: "Online Artwork Acceptance!",
				message: '<h4>You are going to <b>' + promtObj.acceptext + '</b> the artwork.</h4><p>Please enter your comment here: <span style="color:#CC3300;">Comment required!</span></p>',
				inputType: 'textarea',
				callback: function(result) {
					if ($.trim(result)) {
						var linkSecret = $('#order-acceptance-seceret').val();
						acceptanceSubmit({
							accepttype: promtObj.accepttype,
							linkSecret: linkSecret,
							comment: result
						});

					}

				}
			});
		} else {
			
			bootbox.alert({
				message: promtObj.validationError,
				size: 'small'
			});
		}
	}

	function acceptanceSubmit(acceptanceObj) {

		//Get acceptance form obj
        //form form artwork_template.php
        var formData = $('#artwork-accept-form').serialize();
        acceptanceObj.formData = formData;
        console.log(formData);

		$.ajax({
			type: 'POST',
			url: '<?php echo Yii::app()->createUrl("jobArtworkOnlineAcceptence/onlineAccept"); ?>',
			data: acceptanceObj,
			dataType: 'json',
			success: function(result) {
				handleAcceptenceResponce(result);
			},
			error: function(result) {
				var response = {};
				response.status = 0;
				response.message = 'Some error has been occured during the acceptance process! Please try again later';
				handleAcceptenceResponce(response);
			}
		});
	}

	function handleAcceptenceResponce(response) {
		$('.success-response-message').text('');
		$('.order-template').fadeOut(500);
		if (response.status) {
			$('.success-response-message').text(response.message);
			$('.order-acceptane-response-success').fadeIn(1000);
		} else {
			$('.order-acceptane-response-error h4').html(response.message);
			$('.order-acceptane-response-error').fadeIn(1000);
		}
	}
</script>