<div class="view">
    <h3>Original Product-Decoration Details</h3>
    <?php
    $this->widget('zii.widgets.CDetailView', array(
        'data' => $orginmodel,
        'attributes' => array(
            'id',
            'job.quoteNum',
            'job.jobNum',
            'job.workorder.salesorderNumber',
            array(
                'name' => 'workorderDtl.image',
                'type' => 'raw',
                'value' => CHtml::image($orginmodel->workorderDtl->getImg(), '', array('style' => 'width:100px;')),
            //'htmlOptions' => array('style' => 'width:100px;'),
            ),
            array(
                'name' => 'workorderDtl.productsku',
                'value' => !empty($orginmodel->workorderDtl->productsku) ? $orginmodel->workorderDtl->prdsrtdesc . $orginmodel->workorderDtl->getProdSupplierLink() : $orginmodel->workorderDtl->custmproduct . $orginmodel->workorderDtl->getProdSupplierLink(),
                'type' => 'raw',
            ),
            array(
                'name' => 'workorderDtl.prdlngdesc',
                'type' => 'raw',
                'htmlOptions' => array('style' => 'width:200px;'),
                'value' => $orginmodel->workorderDtl->prdlngdesc . $orginmodel->workorderDtl->getSizeQtyColorTable(),
            ),
            array(
                'name' => 'decprtnam',
                'type' => 'raw',
                'value' => $orginmodel->getProductDecorationRaw(),
            ),
            array(
                'name' => 'decoCostPrice',
                'htmlOptions' => array('style' => 'text-align:center'),
            ),
            array(
                'name' => 'decoQty',
                'htmlOptions' => array('style' => 'text-align:center'),
            ),
        ),
    ));
    ?>
    
</div>

<h3>Edit & Create a Copy of Product-Decoration</h3>
<div class="view">


    <div class="form">

        <?php
        $form = $this->beginWidget('CActiveForm', array(
            'id' => 'job-product-decorations-form',
            'enableAjaxValidation' => false,
        ));
        ?>

        <p class="note">Fields with <span class="required">*</span> are required.</p>

        <?php echo $form->errorSummary($model); ?>

        <div class="row">
            <?php echo $form->labelEx($model, 'decprtnam'); ?>
            <?php
            echo $form->dropDownList($model, 'decprtnam', 
                    CHtml::listData(Decoration::model()->findAll(array('condition' => "decprtnam <> decnam and decprtnam <> 'N/A' ")), 'decprtnam', 'decnam'), 
                    array('empty' => '', 'readonly' => true));
            ?>
            <?php echo $form->error($model, 'decprtnam'); ?>
        </div>


        <div class="row">       

            <?php echo $form->labelEx($model, 'decdesc'); ?>
            <?php echo $form->textArea($model, 'decdesc', array('rows' => 3, 'style' => 'width:350px;')); ?>
            <?php echo $form->error($model, 'decdesc'); ?>
        </div>  
        <div class="clear"></div>
        <div class="row">
            <?php echo $form->labelEx($model, 'decoQty'); ?>
            <?php echo $form->textField($model, 'decoQty', array('value' => $orginmodel->decoQty)); ?>
            <?php echo $form->error($model, 'decoQty'); ?>
        </div>
        <div class="row">
            <?php echo $form->labelEx($model, 'decoCostPrice'); ?>
            <?php echo $form->textField($model, 'decoCostPrice'); ?>
            <?php echo $form->error($model, 'decoCostPrice'); ?>
        </div>

        <div class="row">
            <?php echo $form->labelEx($model, 'decosupref'); ?>
            <?php echo $form->dropDownList($model, 'decosupref', CHtml::listData(Supplier::model()->findAll(), 'supsup_fref', 'supnam'), array('empty' => '')); ?>
            <?php echo $form->error($model, 'decosupref'); ?>
        </div>



        <div class="row">
            <?php echo $form->labelEx($model, 'customizationDetails'); ?>
            <?php echo $form->textArea($model, 'customizationDetails', array('rows' => 2, 'cols' => 5)); ?>
            <?php echo $form->error($model, 'customizationDetails'); ?>
        </div>

        <div class="row buttons">
            <?php
            echo $form->textField($model, 'job_id', array('style' => 'display:none;'));
            echo $form->textField($model, 'workorderDtl_id', array('style' => 'display:none;'));
            echo CHtml::submitButton($model->isNewRecord ? 'Create' : 'Save');
            ?>
        </div>

        <?php $this->endWidget(); ?>

    </div><!-- form -->
    <div class="clear"></div>
</div>

<script>
    $("#JobProductDecorations_decprtnam").change(function() {

        $.ajax({
            type: "POST",
            url: '<?php echo Yii::app()->createUrl("workorderdetails/filterDecoration"); ?>',
            data: {'decprtnam': this.value},
            dataType: 'json',
            success: function(data) {
                //alert(data);
                $("#JobProductDecorations_decdesc").val(data.decorateDesc);



            },
            error: function(data) {
                alert('error');
            },
        });

    });


    $('#JobProductDecorations_decprtnam').change(function(event) {

        if ($(this).val().length > 0) {
            $('#JobProductDecorations_customdecoration').prop("disabled", true);
        } else {
            $('#JobProductDecorations_customdecoration').prop("disabled", false);
        }

    });


    $('#JobProductDecorations_customdecoration').keyup(function(event) {

        if ($(this).val().length > 0) {
            $('#JobProductDecorations_decprtnam').prop("disabled", true);
        } else {
            $('#JobProductDecorations_decprtnam').prop("disabled", false);
        }

    });
</script>