<span class="pull right" data-xero-sso data-href="<?= Yii::app()->createUrl("xeroSetting/authorization"); ?>" data-label="Sign in with Xero"></span>
<br />
<script src="https://edge.xero.com/platform/sso/xero-sso.js" async defer></script>
<?php
$jobmenu = null;
$jobclosemenu = null;

if (isset(Yii::app()->session['job'])) {
    $job = Jobs::model()->findByPk(Yii::app()->session['job']);
    $jobmenu = array('label' => 'Back to : ' . $job->jobNum, 'url' => array('jobs/view', 'id' => $job->id));
}

if (!empty($jobmenu)) {
    $jobclosemenu = array('label' => 'Close Job Session', 'url' => array('jobs/closesession'));
}
$jobinfocusmenu = null;
if (isset(Yii::app()->session['job_in_focus_id'])) {
    $jobinfocusmenu = array('label' => 'JOB IN FOCUS', 'url' => array('jobs/jobFlow'), 'linkOptions' => array('style' => 'background-color:orange;'));
}
$this->menu = array(
    $jobinfocusmenu,
    $jobmenu,
    $jobclosemenu,
    array('label' => 'Create Job', 'url' => '#', 'linkOptions' => array('style' => 'background-color:#CC3300', 'onclick' =>  'startDummyJob();return false;')),
    array('label' => 'Job Dashboard', 'url' => array('jobs/dashboard'))
);

Yii::app()->clientScript->registerScript('search', "
$('.search-button').click(function(){
	$('.search-form').toggle();
	return false;
});
$('.search-form form').submit(function(){
	$.fn.yiiGridView.update('jobs-grid', {
		data: $(this).serialize()
	});
	return false;
});
");
?>

<h1>
    Manage Jobs&nbsp;
    <?php
    if (isset($_GET['pastdue']) && $_GET['pastdue'] == 1)
        echo '[ PAST DUE DATE ]';
    if (isset($_GET['urgent']) && $_GET['urgent'] == 1)
        echo '[ URGENT ]';
    if (isset($_GET['newjb']) && $_GET['newjb'] == 1)
        echo '[ NEW ]';
    if (isset($_GET['prgjb']) && $_GET['prgjb'] == 1)
        echo '[ IN PROGRESS ]';
    if (isset($_GET['totout']) && $_GET['totout'] == 1)
        echo '[ OUTSTANDINGS ]';
    if (isset($_GET['xnameprd']) && $_GET['xnameprd'] == 1)
        echo '[ OFFSHORE PRODUCTION ]';
    ?>
</h1>


<div>
    <?php
    foreach (Yii::app()->user->getFlashes() as $key => $message) {
        echo '<div class="flash-' . $key . '">' . $message . "</div>\n";
    }
    ?>
</div>
<p id="json-message" style="color:coral;">&nbsp;</p>
<?php echo CHtml::link('Advanced Search', '#', array('class' => 'search-button')); ?>
<div class="search-form" style="display:none">
<p>
    You may optionally enter a comparison operator (<b>&lt;</b>, <b>&lt;=</b>, <b>&gt;</b>, <b>&gt;=</b>, <b>&lt;&gt;</b>
    or <b>=</b>) at the beginning of each of your search values to specify how the comparison should be done.
</p>
    <?php
    $this->renderPartial('_search', array(
        'model' => $model,
    ));
    ?>
</div><!-- search-form -->

<?php
$form = $this->beginWidget('CActiveForm', array(
    'id' => 'jobs-option-selection-form',
    'enableAjaxValidation' => false,
));
?>

<div class="pull-right">
    <?php echo $form->labelEx($model, 'show_completed_jobs', array('style' => "display:inline;font-weight:bold;color:#cc0000;")); ?>
    <?php echo $form->checkBox($model, 'show_completed_jobs', array('style' => "display:inline;margin-left:5px;font-weight:bold;", 'onchange' => 'toggleJobOptionSelection();', 'checked' => Yii::app()->session['show_completed_jobs'])); ?>
    <?php echo $form->error($model, 'show_completed_jobs'); ?>
</div>
<div class="pull-right">&nbsp;&nbsp;|&nbsp;&nbsp;</div>
<div class="pull-right">
    <?php echo $form->labelEx($model, 'show_cancelled_jobs', array('style' => "display:inline;font-weight:bold;color:#cc0000;margin-left:5px;")); ?>
    <?php echo $form->checkBox($model, 'show_cancelled_jobs', array('style' => "display:inline;margin-left:5px;font-weight:bold;", 'onchange' => 'toggleJobOptionSelection();', 'checked' => Yii::app()->session['show_cancelled_jobs'])); ?>
    <?php echo $form->error($model, 'show_cancelled_jobs'); ?>
</div>

<?php echo CHtml::submitButton('Save', array('name' => 'btn-cmplt-sbmt', 'style' => 'display:none;')); ?>


<?php $this->endWidget(); ?>

<?php
$this->widget('zii.widgets.grid.CGridView', array(
    'id' => 'jobs-grid',
    'dataProvider' => $model->search(),
    'filter' => $model,
    //'rowCssClassExpression' => '( $data->urgent_status == 19 ? " red" : ( $row%2 ? $this->rowCssClass[1] : $this->rowCssClass[0] ) )',
    'columns' => array(
        //'id',        
        //'quote_id',
        array(
            'header' => 'No.',
            'value' => '$this->grid->dataProvider->pagination->currentPage * $this->grid->dataProvider->pagination->pageSize + ($row+1)',
        ),
        array(
            'name' => 'createdDtm',
            'value' => 'date(GlobalVars::get("DateFormat"),strtotime($data->createdDtm))'
        ),
        array(
            'name' => 'jobNum',
            'value' => '$data->getJobHtml()',
            'type' => 'raw',
            'htmlOptions' => array('style' => 'width:120px;text-align:center;'),
        ),
        'jobname',
        array(
            'name' => 'quoteNum',
            'value' => '$data->getQuoteNumLink()',
            'type' => 'raw',
        ),
        array(
            'name' => 'workorder_id',
            'value' => '$data->getSONumLink()',
            'type' => 'raw',
        ),
        array(
            'name' => 'mastercus_search',
            'value' => '$data->getMasterCustomerLink()',
            //'filter'=>CHtml::listData(MasterCustomer::model()->findAll(), 'mcussno', 'mcusnam'),
            'type' => 'raw',
        ),
        //        array(
        //            'name' => 'workorder.quotation.customer.cusmcussno',
        //            'value' => '$data->workorder->quotation->getMasterCustomerLink()',
        //            'type'=>'raw',
        //        ),
        //        array(
        //            'name'=>'workorder.quotation.customer.cusnam',
        //            'value'=>'$data->workorder->quotation->getCustomerLink()',
        //            'type'=>'raw',
        //        ),
        array(
            'name' => 'customer_search',
            'value' => '$data->getCustomerLink()',
            'type' => 'raw',
        ),
        array(
            'name' => 'ws_user',
            'value' => '$data->getSalespersonColumnmarkUp()',
            'type' => 'raw',
        ),
        //'createdDtm',
        array(
            'name' => 'followupStatus',
            'value' => '$data->getFollowupStatus()',
            'filter' => CHtml::listData(FollowupStatus::model()->findAll(array('condition' => "type = 'Job'", 'order' => 'status ASC')), 'id', 'status'),
            // 'type' => 'raw',
        ),
        array(
            'name' => 'urgent_status',
            'value' => '$data->getUrgentHtml()',
            'filter' => CHtml::listData(Status::model()->findAll(array('condition' => "id IN (19,20)")), 'id', 'name'),
            'type' => 'raw',
        ),
        /*
          'notation',
          'followupDate',
          'dueDate',
          'user_id',
          'status_id',
         */
        array(
            'class' => 'CButtonColumn',
            'template' => '{view}{sep1}{jobcomplete}{sep2}{processinv}{sep3}{viewinv}{sep4}{print}{sep5}{upsts}',
            'buttons' => array(
                'view' => array(
                    'label' => 'View',
                    'imageUrl' => false,
                    'visible' => 'Yii::app()->user->checkAccess("Jobs.View")',
                ),
                'sep1' => array(
                    'label' => ' | ',
                    'url' => '',
                    'imageUrl' => false,
                    'visible' => '(Yii::app()->user->checkAccess("Jobs.JobsComplete") &&  in_array($data->status_id, array(1,18)))',
                ),
                'jobcomplete' => array(
                    'label' => 'Job Complete',
                    'imageUrl' => false,
                    'url' => 'Yii::app()->createUrl("jobs/jobsComplete", array("id"=>$data->id))',
                    'visible' => '(Yii::app()->user->checkAccess("Jobs.JobsComplete") &&  in_array($data->status_id, array(1,18)))',
                ),
                'sep2' => array(
                    'label' => ' | ',
                    'url' => '',
                    'imageUrl' => false,
                    'visible' => '(Yii::app()->user->checkAccess("Invoice.Create") &&  $data->getInvoice() == null)',
                ),
                'processinv' => array(
                    'label' => 'Create Invoice',
                    'imageUrl' => false,
                    'url' => 'Yii::app()->createUrl("invoice/create", array("id"=>$data->id))',
                    'visible' => '(Yii::app()->user->checkAccess("Invoice.Create") &&  $data->getInvoice() == null)',
                ),
                'sep3' => array(
                    'label' => ' | ',
                    'url' => '',
                    'imageUrl' => false,
                    'visible' => '(Yii::app()->user->checkAccess("Invoice.View") &&  $data->getInvoice() != null)',
                ),
                'viewinv' => array(
                    'label' => 'View Invoice',
                    'imageUrl' => false,
                    'url' => 'Yii::app()->createUrl("invoice/view", array("id"=>$data->getInvoice()->id))',
                    'visible' => '(Yii::app()->user->checkAccess("Invoice.View") &&  $data->getInvoice() != null)',
                    'options' => array('target' => '_blank'),
                ),
                'sep4' => array(
                    'label' => ' | ',
                    'url' => '',
                    'imageUrl' => false,
                    'visible' => 'Yii::app()->user->checkAccess("Jobs.Print")',
                ),
                'print' => array(
                    'label' => 'Print PDF',
                    'imageUrl' => false,
                    'url' => 'Yii::app()->createUrl("jobs/print", array("id"=>$data->id))',
                    'options' => array('target' => '_blank'),
                    'visible' => 'Yii::app()->user->checkAccess("Jobs.Print")',
                ),
                'sep5' => array(
                    'label' => ' | ',
                    'url' => '',
                    'imageUrl' => false,
                ),
                'upsts' => array(
                    'label' => 'update status',
                    'imageUrl' => false,
                    'url' => 'Yii::app()->createUrl("#", array("id"=>$data->id,"onclick"=>"return false;"))',
                ),
            ),
        ),
    ),
));
?>
<div id="upstate" class="modal fade" role="dialog">
    <div class="modal-dialog">

        <!-- Modal content-->
        <div class="modal-content">
            <div class="modal-header">
                <button type="button" class="close" data-dismiss="modal">&times;</button>
                <h3 style="text-align: center;" class="modal-title">Update Follow-Up Status</h3>
            </div>
            <div class="modal-body">
                <div id="flup-seelct-container" style="display: table;margin:0 auto;">

                </div>
                <div id="component-loading-msg" style="display: table;margin:0 auto;"><img src="images/loading.gif" width="25" height="25" />&nbsp;Please wait!. Component loading...</div>


            </div>
            <div class="modal-footer">

            </div>
        </div>

    </div>
</div>

<div id="slctcusmodel" class="modal fade modal-dialog" role="dialog">

    <!-- Modal content-->
    <div class="modal-content">
        <div class="modal-header">

            <h3 style="text-align: center;">Select Customer</h3>
        </div>
        <div class="modal-body">
            <?php
            //$selectcustomers = new Customer();
            $this->renderPartial('/customer/_admin_grid', array('model' => $selectcustomers));
            ?>
        </div>
        <div class="modal-footer">
            <button type="button" class="btn btn-default" data-dismiss="modal" onclick="addCustomerToDummyJob();">Add</button>
            <button type="button" class="btn btn-default" data-dismiss="modal">Close</button>
        </div>
    </div>

</div>
<!--job customer selection  -->

<style>
    #slctcusmodel {
        width: 900px;

    }
</style>
<script>
    /**
     * Show customer selection grid to select customer to continue job creating process  
     * */
    function startDummyJob() {
        showcentermodel('slctcusmodel');
    }

    function showcentermodel(id) {
        $("#" + id).modal('show').css({
            'margin-top': function() {
                return -($(this).height() / 2);
            },
            'margin-left': function() {
                return -($(this).width() / 2);
            },
        })
    }

    function addCustomerToDummyJob() {
        let selectedCustomerArr = new Array();
        $.each($("input[name='customer-grid_c0[]']:checked"), function() {
            selectedCustomerArr.push($(this).val());
            
        });

        if (selectedCustomerArr.length > 0) {
            postCustomerToCreateDummyJob(selectedCustomerArr[0]);            
        }


    }

    function postCustomerToCreateDummyJob(customerId) {
        
        $.ajax({
            url: '<?php echo Yii::app()->createUrl("jobs/create"); ?>',
            type: 'POST',
            data: { 'customerId': customerId },
            datatype: 'json',
            success: function(result) {
                $.fn.yiiGridView.update("jobs-grid");
                 
                $('#json-message').empty();
                $('#json-message').html(result);
                
            },
            error: function(data) {
                $('#json-message').empty(data);
                $('#json-message').html(data);
            }
        });

        return false;
    }
</script>
<script>
    function toggleJobOptionSelection() {
        $("#jobs-option-selection-form").submit();
    }
</script>

<!-- Follow-up status changes JS codes -->
<script>
    $(document).on('click', '.button-column [title="update status"]', function() {
        const url = $(this).context.attributes['href'].value;
        // const id = url.searchParams.get("id");
        const urlParams = new URLSearchParams(url);

        const id = urlParams.get('id');
        showupstsPopUp(id);
        console.log(id);
        return false;

    });


    function showupstsPopUp(id) {
        $('#flup-seelct-container').empty();
        $('#component-loading-msg').show();
        $('#upstate').modal('show');
        loadFollowupUpdateModel(id);
    }


    function loadFollowupUpdateModel(id) {

        $.ajax({
            type: 'POST',
            url: '<?php echo Yii::app()->createUrl("jobs/loadFollowUpdateModel"); ?>',
            data: {
                'id': id
            },
            dataType: 'html',
            success: function(result) {
                $('#component-loading-msg').hide();
                $('#flup-seelct-container').empty();

                $('#flup-seelct-container').html(result);
                //$.fn.yiiGridView.update("sales-log-grid");


            },
            error: function(result) {
                $('#component-loading-msg').hide();
                $('#upstats-msg-error').show();
            }
        });

    }


    $(document).on('change', '#job-follow-up-update', function() {
        $('#upstats-msg').show();
        var jobId = $(this).attr('jobid');
        var stsId = $(this).val();
        updateFlwpStatus(jobId, stsId);
    });

    function updateFlwpStatus(jobId, flwupStsId) {
        var fd = new FormData($("#flwup-stsup-form")[0]);
        fd.append("Jobs[id]", jobId);
        fd.append("Jobs[followupStatus]", flwupStsId);

        $.ajax({
            type: 'POST',
            url: '<?php echo Yii::app()->createUrl("jobs/updateAjaxStatus"); ?>',
            data: fd,
            dataType: 'json',
            success: function(result) {
                if (result.success == 'true') {
                    $('#upstats-msg').hide();
                    $.fn.yiiGridView.update("jobs-grid");
                    $('#upstats-msg-done').show();
                } else {
                    $('#upstats-msg').hide();
                    $('#upstats-msg-error').show();
                }

                // $('#upstate').modal('hide');
            },
            error: function(result) {
                $('#upstats-msg').hide();
                $('#upstats-msg-error').show();
            },
            cache: false,
            contentType: false,
            processData: false
        });
    }
</script>